/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.gradle.common.util.Artifact;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;

public class MavenArtifactDownloader {
    private static final Cache<String, File> CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Map<Project, Integer> COUNTER = new HashMap<Project, Integer>();
    private static final Map<String, String> VERSIONS = new HashMap<String, String>();

    private static File _download(Project project, String artifact, boolean changing) {
        File ret = null;
        try {
            ret = (File)CACHE.get((Object)artifact, () -> MavenArtifactDownloader.gradleDownload(project, artifact, changing));
            if (ret != null && !ret.exists()) {
                CACHE.invalidate((Object)artifact);
                ret = (File)CACHE.get((Object)artifact, () -> MavenArtifactDownloader.gradleDownload(project, artifact, changing));
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File gradleDownload(Project project, String artifact, boolean changing) {
        String name = "mavenDownloader_" + artifact;
        Project project2 = project;
        synchronized (project2) {
            int count = COUNTER.getOrDefault(project, 1);
            name = name + "_" + count++;
            COUNTER.put(project, count);
        }
        Configuration cfg = (Configuration)project.getConfigurations().create(name);
        ExternalModuleDependency dependency = (ExternalModuleDependency)project.getDependencies().create((Object)artifact);
        dependency.setChanging(changing);
        cfg.getDependencies().add((Object)dependency);
        cfg.resolutionStrategy(strat -> {
            strat.cacheChangingModulesFor(5, TimeUnit.MINUTES);
            strat.cacheDynamicVersionsFor(5, TimeUnit.MINUTES);
        });
        File ret = (File)cfg.resolve().iterator().next();
        Artifact mine = Artifact.from(artifact);
        cfg.getResolvedConfiguration().getResolvedArtifacts().forEach(art -> {
            ModuleVersionIdentifier resolved = art.getModuleVersion().getId();
            if (resolved.getGroup().equals(mine.getGroup()) && resolved.getName().equals(mine.getName()) && (mine.getClassifier() == null && art.getClassifier() == null || mine.getClassifier().equals(art.getClassifier()))) {
                VERSIONS.put(artifact, resolved.getVersion());
            }
        });
        project.getConfigurations().remove((Object)cfg);
        return ret;
    }

    public static File single(Project project, String artifact) {
        return MavenArtifactDownloader.single(project, artifact, false);
    }

    public static File single(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing);
    }

    public static String getVersion(Project project, String artifact) {
        MavenArtifactDownloader.single(project, artifact);
        return VERSIONS.get(artifact);
    }
}

