/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public enum HashFunction {
    MD5("md5", 32),
    SHA1("SHA-1", 40),
    SHA256("SHA-256", 64);

    private String algo;
    private String pad;

    private HashFunction(String algo, int length) {
        this.algo = algo;
        this.pad = String.format("%0" + length + "d", 0);
    }

    public String getExtension() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public MessageDigest get() {
        try {
            return MessageDigest.getInstance(this.algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String hash(File file) throws IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            String string = this.hash(fin);
            return string;
        }
    }

    public String hash(Iterable<File> files) throws IOException {
        MessageDigest hash = this.get();
        byte[] buf = new byte[1024];
        for (File file : files) {
            if (!file.exists()) continue;
            FileInputStream fin = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int count = -1;
                while ((count = fin.read(buf)) != -1) {
                    hash.update(buf, 0, count);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fin == null) continue;
                if (throwable != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fin.close();
            }
        }
        return this.pad(new BigInteger(1, hash.digest()).toString(16));
    }

    public String hash(String data) {
        return this.hash(data == null ? new byte[]{} : data.getBytes(StandardCharsets.UTF_8));
    }

    public String hash(InputStream stream) throws IOException {
        return this.hash(IOUtils.toByteArray((InputStream)stream));
    }

    public String hash(byte[] data) {
        return this.pad(new BigInteger(1, this.get().digest(data)).toString(16));
    }

    public String pad(String hash) {
        return (this.pad + hash).substring(hash.length());
    }
}

