/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.File;

public class Artifact {
    private String group;
    private String name;
    private String version;
    private String classifier = null;
    private String ext = "jar";
    private String path;
    private String file;
    private String descriptor;

    public static Artifact from(String descriptor) {
        Artifact ret = new Artifact();
        ret.descriptor = descriptor;
        String[] pts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)descriptor), String.class);
        ret.group = pts[0];
        ret.name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            ret.ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        }
        ret.version = pts[2];
        if (pts.length > 3) {
            ret.classifier = pts[3];
        }
        ret.file = ret.name + '-' + ret.version;
        if (ret.classifier != null) {
            ret.file = ret.file + '-' + ret.classifier;
        }
        ret.file = ret.file + '.' + ret.ext;
        ret.path = ret.group.replace('.', '/') + '/' + ret.name + '/' + ret.version + '/' + ret.file;
        return ret;
    }

    public File getLocalPath(File base) {
        return new File(base, this.path.replace('/', File.separatorChar));
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getPath() {
        return this.path;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExt() {
        return this.ext;
    }

    public String getFilename() {
        return this.file;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

