/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import groovy.lang.Closure;
import groovy.util.MapEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class SignJar
extends DefaultTask
implements PatternFilterable {
    private PatternSet patternSet = new PatternSet();
    private Object alias;
    private Object storePass;
    private Object keyPass;
    private Object keyStore;
    private Object inputFile;
    private Object outputFile;

    @TaskAction
    public void doTask() throws IOException {
        HashMap ignoredStuff = Maps.newHashMap();
        File input = this.getInputFile();
        File toSign = new File(this.getTemporaryDir(), input.getName() + ".unsigned.tmp");
        File signed = new File(this.getTemporaryDir(), input.getName() + ".signed.tmp");
        File output = this.getOutputFile();
        this.processInputJar(input, toSign, ignoredStuff);
        HashMap map = Maps.newHashMap();
        map.put("alias", this.getAlias());
        map.put("storePass", this.getStorePass());
        map.put("jar", toSign.getAbsolutePath());
        map.put("signedJar", signed.getAbsolutePath());
        if (!Strings.isNullOrEmpty((String)this.getKeyPass())) {
            map.put("keypass", this.getKeyPass());
        }
        if (!Strings.isNullOrEmpty((String)this.getKeyStore())) {
            map.put("keyStore", this.getKeyStore());
        }
        this.getProject().getAnt().invokeMethod("signjar", (Object)map);
        this.writeOutputJar(signed, output, ignoredStuff);
    }

    private void processInputJar(File inputJar, File toSign, final Map<String, Map.Entry<byte[], Long>> unsigned) throws IOException {
        final Spec spec = this.patternSet.getAsSpec();
        toSign.getParentFile().mkdirs();
        final JarOutputStream outs = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(toSign)));
        this.getProject().zipTree((Object)inputJar).visit(new FileVisitor(){

            public void visitDir(FileVisitDetails details) {
                try {
                    String path = details.getPath();
                    ZipEntry entry = new ZipEntry(path.endsWith("/") ? path : path + "/");
                    outs.putNextEntry(entry);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void visitFile(FileVisitDetails details) {
                try {
                    if (spec.isSatisfiedBy((Object)details)) {
                        ZipEntry entry = new ZipEntry(details.getPath());
                        entry.setTime(details.getLastModified());
                        outs.putNextEntry(entry);
                        details.copyTo((OutputStream)outs);
                        outs.closeEntry();
                    } else {
                        InputStream stream = details.open();
                        unsigned.put(details.getPath(), new MapEntry((Object)ByteStreams.toByteArray((InputStream)stream), (Object)details.getLastModified()));
                        stream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        outs.close();
    }

    private void writeOutputJar(File signedJar, File outputJar, Map<String, Map.Entry<byte[], Long>> unsigned) throws IOException {
        ZipEntry n;
        outputJar.getParentFile().mkdirs();
        JarOutputStream outs = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar)));
        ZipFile base = new ZipFile(signedJar);
        for (ZipEntry zipEntry : Collections.list(base.entries())) {
            if (zipEntry.isDirectory()) {
                outs.putNextEntry(zipEntry);
                continue;
            }
            n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            outs.putNextEntry(n);
            ByteStreams.copy((InputStream)base.getInputStream(zipEntry), (OutputStream)outs);
            outs.closeEntry();
        }
        base.close();
        for (Map.Entry entry : unsigned.entrySet()) {
            n = new ZipEntry((String)entry.getKey());
            n.setTime((Long)((Map.Entry)entry.getValue()).getValue());
            outs.putNextEntry(n);
            outs.write((byte[])((Map.Entry)entry.getValue()).getKey());
            outs.closeEntry();
        }
        outs.close();
    }

    public PatternFilterable exclude(String ... arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Iterable<String> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Spec<FileTreeElement> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Closure arg0) {
        return this.patternSet.exclude(arg0);
    }

    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public PatternFilterable include(String ... arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Iterable<String> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Spec<FileTreeElement> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Closure arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable setExcludes(Iterable<String> arg0) {
        return this.patternSet.setExcludes(arg0);
    }

    public PatternFilterable setIncludes(Iterable<String> arg0) {
        return this.patternSet.setIncludes(arg0);
    }

    @InputFile
    public File getInputFile() {
        if (this.inputFile == null) {
            return null;
        }
        return this.getProject().file(this.inputFile);
    }

    public void setInputFile(Object inputFile) {
        this.inputFile = inputFile;
    }

    @OutputFile
    public File getOutputFile() {
        if (this.outputFile == null) {
            return null;
        }
        return this.getProject().file(this.outputFile);
    }

    public void setOutputFile(Object outputFile) {
        this.outputFile = outputFile;
    }

    @Input
    public String getAlias() {
        return Utils.resolveString(this.alias);
    }

    public void setAlias(Object alias) {
        this.alias = alias;
    }

    @Input
    public String getStorePass() {
        return Utils.resolveString(this.storePass);
    }

    public void setStorePass(Object storePass) {
        this.storePass = storePass;
    }

    @Input
    public String getKeyPass() {
        return Utils.resolveString(this.keyPass);
    }

    public void setKeyPass(Object keyPass) {
        this.keyPass = keyPass;
    }

    @Input
    public String getKeyStore() {
        return Utils.resolveString(this.keyStore);
    }

    public void setKeyStore(Object keyStore) {
        this.keyStore = keyStore;
    }
}

