/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.diff;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class PatchFile {
    private final PatchSupplier supplier;
    private final boolean requiresFurtherProcessing;

    public static PatchFile from(String string) {
        return new PatchFile(() -> new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)), false);
    }

    public static PatchFile from(byte[] data) {
        return new PatchFile(() -> new ByteArrayInputStream(data), false);
    }

    public static PatchFile from(File file) {
        return new PatchFile(() -> new FileInputStream(file), true);
    }

    private PatchFile(PatchSupplier supplier, boolean requiresFurtherProcessing) {
        this.supplier = supplier;
        this.requiresFurtherProcessing = requiresFurtherProcessing;
    }

    InputStream openStream() throws IOException {
        return this.supplier.get();
    }

    boolean requiresFurtherProcessing() {
        return this.requiresFurtherProcessing;
    }

    static interface PatchSupplier {
        public InputStream get() throws IOException;
    }
}

