/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;

public class RenameJarSrg2Mcp
extends JarExec {
    private Supplier<File> input;
    private File output;
    private Supplier<File> mappings;
    private boolean signatureRemoval;

    public RenameJarSrg2Mcp() {
        this.tool = "net.minecraftforge:installertools:1.1.10:fatjar";
        this.args = new String[]{"--task", "SRG_TO_MCP", "--input", "{input}", "--output", "{output}", "--mcp", "{mappings}", "{strip}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        replace.put("{mappings}", this.getMappings().getAbsolutePath());
        replace.put("{strip}", this.getSignatureRemoval() ? "--strip-signatures" : "");
        return Arrays.stream(this.getArgs()).map(arg -> replace.getOrDefault(arg, (String)arg)).filter(it -> !it.isEmpty()).collect(Collectors.toList());
    }

    public boolean getSignatureRemoval() {
        return this.signatureRemoval;
    }

    public void setSignatureRemoval(boolean value) {
        this.signatureRemoval = value;
    }

    @InputFile
    public File getMappings() {
        return this.mappings.get();
    }

    public void setMappings(File value) {
        this.mappings = () -> value;
    }

    public void setMappings(Supplier<File> value) {
        this.mappings = value;
    }

    @InputFile
    public File getInput() {
        return this.input.get();
    }

    public void setInput(File value) {
        this.input = () -> value;
    }

    public void setInput(Supplier<File> value) {
        this.input = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

