/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.cloudbees.diff.Diff;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class TaskGeneratePatches
extends DefaultTask {
    private String originalPrefix = "a/";
    private String modifiedPrefix = "b/";
    private File clean;
    private File modified;
    private File patches;

    @TaskAction
    public void generatePatches() throws IOException {
        HashSet paths = new HashSet();
        Files.walk(this.getPatches().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(paths::add);
        try (ZipFile clean = new ZipFile(this.getClean());
             ZipFile dirty = new ZipFile(this.getModified());){
            Set _old = Collections.list(clean.entries()).stream().filter(e -> !e.isDirectory()).map(e -> e.getName()).collect(Collectors.toSet());
            Set _new = Collections.list(dirty.entries()).stream().filter(e -> !e.isDirectory()).map(e -> e.getName()).collect(Collectors.toSet());
            for (String o : _old) {
                ZipEntry newEntry = dirty.getEntry(o);
                String diff = this.makePatch(o, clean.getInputStream(clean.getEntry(o)), newEntry == null ? null : dirty.getInputStream(newEntry));
                _new.remove(o);
                if (diff == null) continue;
                File patch = new File(this.getPatches(), o + ".patch");
                this.writePatch(patch, diff);
                paths.remove(patch.toPath());
            }
            for (String n : _new) {
                String diff = this.makePatch(n, null, dirty.getInputStream(dirty.getEntry(n)));
                if (diff == null) continue;
                File patch = new File(this.getPatches(), n + ".patch");
                this.writePatch(patch, diff);
                paths.remove(patch.toPath());
            }
        }
        paths.forEach(p -> p.toFile().delete());
        List<File> dirs = Files.walk(this.getPatches().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.toFile()).collect(Collectors.toList());
        Collections.reverse(dirs);
        dirs.forEach(p -> {
            if (p.list().length == 0) {
                p.delete();
            }
        });
    }

    private void writePatch(File patch, String diff) throws IOException {
        File parent = patch.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(patch);){
            IOUtils.write((String)diff, (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
        }
    }

    private String makePatch(String relative, InputStream original, InputStream modified) throws IOException {
        String modifiedData;
        String originalRelative = original == null ? "/dev/null" : this.originalPrefix + relative;
        String modifiedRelative = modified == null ? "/dev/null" : this.modifiedPrefix + relative;
        String originalData = original == null ? "" : new String(IOUtils.toByteArray((InputStream)original), StandardCharsets.UTF_8);
        Diff diff = Diff.diff((Reader)new StringReader(originalData), (Reader)new StringReader(modifiedData = modified == null ? "" : new String(IOUtils.toByteArray((InputStream)modified), StandardCharsets.UTF_8)), (boolean)false);
        if (!diff.isEmpty()) {
            return diff.toUnifiedDiff(originalRelative, modifiedRelative, (Reader)new StringReader(originalData), (Reader)new StringReader(modifiedData), 3).replaceAll("\r?\n", "\n");
        }
        return null;
    }

    @InputFile
    public File getClean() {
        return this.clean;
    }

    @InputFile
    public File getModified() {
        return this.modified;
    }

    @Input
    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    @Input
    public String getModifiedPrefix() {
        return this.modifiedPrefix;
    }

    @OutputDirectory
    public File getPatches() {
        return this.patches;
    }

    public void setClean(File clean) {
        this.clean = clean;
    }

    public void setModified(File modified) {
        this.modified = modified;
    }

    public void setOriginalPrefix(String value) {
        this.originalPrefix = value;
    }

    public void setModifiedPrefix(String value) {
        this.modifiedPrefix = value;
    }

    public void setPatches(File patches) {
        this.patches = patches;
    }
}

