/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.config.UserdevConfigV2;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.gradle.api.Project;

public class PatcherExtension
extends MinecraftExtension {
    public static final String EXTENSION_NAME = "patcher";
    public Project parent;
    public File cleanSrc;
    public File patchedSrc;
    public File patches;
    public String mcVersion;
    public boolean srgPatches = true;
    private boolean notchObf = false;
    private List<File> excs;
    private List<Object> extraExcs;
    private List<Object> extraMappings;
    private UserdevConfigV2.DataFunction processor;
    private Map<String, File> processorData;

    public PatcherExtension(@Nonnull Project project) {
        super(project);
        ImmutableMap.builder().put((Object)(project.getName() + "_client"), (Object)"mcp.client.Start").put((Object)(project.getName() + "_server"), (Object)"net.minecraft.server.MinecraftServer").build().forEach((name, main) -> {
            RunConfig run = new RunConfig(project, (String)name);
            run.setTaskName((String)name);
            run.setMain((String)main);
            try {
                run.setWorkingDirectory(project.file((Object)"run").getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getRuns().add((Object)run);
        });
    }

    public void setParent(Project parent) {
        this.parent = parent;
    }

    public void parent(Project parent) {
        this.setParent(parent);
    }

    public Project getParent() {
        return this.parent;
    }

    public void setCleanSrc(File cleanSrc) {
        this.cleanSrc = cleanSrc;
    }

    public void cleanSrc(File cleanSrc) {
        this.setCleanSrc(cleanSrc);
    }

    public File getCleanSrc() {
        return this.cleanSrc;
    }

    public void setPatchedSrc(File patchedSrc) {
        this.patchedSrc = patchedSrc;
    }

    public void patchedSrc(File patchedSrc) {
        this.setPatchedSrc(patchedSrc);
    }

    public File getPatchedSrc() {
        return this.patchedSrc;
    }

    public void setPatches(File patches) {
        this.patches = patches;
    }

    public void patches(File patches) {
        this.setPatches(patches);
    }

    public File getPatches() {
        return this.patches;
    }

    public void setMcVersion(String mcVersion) {
        this.mcVersion = mcVersion;
    }

    public void mcVersion(String mcVersion) {
        this.setMcVersion(mcVersion);
    }

    public String getMcVersion() {
        return this.mcVersion;
    }

    public void setSrgPatches(boolean srgPatches) {
        this.srgPatches = srgPatches;
    }

    public void srgPatches(boolean srgPatches) {
        this.setSrgPatches(srgPatches);
    }

    public void srgPatches() {
        this.setSrgPatches(true);
    }

    public boolean isSrgPatches() {
        return this.srgPatches;
    }

    public void setNotchObf(boolean value) {
        this.notchObf = value;
    }

    public boolean getNotchObf() {
        return this.notchObf;
    }

    public void setExcs(List<File> excs) {
        this.excs = new ArrayList<File>(excs);
    }

    public void setExcs(File ... excs) {
        this.setExcs(Arrays.asList(excs));
    }

    public void setExc(File exc) {
        this.setExcs(exc);
    }

    public void excs(File ... excs) {
        this.getExcs().addAll(Arrays.asList(excs));
    }

    public void exc(File exc) {
        this.excs(exc);
    }

    @Nonnull
    public List<File> getExcs() {
        if (this.excs == null) {
            this.excs = new ArrayList<File>();
        }
        return this.excs;
    }

    public void setExtraExcs(List<Object> extraExcs) {
        this.extraExcs = new ArrayList<Object>(extraExcs);
    }

    public void extraExcs(Object ... excs) {
        this.getExtraExcs().addAll(Arrays.asList(excs));
    }

    public void extraExc(Object exc) {
        this.extraExcs(exc);
    }

    @Nonnull
    public List<Object> getExtraExcs() {
        if (this.extraExcs == null) {
            this.extraExcs = new ArrayList<Object>();
        }
        return this.extraExcs;
    }

    public void extraMapping(Object mapping) {
        if (!(mapping instanceof String) && !(mapping instanceof File)) {
            throw new IllegalArgumentException("Extra mappings must be a file or a string!");
        }
        this.getExtraMappings().add(mapping);
    }

    public void setExtraMappings(List<Object> extraMappings) {
        this.extraMappings = new ArrayList<Object>(extraMappings);
    }

    @Nonnull
    public List<Object> getExtraMappings() {
        if (this.extraMappings == null) {
            this.extraMappings = new ArrayList<Object>();
        }
        return this.extraMappings;
    }

    public UserdevConfigV2.DataFunction getProcessor() {
        return this.processor;
    }

    public void setProcessor(Map<String, Object> map) {
        this.processor(map);
    }

    public Map<String, File> getProcessorData() {
        return this.processorData == null ? Collections.emptyMap() : this.processorData;
    }

    public void processor(Map<String, Object> map) {
        this.processor = new UserdevConfigV2.DataFunction();
        map.forEach((key, value) -> {
            if ("tool".equals(key)) {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("'tool' must be a string");
                }
                this.processor.setVersion((String)value);
                return;
            } else if ("args".equals(key)) {
                if (value instanceof String) {
                    this.processor.setArgs(Arrays.asList((String)value));
                    return;
                } else if (value instanceof String[]) {
                    this.processor.setArgs(Arrays.asList((String[])value));
                    return;
                } else {
                    if (!(value instanceof Collection)) throw new IllegalArgumentException("'args' must be a String, or array of Strings");
                    this.processor.setArgs(new ArrayList<String>((Collection)value));
                }
                return;
            } else if ("repo".equals(key)) {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("'repo' must be a string");
                }
                this.processor.setRepo((String)value);
                return;
            } else {
                if (!"data".equals(key)) throw new IllegalArgumentException("Invalid processor key " + key);
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException("'data' must be a map of string -> file");
                }
                this.processorData = (Map)value;
            }
        });
    }

    void copyFrom(PatcherExtension other) {
        if (this.mapping_channel == null) {
            this.setMappingChannel(other.getMappingChannel());
        }
        if (this.mapping_version == null) {
            this.setMappingVersion(other.getMappingVersion());
        }
        if (this.mcVersion == null) {
            this.setMcVersion(other.getMcVersion());
        }
    }
}

