/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.gradle.mcp.function.AbstractFileDownloadFunction;
import net.minecraftforge.gradle.mcp.function.DownloadVersionJSONFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.gradle.internal.hash.HashValue;

public abstract class AbstractDownloadMCFunction
extends AbstractFileDownloadFunction {
    public AbstractDownloadMCFunction(String artifact) {
        super((MCPEnvironment env) -> artifact + ".jar", (MCPEnvironment env) -> AbstractDownloadMCFunction.getDownloadInfo(env, artifact));
    }

    private static AbstractFileDownloadFunction.DownloadInfo getDownloadInfo(MCPEnvironment environment, String artifact) {
        try {
            Gson gson = new Gson();
            FileReader reader = new FileReader(environment.getStepOutput(DownloadVersionJSONFunction.class));
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            JsonObject artifactInfo = json.getAsJsonObject("downloads").getAsJsonObject(artifact);
            String url = artifactInfo.get("url").getAsString();
            HashValue hash = HashValue.parse((String)artifactInfo.get("sha1").getAsString());
            String version = json.getAsJsonObject().get("id").getAsString();
            return new AbstractFileDownloadFunction.DownloadInfo(url, hash, "jar", version, artifact);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

