/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskApplyMappings
extends DefaultTask {
    private boolean javadocs = false;
    private boolean lambdas = true;
    private File mappings;
    private File input;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.zip"));

    @TaskAction
    public void apply() throws IOException {
        McpNames names = McpNames.load(this.getMappings());
        try (ZipFile zin = new ZipFile(this.getInput());
             FileOutputStream fos = new FileOutputStream(this.getOutput());
             ZipOutputStream out = new ZipOutputStream(fos);){
            zin.stream().forEach(e -> {
                try {
                    out.putNextEntry(Utils.getStableEntry(e.getName()));
                    if (!e.getName().endsWith(".java")) {
                        IOUtils.copy((InputStream)zin.getInputStream((ZipEntry)e), (OutputStream)out);
                    } else {
                        out.write(names.rename(zin.getInputStream((ZipEntry)e), this.getJavadocs(), this.getLambdas()).getBytes(StandardCharsets.UTF_8));
                    }
                    out.closeEntry();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            });
        }
    }

    @Input
    public boolean getJavadocs() {
        return this.javadocs;
    }

    @Input
    public boolean getLambdas() {
        return this.lambdas;
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    @InputFile
    public File getMappings() {
        return this.mappings;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setJavadocs(boolean value) {
        this.javadocs = value;
    }

    public void setLambdas(boolean value) {
        this.lambdas = value;
    }

    public void setInput(File clean) {
        this.input = clean;
    }

    public void setMappings(File value) {
        this.mappings = value;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

