/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;

public class AccessTransformJar
extends JarExec {
    private File input;
    private File output;
    private List<File> ats;

    public AccessTransformJar() {
        this.tool = "net.minecraftforge:accesstransformers:1.0.+:fatjar";
        this.args = new String[]{"--inJar", "{input}", "--outJar", "{output}", "--logFile", "accesstransform.log"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        List<String> ret = Arrays.stream(this.getArgs()).map(arg -> replace.getOrDefault(arg, (String)arg)).collect(Collectors.toList());
        this.ats.forEach(f -> {
            ret.add("--atFile");
            ret.add(f.getAbsolutePath());
        });
        return ret;
    }

    @InputFiles
    public List<File> getAts() {
        return this.ats;
    }

    public void setAts(Iterable<File> values) {
        if (this.ats == null) {
            this.ats = new ArrayList<File>();
        }
        values.forEach(this.ats::add);
    }

    public void setAts(File ... values) {
        if (this.ats == null) {
            this.ats = new ArrayList<File>();
        }
        for (File value : values) {
            this.ats.add(value);
        }
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    public void setInput(File value) {
        this.input = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

