/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.gradle.mcp.function.AbstractFileDownloadFunction;
import net.minecraftforge.gradle.mcp.function.DownloadManifestFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;

public class DownloadVersionJSONFunction
extends AbstractFileDownloadFunction {
    private static final String DEFAULT_OUTPUT = "version.json";

    public DownloadVersionJSONFunction() {
        super((MCPEnvironment env) -> DEFAULT_OUTPUT, DownloadVersionJSONFunction::getDownloadInfo);
    }

    private static AbstractFileDownloadFunction.DownloadInfo getDownloadInfo(MCPEnvironment environment) {
        try {
            Gson gson = new Gson();
            FileReader reader = new FileReader(environment.getStepOutput(DownloadManifestFunction.class));
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            for (JsonElement e : json.getAsJsonArray("versions")) {
                String v = e.getAsJsonObject().get("id").getAsString();
                if (!v.equals(environment.getMinecraftVersion().toString())) continue;
                return new AbstractFileDownloadFunction.DownloadInfo(e.getAsJsonObject().get("url").getAsString(), null);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }
}

