/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.repository.ArtifactProvider;
import com.amadornes.artifactural.api.repository.Repository;
import com.amadornes.artifactural.base.repository.ArtifactProviderBuilder;
import com.amadornes.artifactural.base.repository.SimpleRepository;
import com.amadornes.artifactural.gradle.GradleRepositoryAdapter;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.ManifestJson;
import net.minecraftforge.gradle.common.util.POMBuilder;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.logging.Logger;

public class MinecraftRepo
extends BaseRepo {
    private static MinecraftRepo INSTANCE;
    private static final String GROUP = "net.minecraft";
    public static final String MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    public static final String CURRENT_OS;
    private static int CACHE_BUSTER;
    private static final MinecraftVersion v1_14_4;
    private final Repository repo = SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).filter(ArtifactIdentifier.groupEquals((String)"net.minecraft")).filter(ArtifactIdentifier.nameMatches((String)"^(client|server)$")).provide((ArtifactProvider)this));
    private final boolean offline;

    private MinecraftRepo(File cache, Logger log, boolean offline) {
        super(cache, log);
        this.offline = offline;
    }

    private static MinecraftRepo getInstance(Project project) {
        if (INSTANCE == null) {
            INSTANCE = new MinecraftRepo(Utils.getCache(project, "minecraft_repo"), project.getLogger(), project.getGradle().getStartParameter().isOffline());
        }
        return INSTANCE;
    }

    public static void attach(Project project) {
        MinecraftRepo instance = MinecraftRepo.getInstance(project);
        GradleRepositoryAdapter.add((RepositoryHandler)project.getRepositories(), (String)"MINECRAFT_DYNAMIC", (File)instance.getCacheRoot(), (Repository)instance.repo);
    }

    public static ArtifactProvider<ArtifactIdentifier> create(Project project) {
        return MinecraftRepo.getInstance(project);
    }

    protected String getMappings(String version) {
        if (!version.contains("_mapped_")) {
            return null;
        }
        return version.split("_mapped_")[0];
    }

    private HashStore commonCache(File file) throws IOException {
        HashStore ret = new HashStore(this.getCacheRoot()).load(new File(file.getAbsolutePath() + ".input"));
        ret.bust(CACHE_BUSTER);
        return ret;
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String mappings;
        String side = artifact.getName();
        if (!artifact.getGroup().equals(GROUP) || !"client".equals(side) && !"server".equals(side)) {
            return null;
        }
        String version = artifact.getVersion();
        boolean forceStable = version.endsWith("-stable");
        if (forceStable) {
            version = version.substring(0, version.length() - 7);
        }
        if ((mappings = this.getMappings(version)) != null) {
            return null;
        }
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        String ext = artifact.getExtension();
        File json = this.findVersion(version);
        if (json == null) {
            return null;
        }
        this.debug("  " + this.REPO_NAME + " Request: " + artifact.getGroup() + ":" + side + ":" + version + ":" + classifier + "@" + ext);
        if ("pom".equals(ext)) {
            return this.findPom(side, version, json);
        }
        if ("json".equals(ext)) {
            if ("".equals(classifier)) {
                return this.findVersion(version);
            }
        } else {
            switch (classifier) {
                case "": {
                    return this.findRaw(side, version, json);
                }
                case "slim": {
                    return this.findSlim(side, version, forceStable, json);
                }
                case "data": {
                    return this.findData(side, version, forceStable, json);
                }
                case "extra": {
                    return this.findExtra(side, version, forceStable, json);
                }
                case "mappings": {
                    return this.findMappings(side, version, json);
                }
            }
        }
        return null;
    }

    private File findMcp(String version) throws IOException {
        Artifact mcp = Artifact.from("de.oceanlabs.mcp:mcp_config:" + version + "@zip");
        File zip = this.cache("versions", version, "mcp.zip");
        if (!zip.exists()) {
            FileUtils.copyURLToFile((URL)new URL("https://files.minecraftforge.net/maven/" + mcp.getPath()), (File)zip);
            Utils.updateHash(zip);
        }
        return zip;
    }

    private File findMcpMappings(String version) throws IOException {
        File mcp = this.findMcp(version);
        if (mcp == null) {
            return null;
        }
        File mappings = this.cache("versions", version, "mcp_mappings.tsrg");
        HashStore cache = this.commonCache(this.cache("versions", version, "mcp_mappings.tsrg"));
        cache.add(mcp);
        if (!cache.isSame() || !mappings.exists()) {
            MCPWrapperSlim wrapper = new MCPWrapperSlim(mcp);
            wrapper.extractData(mappings, "mappings");
            cache.save();
            Utils.updateHash(mappings);
        }
        return mappings;
    }

    private File findVersion(String version) throws IOException {
        File manifest = this.cache("versions/manifest.json");
        if (!Utils.downloadEtag(new URL(MANIFEST_URL), manifest, this.offline)) {
            return null;
        }
        Utils.updateHash(manifest, HashFunction.SHA1);
        File json = this.cache("versions", version, "version.json");
        URL url = Utils.loadJson(manifest, ManifestJson.class).getUrl(version);
        if (url == null) {
            throw new RuntimeException("Missing version from manifest: " + version);
        }
        if (!Utils.downloadEtag(url, json, this.offline)) {
            return null;
        }
        Utils.updateHash(json, HashFunction.SHA1);
        return json;
    }

    protected File findPom(String side, String version, File json) throws IOException {
        File pom = this.cache("versions", version, side + ".pom");
        HashStore cache = this.commonCache(this.cache("versions", version, side + ".pom"));
        if ("client".equals(side)) {
            cache.add(json);
        }
        if (!cache.isSame() || !pom.exists()) {
            POMBuilder builder = new POMBuilder(GROUP, side, version);
            if ("client".equals(side)) {
                VersionJson meta = Utils.loadJson(json, VersionJson.class);
                for (VersionJson.Library lib : meta.libraries) {
                    if (!lib.isAllowed()) continue;
                    builder.dependencies().add(lib.name, "compile");
                    if (lib.downloads.classifiers == null) continue;
                    if (lib.downloads.classifiers.containsKey("test")) {
                        builder.dependencies().add(lib.name, "test").withClassifier("test");
                    }
                    if (lib.natives == null || !lib.natives.containsKey(CURRENT_OS) || lib.getArtifact().getName().contains("java-objc-bridge")) continue;
                    builder.dependencies().add(lib.name, "runtime").withClassifier(lib.natives.get(CURRENT_OS));
                }
            }
            builder.dependencies().add("net.minecraft:" + side + ":" + version, "compile").withClassifier("extra");
            builder.dependencies().add("com.google.code.findbugs:jsr305:3.0.1", "compile");
            String ret = builder.tryBuild();
            if (ret == null) {
                return null;
            }
            FileUtils.writeByteArrayToFile((File)pom, (byte[])ret.getBytes());
            cache.save();
            Utils.updateHash(pom);
        }
        return pom;
    }

    private File findMappings(String side, String version, File json_file) throws IOException {
        return this.findDownloadEntry(side + "_mappings", this.cache("versions", version, side + "_mappings.txt"), version, json_file);
    }

    private File findRaw(String side, String version, File json_file) throws IOException {
        return this.findDownloadEntry(side, this.cache("versions", version, side + ".jar"), version, json_file);
    }

    private File findDownloadEntry(String key, File target, String version, File json_file) throws IOException {
        VersionJson json = Utils.loadJson(json_file, VersionJson.class);
        if (json.downloads == null || !json.downloads.containsKey(key)) {
            throw new IllegalStateException(version + ".json missing download for " + key);
        }
        VersionJson.Download dl = json.downloads.get(key);
        if (!target.exists() || !HashFunction.SHA1.hash(target).equals(dl.sha1)) {
            FileUtils.copyURLToFile((URL)dl.url, (File)target);
            Utils.updateHash(target, HashFunction.SHA1);
        }
        return target;
    }

    private File findExtra(String side, String version, boolean forceStable, File json) throws IOException {
        boolean stable = v1_14_4.compareTo(MinecraftVersion.from((String)version)) < 0;
        File raw = this.findRaw(side, version, json);
        File mappings = this.findMcpMappings(version);
        File extra = this.cache("versions", version, side + "-extra" + (forceStable && !stable ? "-stable" : "") + ".jar");
        HashStore cache = this.commonCache(this.cache("versions", version, side + "-extra" + (forceStable && !stable ? "-stable" : "") + ".jar")).add("raw", raw).add("mappings", mappings).add("codever", "1");
        if (!cache.isSame() || !extra.exists()) {
            MinecraftRepo.splitJar(raw, mappings, extra, false, stable || forceStable);
            cache.save();
        }
        return extra;
    }

    private File findSlim(String side, String version, boolean forceStable, File json) throws IOException {
        boolean stable = v1_14_4.compareTo(MinecraftVersion.from((String)version)) < 0;
        File raw = this.findRaw(side, version, json);
        File mappings = this.findMcpMappings(version);
        File extra = this.cache("versions", version, side + "-slim" + (forceStable && !stable ? "-stable" : "") + ".jar");
        HashStore cache = this.commonCache(this.cache("versions", version, side + "-slim" + (forceStable && !stable ? "-stable" : "") + ".jar")).add("raw", raw).add("mappings", mappings).add("codever", "1");
        if (!cache.isSame() || !extra.exists()) {
            MinecraftRepo.splitJar(raw, mappings, extra, true, stable || forceStable);
            cache.save();
        }
        return extra;
    }

    private static void splitJar(File raw, File mappings, File output, boolean slim, boolean stable) throws IOException {
        try (FileInputStream input = new FileInputStream(mappings);){
            MinecraftRepo.splitJar(raw, input, output, slim, stable);
        }
    }

    public static void splitJar(File raw, InputStream mappings, File output, boolean slim, boolean stable) throws IOException {
        try (ZipFile zin = new ZipFile(raw);
             FileOutputStream fos = new FileOutputStream(output);
             ZipOutputStream out = new ZipOutputStream(fos);){
            HashSet whitelist = new HashSet();
            List lines = Utils.lines(mappings).map(line -> line.split("#")[0]).filter(l -> !Strings.isNullOrEmpty((String)l.trim())).collect(Collectors.toList());
            lines.stream().filter(line -> !line.startsWith("\t") || line.indexOf(58) != -1 && line.startsWith("CL:")).map(line -> line.indexOf(58) != -1 ? line.substring(4).split(" ") : line.split(" ")).filter(pts -> ((String[])pts).length == 2 && !pts[0].endsWith("/")).forEach(pts -> whitelist.add(pts[0]));
            Enumeration<? extends ZipEntry> entries = zin.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    boolean isNotch = whitelist.contains(name.substring(0, name.length() - 6));
                    if (slim != isNotch) continue;
                    ZipEntry _new = Utils.getStableEntry(name, stable ? 628041600000L : 0L);
                    out.putNextEntry(_new);
                    try (InputStream ein = zin.getInputStream(entry);){
                        IOUtils.copy((InputStream)ein, (OutputStream)out);
                    }
                    out.closeEntry();
                    continue;
                }
                if (slim) continue;
                ZipEntry _new = Utils.getStableEntry(name, stable ? 628041600000L : 0L);
                out.putNextEntry(_new);
                try (InputStream ein = zin.getInputStream(entry);){
                    IOUtils.copy((InputStream)ein, (OutputStream)out);
                }
                out.closeEntry();
            }
        }
        Utils.updateHash(output);
    }

    private File findData(String side, String version, boolean forceStable, File json) throws IOException {
        boolean stable = v1_14_4.compareTo(MinecraftVersion.from((String)version)) < 0 || forceStable;
        File raw = this.findRaw(side, version, json);
        File extra = this.cache("versions", version, side + "-data" + (forceStable && !stable ? "-stable" : "") + ".jar");
        HashStore cache = this.commonCache(this.cache("versions", version, side + "-data" + (forceStable && !stable ? "-stable" : "") + ".jar")).add("raw", raw).add("codever", "1");
        if (!cache.isSame() || !extra.exists()) {
            try (ZipFile zin = new ZipFile(raw);
                 FileOutputStream fos = new FileOutputStream(extra);
                 ZipOutputStream out = new ZipOutputStream(fos);){
                Enumeration<? extends ZipEntry> entries = zin.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.endsWith(".class")) continue;
                    ZipEntry _new = Utils.getStableEntry(name, stable || forceStable ? 628041600000L : 0L);
                    out.putNextEntry(_new);
                    try (InputStream ein = zin.getInputStream(entry);){
                        IOUtils.copy((InputStream)ein, (OutputStream)out);
                    }
                    out.closeEntry();
                }
            }
            cache.save();
            Utils.updateHash(extra);
        }
        return extra;
    }

    static {
        CURRENT_OS = VersionJson.OS.getCurrent().getName();
        CACHE_BUSTER = 1;
        v1_14_4 = MinecraftVersion.from((String)"1.14.4");
    }

    private static class MCPWrapperSlim {
        private final File data;
        private final MCPConfigV1 config;

        public MCPWrapperSlim(File data) throws IOException {
            this.data = data;
            byte[] cfg_data = Utils.getZipData(data, "config.json");
            int spec = Config.getSpec(cfg_data);
            if (spec != 1) {
                throw new IllegalStateException("Could not load MCP config, Unknown Spec: " + spec + " File: " + data);
            }
            this.config = MCPConfigV1.get(cfg_data);
        }

        public void extractData(File target, String ... path) throws IOException {
            String name = this.config.getData(path);
            if (name == null) {
                throw new IOException("Unknown MCP Entry: " + Joiner.on((String)"/").join((Object[])path));
            }
            try (ZipFile zip = new ZipFile(this.data);){
                Utils.extractFile(zip, name, target);
            }
        }
    }
}

