/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.JavadocAdder;
import org.apache.commons.lang3.tuple.Pair;

public class McpNames {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Pattern SRG_FINDER = Pattern.compile("func_[0-9]+_[a-zA-Z_]+|field_[0-9]+_[a-zA-Z_]+|p_[\\w]+_\\d+_\\b");
    private static final Pattern METHOD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*(?<generic><[\\w\\W]*>\\s+)?(?<return>\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*)\\s+(?<name>func_[0-9]+_[a-zA-Z_]+)\\(");
    private static final Pattern FIELD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*(?:\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*)\\s+(?<name>field_[0-9]+_[a-zA-Z_]+) *(?:=|;)");
    private static final Pattern CLASS_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: )*|\\t*)([\\w|@]*\\s)*(class|interface|@interface|enum) (?<name>[\\w]+)");
    private static final Pattern CLOSING_CURLY_BRACE = Pattern.compile("^(?<indent>(?: )*|\\t*)}");
    private static final Pattern PACKAGE_DECL = Pattern.compile("^[\\s]*package(\\s)*(?<name>[\\w|.]+);$");
    private Map<String, String> names;
    private Map<String, String> docs;
    public final String hash;

    public static McpNames load(File data) throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> docs = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(data);){
            List entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).collect(Collectors.toList());
            for (ZipEntry entry : entries) {
                CsvReader reader = new CsvReader();
                reader.setContainsHeader(true);
                CsvContainer csv = reader.read((Reader)new InputStreamReader(zip.getInputStream(entry)));
                for (CsvRow row : csv.getRows()) {
                    String searge = row.getField("searge");
                    if (searge == null) {
                        searge = row.getField("param");
                    }
                    String desc = row.getField("desc");
                    names.put(searge, row.getField("name"));
                    if (desc == null) continue;
                    docs.put(searge, desc);
                }
            }
        }
        return new McpNames(HashFunction.SHA1.hash(data), names, docs);
    }

    private McpNames(String hash, Map<String, String> names, Map<String, String> docs) {
        this.hash = hash;
        this.names = names;
        this.docs = docs;
    }

    public String rename(InputStream stream, boolean javadocs) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        LinkedList<Pair<String, Integer>> innerClasses = new LinkedList<Pair<String, Integer>>();
        String _package = "";
        for (String line : CharStreams.readLines((Readable)new InputStreamReader(stream))) {
            Matcher m = PACKAGE_DECL.matcher(line);
            if (m.find()) {
                _package = m.group("name") + ".";
            }
            if (javadocs && !this.injectJavadoc(lines, line, _package, innerClasses)) {
                javadocs = false;
            }
            lines.add(this.replaceInLine(line));
        }
        return Joiner.on((String)NEWLINE).join(lines);
    }

    public String rename(String entry) {
        return this.names.getOrDefault(entry, entry);
    }

    private boolean injectJavadoc(List<String> lines, String line, String _package, Deque<Pair<String, Integer>> innerClasses) {
        Matcher matcher = METHOD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String javadoc = this.docs.get(matcher.group("name"));
            if (!Strings.isNullOrEmpty((String)javadoc)) {
                McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, true));
            }
            return true;
        }
        matcher = FIELD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String javadoc = this.docs.get(matcher.group("name"));
            if (!Strings.isNullOrEmpty((String)javadoc)) {
                McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, false));
            }
            return true;
        }
        matcher = CLASS_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String currentClass = (innerClasses.isEmpty() ? _package : (String)innerClasses.peek().getLeft() + "$") + matcher.group("name");
            innerClasses.push((Pair<String, Integer>)Pair.of((Object)currentClass, (Object)matcher.group("indent").length()));
            String javadoc = this.docs.get(currentClass);
            if (!Strings.isNullOrEmpty((String)javadoc)) {
                McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, true));
            }
            return true;
        }
        matcher = CLOSING_CURLY_BRACE.matcher(line);
        if (matcher.find() && !innerClasses.isEmpty()) {
            int len = matcher.group("indent").length();
            if (len == (Integer)innerClasses.peek().getRight()) {
                innerClasses.pop();
            } else if (len < (Integer)innerClasses.peek().getRight()) {
                System.err.println("Failed to properly track class blocks around class " + (String)innerClasses.peek().getLeft() + ":" + (lines.size() + 1));
                return false;
            }
        }
        return true;
    }

    private static void insertAboveAnnotations(List<String> list, String line) {
        int back = 0;
        while (list.get(list.size() - 1 - back).trim().startsWith("@")) {
            ++back;
        }
        list.add(list.size() - back, line);
    }

    private String replaceInLine(String line) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = SRG_FINDER.matcher(line);
        while (matcher.find()) {
            matcher.appendReplacement(buf, this.names.getOrDefault(matcher.group(), matcher.group()));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

