/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.google.common.io.Files;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV2;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.MCPExtension;
import net.minecraftforge.gradle.patcher.PatcherExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskGenerateUserdevConfig
extends DefaultTask {
    private final NamedDomainObjectContainer<RunConfig> runs;
    private Set<File> ats = new TreeSet<File>();
    private Set<File> sass = new TreeSet<File>();
    private Set<File> srgs = new TreeSet<File>();
    private List<String> srgLines = new ArrayList<String>();
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.json"));
    private String universal;
    private String source;
    private String tool;
    private String[] args;
    private List<String> libraries;
    private String inject;
    private UserdevConfigV2.DataFunction processor;
    private Map<String, File> processorData = new HashMap<String, File>();
    private String patchesOriginalPrefix;
    private String patchesModifiedPrefix;
    private boolean notchObf = false;
    private List<String> universalFilters;

    @Inject
    public TaskGenerateUserdevConfig(@Nonnull Project project) {
        this.runs = project.container(RunConfig.class, name -> new RunConfig(project, name));
    }

    @TaskAction
    public void apply() throws IOException {
        UserdevConfigV2 json = new UserdevConfigV2();
        json.spec = this.isV2() ? 2 : 1;
        json.binpatches = "joined.lzma";
        json.sources = this.source;
        json.universal = this.universal;
        json.patches = "patches/";
        json.inject = "inject/";
        if (this.libraries != null && !this.libraries.isEmpty()) {
            this.libraries.forEach(json::addLibrary);
        }
        this.getATs().forEach(at -> json.addAT("ats/" + at.getName()));
        this.getSASs().forEach(at -> json.addSAS("sas/" + at.getName()));
        this.getSRGs().forEach(srg -> json.addSRG("srgs/" + srg.getName()));
        this.getSRGLines().forEach(json::addSRG);
        this.addParent(json, this.getProject());
        this.runs.getAsMap().forEach(json::addRun);
        json.binpatcher = new MCPConfigV1.Function();
        json.binpatcher.setVersion(this.getTool());
        json.binpatcher.setArgs(Arrays.asList(this.args));
        if (this.isV2()) {
            json.processor = this.processor;
            json.patchesOriginalPrefix = this.patchesOriginalPrefix;
            json.patchesModifiedPrefix = this.patchesModifiedPrefix;
            json.setNotchObf(this.notchObf);
            if (this.universalFilters != null) {
                this.universalFilters.forEach(json::addUniversalFilter);
            }
        }
        Files.write((byte[])Utils.GSON.toJson((Object)json).getBytes(StandardCharsets.UTF_8), (File)this.getOutput());
    }

    private void addParent(UserdevConfigV1 json, Project project) {
        PatcherExtension patcher = (PatcherExtension)((Object)project.getExtensions().findByType(PatcherExtension.class));
        MCPExtension mcp = (MCPExtension)project.getExtensions().findByType(MCPExtension.class);
        if (patcher != null) {
            if (project != this.getProject() && patcher.patches != null && json.parent == null) {
                json.parent = String.format("%s:%s:%s:userdev", project.getGroup(), project.getName(), project.getVersion());
                return;
            }
            if (patcher.parent != null) {
                this.addParent(json, patcher.parent);
            }
        } else if (json.parent == null) {
            if (mcp == null) {
                throw new IllegalStateException("Could not determine MCP parent for userdev config");
            }
            json.mcp = mcp.getConfig().toString();
        }
    }

    private boolean isV2() {
        return this.notchObf || this.processor != null || this.universalFilters != null && !this.universalFilters.isEmpty() || !"a/".equals(this.patchesOriginalPrefix) || !"b/".equals(this.patchesModifiedPrefix);
    }

    @Input
    public List<String> getLibraries() {
        return this.libraries == null ? Collections.emptyList() : this.libraries;
    }

    public void setLibrary(String value) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<String>();
        }
        this.libraries.add(value);
    }

    public void addLibrary(String value) {
        this.setLibrary(value);
    }

    @Input
    public String getUniversal() {
        return this.universal;
    }

    public void setUniversal(String value) {
        this.universal = value;
    }

    @Input
    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    @Input
    public String getTool() {
        return this.tool;
    }

    public void setTool(String value) {
        this.tool = value;
    }

    @Input
    @Optional
    public String getInject() {
        return this.inject;
    }

    public void setInject(String value) {
        this.inject = value;
    }

    @Input
    public String[] getArguments() {
        return this.args == null ? new String[]{} : this.args;
    }

    public void setArguments(String ... value) {
        this.args = value;
    }

    @InputFiles
    public Set<File> getATs() {
        return this.ats;
    }

    public void addAT(File value) {
        this.ats.add(value);
    }

    @InputFiles
    public Set<File> getSASs() {
        return this.sass;
    }

    public void addSAS(File value) {
        this.sass.add(value);
    }

    @InputFiles
    public Set<File> getSRGs() {
        return this.srgs;
    }

    public void addSRG(File value) {
        this.srgs.add(value);
    }

    @Input
    public List<String> getSRGLines() {
        return this.srgLines;
    }

    public void addSRGLine(String value) {
        this.srgLines.add(value);
    }

    @Nonnull
    public NamedDomainObjectContainer<RunConfig> runs(Closure closure) {
        return this.runs.configure(closure);
    }

    @Input
    @Nonnull
    public NamedDomainObjectContainer<RunConfig> getRuns() {
        return this.runs;
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name);
        }
        Closure closure = (Closure)value;
        RunConfig runConfig = (RunConfig)this.getRuns().maybeCreate(name);
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)runConfig);
        closure.call();
    }

    private UserdevConfigV2.DataFunction ensureProcessor() {
        if (this.processor == null) {
            this.processor = new UserdevConfigV2.DataFunction();
        }
        return this.processor;
    }

    public void setProcessor(UserdevConfigV2.DataFunction value) {
        this.ensureProcessor();
        this.processor.setVersion(value.getVersion());
        this.processor.setRepo(value.getRepo());
        this.processor.setArgs(value.getArgs());
        this.processor.setJvmArgs(value.getJvmArgs());
    }

    @Input
    @Optional
    public String getProcessorTool() {
        return this.processor == null ? null : this.processor.getVersion();
    }

    public void setProcessorTool(String value) {
        this.ensureProcessor().setVersion(value);
    }

    @Input
    @Optional
    public String getProcessorRepo() {
        return this.processor == null ? null : this.processor.getRepo();
    }

    public void setProcessorRepo(String value) {
        this.ensureProcessor().setRepo(value);
    }

    @Input
    @Optional
    public List<String> getProcessorArgs() {
        return this.processor == null ? null : this.processor.getArgs();
    }

    public void setProcessorTool(String ... values) {
        this.ensureProcessor().setArgs(Arrays.asList(values));
    }

    @InputFiles
    @Optional
    public Collection<File> getProcessorFiles() {
        return this.processorData.values();
    }

    public void addProcessorData(String key, File file) {
        this.processorData.put(key, file);
        this.ensureProcessor().setData(key, "processor/" + file.getName());
    }

    @Input
    @Optional
    public String getPatchesOriginalPrefix() {
        return this.patchesOriginalPrefix;
    }

    public void setPatchesOriginalPrefix(String value) {
        this.patchesOriginalPrefix = value;
    }

    @Input
    @Optional
    public String getPatchesModifiedPrefix() {
        return this.patchesModifiedPrefix;
    }

    public void setPatchesModifiedPrefix(String value) {
        this.patchesModifiedPrefix = value;
    }

    @Input
    public boolean getNotchObf() {
        return this.notchObf;
    }

    public void setNotchObf(boolean value) {
        this.notchObf = value;
    }

    @Input
    @Optional
    public List<String> getUniversalFilters() {
        return this.universalFilters;
    }

    public void universalFilter(String value) {
        this.addUniversalFilter(value);
    }

    public void addUniversalFilter(String value) {
        if (this.universalFilters == null) {
            this.universalFilters = new ArrayList<String>();
        }
        this.universalFilters.add(value);
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

