/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.artifact.ArtifactType;
import com.amadornes.artifactural.api.repository.ArtifactProvider;
import com.amadornes.artifactural.api.repository.Repository;
import com.amadornes.artifactural.base.artifact.StreamableArtifact;
import com.amadornes.artifactural.base.repository.ArtifactProviderBuilder;
import com.amadornes.artifactural.base.repository.SimpleRepository;
import com.amadornes.artifactural.gradle.GradleRepositoryAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.logging.Logger;

public abstract class BaseRepo
implements ArtifactProvider<ArtifactIdentifier> {
    private final File cache;
    protected final Logger log;
    protected final String REPO_NAME = this.getClass().getSimpleName();

    protected BaseRepo(File cache, Logger log) {
        this.cache = cache;
        this.log = log;
    }

    protected File getCacheRoot() {
        return this.cache;
    }

    protected File cache(String ... path) {
        return new File(this.getCacheRoot(), String.join((CharSequence)File.separator, path));
    }

    protected String clean(ArtifactIdentifier art) {
        return art.getGroup() + ":" + art.getName() + ":" + art.getVersion() + ":" + art.getClassifier() + "@" + art.getExtension();
    }

    protected void debug(String message) {
        if (System.getProperty("fg.debugRepo", "false").equals("true")) {
            this.log.lifecycle(message);
        }
    }

    protected void info(String message) {
        this.log.lifecycle(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final com.amadornes.artifactural.api.artifact.Artifact getArtifact(ArtifactIdentifier artifact) {
        try {
            this.debug(this.REPO_NAME + " Request: " + this.clean(artifact));
            String[] pts = artifact.getExtension().split("\\.");
            String desc = (artifact.getGroup() + ":" + artifact.getName() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + "@" + pts[0]).intern();
            File ret = null;
            String string = desc;
            synchronized (string) {
                ret = pts.length == 1 ? this.findFile(artifact) : this.findFile(Artifact.from(artifact.getGroup(), artifact.getName(), artifact.getVersion(), artifact.getClassifier(), pts[0]));
            }
            if (ret != null) {
                File hash;
                ArtifactType type = ArtifactType.OTHER;
                if (artifact.getClassifier() != null && artifact.getClassifier().endsWith("sources")) {
                    type = ArtifactType.SOURCE;
                } else if ("jar".equals(artifact.getExtension())) {
                    type = ArtifactType.BINARY;
                }
                if (pts.length == 1) {
                    return StreamableArtifact.ofFile((ArtifactIdentifier)artifact, (ArtifactType)type, (File)ret);
                }
                if (pts.length == 2 && (hash = new File(ret.getAbsolutePath() + "." + pts[1])).exists()) {
                    return StreamableArtifact.ofFile((ArtifactIdentifier)artifact, (ArtifactType)type, (File)hash);
                }
            }
            return com.amadornes.artifactural.api.artifact.Artifact.none();
        }
        catch (Throwable e) {
            this.log.lifecycle("Error getting artifact: " + this.clean(artifact) + " from  " + this.REPO_NAME, e);
            return com.amadornes.artifactural.api.artifact.Artifact.none();
        }
    }

    protected abstract File findFile(ArtifactIdentifier var1) throws IOException;

    public static class Builder {
        private List<ArtifactProvider<ArtifactIdentifier>> repos = new ArrayList<ArtifactProvider<ArtifactIdentifier>>();

        public Builder add(ArtifactProvider<ArtifactIdentifier> repo) {
            if (repo != null) {
                this.repos.add(repo);
            }
            return this;
        }

        public void attach(Project project) {
            int random = new Random().nextInt();
            File cache = Utils.getCache(project, "bundeled_repo");
            GradleRepositoryAdapter.add((RepositoryHandler)project.getRepositories(), (String)("BUNDELED_" + random), (File)cache, (Repository)SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).provide((ArtifactProvider)new ArtifactProvider<ArtifactIdentifier>(){

                public com.amadornes.artifactural.api.artifact.Artifact getArtifact(ArtifactIdentifier artifact) {
                    return repos.stream().map(repo -> repo.getArtifact((Object)artifact)).filter(com.amadornes.artifactural.api.artifact.Artifact::isPresent).findFirst().orElse(com.amadornes.artifactural.api.artifact.Artifact.none());
                }
            })));
        }
    }
}

