/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;

public class TaskApplyRangeMap
extends JarExec {
    private Set<File> srgs = new HashSet<File>();
    private Set<File> excs = new HashSet<File>();
    private Set<File> sources = new HashSet<File>();
    private File rangeMap;
    public boolean annotate = false;
    public boolean keepImports = true;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.zip"));

    public TaskApplyRangeMap() {
        this.tool = "net.minecraftforge:Srg2Source:5.+:fatjar";
        this.args = new String[]{"--apply", "--input", "{input}", "--range", "{range}", "--srg", "{srg}", "--exc", "{exc}", "--output", "{output}", "--keepImports", "{keepImports}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{range}", this.getRangeMap().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        replace.put("{annotate}", this.getAnnotate() ? "true" : "false");
        replace.put("{keepImports}", this.getKeepImports() ? "true" : "false");
        ArrayList<String> _args = new ArrayList<String>();
        for (String arg : this.getArgs()) {
            if ("{input}".equals(arg)) {
                this.expand(_args, this.getSources());
                continue;
            }
            if ("{srg}".equals(arg)) {
                this.expand(_args, this.getSrgFiles());
                continue;
            }
            if ("{exc}".equals(arg)) {
                this.expand(_args, this.getExcFiles());
                continue;
            }
            _args.add(replace.getOrDefault(arg, arg));
        }
        return _args;
    }

    private void expand(List<String> _args, Collection<File> files) {
        String prefix = _args.get(_args.size() - 1);
        _args.remove(_args.size() - 1);
        files.forEach(f -> {
            _args.add(prefix);
            _args.add(f.getAbsolutePath());
        });
    }

    @InputFiles
    public Set<File> getSrgFiles() {
        return this.srgs;
    }

    public void setSrgFiles(File ... values) {
        for (File value : values) {
            this.srgs.add(value);
        }
    }

    @InputFiles
    public Set<File> getSources() {
        return this.sources;
    }

    public void setSources(Collection<File> values) {
        this.sources.addAll(values);
    }

    public void setSources(File ... values) {
        for (File value : values) {
            this.sources.add(value);
        }
    }

    public void sources(File ... values) {
        this.setSources(values);
    }

    public void sources(Collection<File> values) {
        this.setSources(values);
    }

    @InputFile
    public File getRangeMap() {
        return this.rangeMap;
    }

    public void setRangeMap(File value) {
        this.rangeMap = value;
    }

    @Input
    public boolean getAnnotate() {
        return this.annotate;
    }

    public void setAnnotate(boolean value) {
        this.annotate = value;
    }

    @Input
    public boolean getKeepImports() {
        return this.keepImports;
    }

    public void setKeepImports(boolean value) {
        this.keepImports = value;
    }

    @InputFiles
    public Set<File> getExcFiles() {
        return this.excs;
    }

    public void setExcFiles(File ... values) {
        for (File value : values) {
            this.excs.add(value);
        }
    }

    public void setExcFiles(Collection<File> values) {
        this.excs.addAll(values);
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

