/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.repository.ArtifactProvider;
import com.amadornes.artifactural.api.repository.Repository;
import com.amadornes.artifactural.base.repository.ArtifactProviderBuilder;
import com.amadornes.artifactural.base.repository.SimpleRepository;
import com.cloudbees.diff.PatchException;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.UserdevConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV2;
import net.minecraftforge.gradle.common.diff.ContextualPatch;
import net.minecraftforge.gradle.common.diff.HunkReport;
import net.minecraftforge.gradle.common.diff.PatchFile;
import net.minecraftforge.gradle.common.diff.ZipContext;
import net.minecraftforge.gradle.common.task.ApplyBinPatches;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.DynamicJarExec;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.task.JarExec;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MappingFile;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.MinecraftVersion;
import net.minecraftforge.gradle.common.util.POMBuilder;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.mcp.function.AccessTransformerFunction;
import net.minecraftforge.gradle.mcp.function.SideAnnotationStripperFunction;
import net.minecraftforge.gradle.mcp.task.GenerateSRG;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import net.minecraftforge.gradle.mcp.util.MCPWrapper;
import net.minecraftforge.gradle.userdev.tasks.AccessTransformJar;
import net.minecraftforge.gradle.userdev.tasks.ApplyMCPFunction;
import net.minecraftforge.gradle.userdev.tasks.HackyJavaCompile;
import net.minecraftforge.gradle.userdev.tasks.RenameJar;
import net.minecraftforge.gradle.userdev.tasks.RenameJarInPlace;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginConvention;

public class MinecraftUserRepo
extends BaseRepo {
    public static final boolean CHANGING_USERDEV = false;
    private final Project project;
    private final String GROUP;
    private final String NAME;
    private final String VERSION;
    private final List<File> ATS;
    private final String AT_HASH;
    private final String MAPPING;
    private final boolean isPatcher;
    private final Map<String, McpNames> mapCache = new HashMap<String, McpNames>();
    private boolean loadedParents = false;
    private Patcher parent;
    private MCP mcp;
    private Repository repo;
    private Set<File> extraDataFiles;
    private int compileTaskCount = 1;

    public MinecraftUserRepo(Project project, String group, String name, String version, List<File> ats, String mapping) {
        super(Utils.getCache(project, "minecraft_user_repo"), project.getLogger());
        this.project = project;
        this.GROUP = group;
        this.NAME = name;
        this.VERSION = version;
        this.ATS = ats.stream().filter(File::exists).collect(Collectors.toList());
        try {
            this.AT_HASH = this.ATS.isEmpty() ? null : HashFunction.SHA1.hash(this.ATS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.MAPPING = mapping;
        this.isPatcher = !"net.minecraft".equals(this.GROUP);
        this.repo = SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).filter(ArtifactIdentifier.groupEquals((String)this.GROUP)).filter(ArtifactIdentifier.nameEquals((String)this.NAME)).provide((ArtifactProvider)this));
    }

    @Override
    protected File getCacheRoot() {
        if (this.AT_HASH == null) {
            return super.getCacheRoot();
        }
        return this.project.file((Object)"build/fg_cache/");
    }

    public void validate(Configuration cfg, Map<String, RunConfig> runs, ExtractNatives extractNatives, DownloadAssets downloadAssets, GenerateSRG createSrgToMcp) {
        this.getParents();
        if (this.mcp == null) {
            throw new IllegalStateException("Invalid minecraft dependency: " + this.GROUP + ":" + this.NAME + ":" + this.VERSION);
        }
        ExtraPropertiesExtension ext = this.project.getExtensions().getExtraProperties();
        ext.set("MC_VERSION", (Object)this.mcp.getMCVersion());
        ext.set("MCP_VERSION", (Object)this.mcp.getArtifact().getVersion());
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            patcher.getLibraries().stream().map(Artifact::from).filter(e -> this.GROUP.equals(e.getGroup()) && this.NAME.equals(e.getName())).forEach(e -> {
                String dep = this.getDependencyString();
                if (e.getClassifier() != null) {
                    dep = dep + ":" + e.getClassifier();
                    if (e.getClassifier().indexOf(46) != -1) {
                        throw new IllegalArgumentException("Can not set Minecraft dependency with classifier containing '.'");
                    }
                }
                if (e.getExtension() != null && !"jar".equals(e.getExtension())) {
                    dep = dep + "@" + e.getExtension();
                }
                this.debug("    New Self Dep: " + dep);
                ExternalModuleDependency _dep = (ExternalModuleDependency)this.project.getDependencies().create((Object)dep);
                cfg.getDependencies().add((Object)_dep);
            });
        }
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("assets_root", downloadAssets.getOutput().getAbsolutePath());
        tokens.put("natives", extractNatives.getOutput().getAbsolutePath());
        tokens.put("mc_version", this.mcp.getMCVersion());
        tokens.put("mcp_version", this.mcp.getArtifact().getVersion());
        tokens.put("mcp_mappings", this.MAPPING);
        tokens.put("mcp_to_srg", createSrgToMcp.getOutput().getAbsolutePath());
        if (this.parent != null && this.parent.getConfig().runs != null) {
            this.parent.getConfig().runs.forEach((name, dev) -> {
                RunConfig run = (RunConfig)runs.get(name);
                if (run != null) {
                    run.parent(0, (RunConfig)dev);
                }
            });
        }
        runs.forEach((name, run) -> run.tokens(tokens));
        this.extraDataFiles = this.buildExtraDataFiles();
    }

    private Set<File> buildExtraDataFiles() {
        Configuration cfg = (Configuration)this.project.getConfigurations().create(this.getNextTaskName("compileJava"));
        ArrayList<String> deps = new ArrayList<String>();
        deps.add("net.minecraft:client:" + this.mcp.getMCVersion() + ":extra");
        deps.addAll(this.mcp.getLibraries());
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            deps.addAll(patcher.getLibraries());
        }
        deps.forEach(dep -> cfg.getDependencies().add((Object)this.project.getDependencies().create(dep)));
        Set files = cfg.resolve();
        return files;
    }

    private File cacheRaw(String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.VERSION, this.NAME + '-' + this.VERSION + '.' + ext);
    }

    private File cacheRaw(String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.VERSION, this.NAME + '-' + this.VERSION + '-' + classifier + '.' + ext);
    }

    private File cacheMapped(String mapping, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersion(mapping), this.NAME + '-' + this.getVersion(mapping) + '.' + ext);
    }

    private File cacheMapped(String mapping, String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersion(mapping), this.NAME + '-' + this.getVersion(mapping) + '-' + classifier + '.' + ext);
    }

    private File cacheAT(String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersionAT(), this.NAME + '-' + this.getVersionAT() + '-' + classifier + '.' + ext);
    }

    public String getDependencyString() {
        String ret = this.GROUP + ':' + this.NAME + ':' + this.VERSION;
        if (this.MAPPING != null) {
            ret = ret + "_mapped_" + this.MAPPING;
        }
        if (this.AT_HASH != null) {
            ret = ret + "_at_" + this.AT_HASH;
        }
        return ret;
    }

    private String getATHash(String version) {
        if (!version.contains("_at_")) {
            return null;
        }
        return version.split("_at_")[1];
    }

    private String getMappings(String version) {
        if (!version.contains("_mapped_")) {
            return null;
        }
        return version.split("_mapped_")[1];
    }

    private String getVersion(String mappings) {
        return mappings == null ? this.VERSION : this.VERSION + "_mapped_" + mappings;
    }

    private String getVersionWithAT(String mappings) {
        if (this.AT_HASH == null) {
            return this.getVersion(mappings);
        }
        return this.getVersion(mappings) + "_at_" + this.AT_HASH;
    }

    private String getVersionAT() {
        if (this.AT_HASH == null) {
            return this.VERSION;
        }
        return this.VERSION + "_at_" + this.AT_HASH;
    }

    private Patcher getParents() {
        if (!this.loadedParents) {
            MinecraftVersion mcver;
            String classifier = "userdev";
            if ("net.minecraftforge".equals(this.GROUP) && "forge".equals(this.NAME) && (mcver = MinecraftVersion.from(this.VERSION.split("-")[0])).compareTo(MinecraftVersion.v1_13) < 0) {
                classifier = "userdev3";
            }
            String artifact = this.isPatcher ? this.GROUP + ":" + this.NAME + ":" + this.VERSION + ':' + classifier : "de.oceanlabs.mcp:mcp_config:" + this.VERSION + "@zip";
            boolean patcher = this.isPatcher;
            Patcher last = null;
            while (artifact != null) {
                this.debug("    Parent: " + artifact);
                File dep = MavenArtifactDownloader.manual(this.project, artifact, false);
                if (dep == null) {
                    throw new IllegalStateException("Could not resolve dependency: " + artifact);
                }
                if (patcher) {
                    Patcher _new = new Patcher(this.project, dep, artifact);
                    if (this.parent == null) {
                        this.parent = _new;
                    }
                    if (last != null) {
                        last.setParent(_new);
                    }
                    last = _new;
                    patcher = !_new.parentIsMcp();
                    artifact = _new.getParentDesc();
                    continue;
                }
                this.mcp = new MCP(dep, artifact);
                break;
            }
            this.loadedParents = this.mcp != null;
        }
        return this.parent;
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String mappings;
        String version;
        String athash;
        String group = artifact.getGroup();
        String rand = "";
        if (group.startsWith("rnd.")) {
            rand = group.substring(0, group.indexOf(46, 4));
            group = group.substring(group.indexOf(46, 4) + 1);
        }
        if ((athash = this.getATHash(version = artifact.getVersion())) != null) {
            version = version.substring(0, version.length() - (athash.length() + "_at_".length()));
        }
        if ((mappings = this.getMappings(version)) != null) {
            version = version.substring(0, version.length() - (mappings.length() + "_mapped_".length()));
        }
        if (!(group.equals(this.GROUP) && artifact.getName().equals(this.NAME) && version.equals(this.VERSION))) {
            return null;
        }
        if (this.AT_HASH == null && athash != null || this.AT_HASH != null && !this.AT_HASH.equals(athash)) {
            return null;
        }
        if (!this.isPatcher && mappings == null) {
            return null;
        }
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        String ext = artifact.getExtension();
        this.debug("  " + this.REPO_NAME + " Request: " + artifact.getGroup() + ":" + artifact.getName() + ":" + version + ":" + classifier + "@" + ext + " Mapping: " + mappings);
        if ("pom".equals(ext)) {
            return this.findPom(mappings, rand);
        }
        switch (classifier) {
            case "": {
                return this.findRaw(mappings);
            }
            case "sources": {
                return this.findSource(mappings, true);
            }
        }
        return this.findExtraClassifier(mappings, classifier, ext);
    }

    private HashStore commonHash(File mapping) {
        this.getParents();
        HashStore ret = new HashStore(this.getCacheRoot());
        ret.add(this.mcp.artifact.getDescriptor(), this.mcp.getZip());
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            ret.add(this.parent.artifact.getDescriptor(), this.parent.data);
        }
        if (mapping != null) {
            ret.add("mapping", mapping);
        }
        if (this.AT_HASH != null) {
            ret.add("ats", this.AT_HASH);
        }
        return ret;
    }

    private File findMapping(String mapping) {
        if (mapping == null) {
            this.debug("  FindMappings: Null mappings");
            return null;
        }
        int idx = mapping.lastIndexOf(95);
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = MCPRepo.getMappingDep(channel, version);
        this.debug("    Mapping: " + desc);
        File ret = MavenArtifactDownloader.generate(this.project, desc, false);
        if (ret == null) {
            String message = "Could not download MCP Mappings: " + desc;
            this.debug("    " + message);
            this.project.getLogger().error(message);
            throw new IllegalStateException(message);
        }
        return ret;
    }

    private File findPom(String mapping, String rand) throws IOException {
        HashStore cache;
        this.getParents();
        if (this.mcp == null || mapping == null) {
            this.debug("  Finding Pom: MCP or Mappings were null");
            return null;
        }
        File pom = this.cacheMapped(mapping, "pom");
        if (!rand.isEmpty()) {
            rand = rand + '.';
            pom = this.cacheMapped(mapping, rand + "pom");
        }
        if ((cache = this.commonHash(null).load(new File(pom.getAbsolutePath() + ".input"))).isSame() && pom.exists()) {
            this.debug("  Finding Pom: Cache Hit");
        } else {
            this.debug("  Finding Pom: " + pom);
            POMBuilder builder = new POMBuilder(rand + this.GROUP, this.NAME, this.getVersionWithAT(mapping));
            builder.dependencies().add("net.minecraft:client:" + this.mcp.getMCVersion() + ":extra", "compile");
            this.mcp.getLibraries().forEach(e -> builder.dependencies().add((String)e, "compile"));
            if (mapping != null) {
                int idx = mapping.lastIndexOf(95);
                String channel = mapping.substring(0, idx);
                String version = mapping.substring(idx + 1);
                builder.dependencies().add(MCPRepo.getMappingDep(channel, version), "compile");
            }
            for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                for (String lib : patcher.getLibraries()) {
                    Artifact af = Artifact.from(lib);
                    if (this.GROUP.equals(af.getGroup()) && this.NAME.equals(af.getName()) && this.VERSION.equals(af.getVersion())) {
                        builder.dependencies().add(rand + this.GROUP, this.NAME, this.getVersionWithAT(mapping), af.getClassifier(), af.getExtension(), "compile");
                        continue;
                    }
                    builder.dependencies().add(lib, "compile");
                }
            }
            String ret = builder.tryBuild();
            if (ret == null) {
                return null;
            }
            FileUtils.writeByteArrayToFile((File)pom, (byte[])ret.getBytes());
            cache.save();
            Utils.updateHash(pom, HashFunction.SHA1);
        }
        return pom;
    }

    private File findBinPatches() throws IOException {
        File ret = this.cacheRaw("binpatches", "lzma");
        HashStore cache = new HashStore().load(this.cacheRaw("binpatches", "lzma.input")).add("parent", this.parent.getZip());
        if (cache.isSame() && ret.exists()) {
            this.debug("  FindBinPatches: Cache Hit");
        } else {
            this.debug("  FindBinPatches: Extracting to " + ret);
            try (ZipFile zip = new ZipFile(this.parent.getZip());){
                Utils.extractFile(zip, this.parent.getConfig().binpatches, ret);
                cache.save();
            }
        }
        return ret;
    }

    private File findRaw(String mapping) throws IOException {
        File names = this.findMapping(mapping);
        HashStore cache = this.commonHash(names).add("codever", "2");
        if (mapping != null && names == null) {
            this.debug("  Finding Raw: Could not find names, exiting");
            return null;
        }
        File recomp = this.findRecomp(mapping, false);
        if (recomp != null) {
            this.debug("  Finding Raw: Returning Recomp: " + recomp);
            return recomp;
        }
        if (mapping == null && this.parent == null) {
            this.debug("  Finding Raw: Userdev does not provide SRG Minecraft");
            return null;
        }
        File bin = this.cacheMapped(mapping, "jar");
        cache.load(this.cacheMapped(mapping, "jar.input"));
        if (cache.isSame() && bin.exists()) {
            this.debug("  Finding Raw: Cache Hit: " + bin);
        } else {
            JarExec rename;
            ZipEntry entry;
            Throwable throwable;
            this.debug("  Finding Raw: Cache Miss");
            StringBuilder baseAT = new StringBuilder();
            Patcher patcher = this.parent;
            while (patcher != null) {
                if (patcher.getATData() != null && !patcher.getATData().isEmpty()) {
                    if (baseAT.length() != 0) {
                        baseAT.append("\n===========================================================\n");
                    }
                    baseAT.append(patcher.getATData());
                }
                patcher = patcher.parent;
            }
            boolean hasAts = baseAT.length() != 0 || !this.ATS.isEmpty();
            this.debug("    HasAts: " + hasAts);
            HashSet<String> packages = new HashSet<String>();
            File srged = this.findBinpatched(packages);
            File mcinject = this.cacheRaw("mci", "jar");
            this.debug("    Applying MCInjector");
            ApplyMCPFunction mci = this.createTask("mciJar", ApplyMCPFunction.class);
            mci.setFunctionName("mcinject");
            mci.setHasLog(false);
            mci.setInput(srged);
            mci.setMCP(this.mcp.getZip());
            mci.setOutput(mcinject);
            mci.apply();
            this.debug("    Creating MCP Inject Sources");
            File inject_src = this.cacheRaw("inject_src", "jar");
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(this.mcp.getZip()));){
                throwable = null;
                try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(inject_src));){
                    String prefix = this.mcp.wrapper.getConfig().getData("inject");
                    String template = null;
                    entry = null;
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().startsWith(prefix) || entry.isDirectory() || "server".equals(this.NAME) && entry.getName().contains("/client/") || "client".equals(this.NAME) && entry.getName().contains("/server/")) continue;
                        String name = entry.getName().substring(prefix.length());
                        if ("package-info-template.java".equals(name)) {
                            template = new String(IOUtils.toByteArray((InputStream)zin), StandardCharsets.UTF_8);
                            continue;
                        }
                        zos.putNextEntry(Utils.getStableEntry(name));
                        IOUtils.copy((InputStream)zin, (OutputStream)zos);
                        zos.closeEntry();
                    }
                    if (template != null) {
                        for (String pkg : packages) {
                            zos.putNextEntry(Utils.getStableEntry(pkg + "/package-info.java"));
                            zos.write(template.replace("{PACKAGE}", pkg.replace("/", ".")).getBytes(StandardCharsets.UTF_8));
                            zos.closeEntry();
                        }
                    }
                }
                catch (Throwable prefix) {
                    throwable = prefix;
                    throw prefix;
                }
            }
            this.debug("    Compiling MCP Inject sources");
            final File compiled = this.compileJava(inject_src, mcinject);
            if (compiled == null) {
                return null;
            }
            this.debug("    Injecting MCP Inject binairies");
            File injected = this.cacheRaw("injected", "jar");
            throwable = null;
            try (ZipInputStream zmci = new ZipInputStream(new FileInputStream(mcinject));
                 final ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(injected));){
                entry = null;
                while ((entry = zmci.getNextEntry()) != null) {
                    zout.putNextEntry(Utils.getStableEntry(entry.getName()));
                    IOUtils.copy((InputStream)zmci, (OutputStream)zout);
                    zout.closeEntry();
                }
                Files.walkFileTree(compiled.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try (InputStream fin = Files.newInputStream(file, new OpenOption[0]);){
                            zout.putNextEntry(Utils.getStableEntry(compiled.toPath().relativize(file).toString().replace('\\', '/')));
                            IOUtils.copy((InputStream)fin, (OutputStream)zout);
                            zout.closeEntry();
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            if (hasAts) {
                if (bin.exists()) {
                    bin.delete();
                }
                this.debug("    Applying Access Transformer");
                AccessTransformJar at = this.createTask("atJar", AccessTransformJar.class);
                at.setInput(injected);
                at.setOutput(bin);
                at.setAts(this.ATS);
                if (baseAT.length() != 0) {
                    File parentAT = this.project.file((Object)("build/" + at.getName() + "/parent_at.cfg"));
                    if (!parentAT.getParentFile().exists()) {
                        parentAT.getParentFile().mkdirs();
                    }
                    Files.write(parentAT.toPath(), baseAT.toString().getBytes(), new OpenOption[0]);
                    at.setAts(parentAT);
                }
                at.apply();
            }
            if (mapping == null) {
                FileUtils.copyFile((File)injected, (File)bin);
            } else if (hasAts) {
                this.debug("    Renaming ATed Jar in place");
                rename = this.createTask("renameJarInPlace", RenameJarInPlace.class);
                rename.setHasLog(false);
                ((RenameJarInPlace)rename).setInput(bin);
                ((RenameJarInPlace)rename).setMappings(this.findSrgToMcp(mapping, names));
                ((RenameJarInPlace)rename).apply();
            } else {
                this.debug("    Renaming injected jar");
                rename = this.createTask("renameJar", RenameJar.class);
                rename.setHasLog(false);
                ((RenameJar)rename).setInput(injected);
                ((RenameJar)rename).setOutput(bin);
                ((RenameJar)rename).setMappings(this.findSrgToMcp(mapping, names));
                rename.apply();
            }
            this.debug("    Finished: " + bin);
            Utils.updateHash(bin, HashFunction.SHA1);
            cache.save();
        }
        return bin;
    }

    private File findBinpatched(Set<String> packages) throws IOException {
        boolean notch = this.parent != null && this.parent.getConfigV2() != null && this.parent.getConfigV2().getNotchObf();
        String desc = "net.minecraft:" + (this.isPatcher ? "joined" : this.NAME) + ":" + (notch ? this.mcp.getMCVersion() : this.mcp.getVersion() + ":srg");
        File clean = MavenArtifactDownloader.generate(this.project, desc, true);
        if (clean == null || !clean.exists()) {
            this.debug("  Failed to find MC Vanilla Base: " + desc);
            this.project.getLogger().error("MinecraftUserRepo: Failed to get Minecraft Vanilla Base. Should not be possible. " + desc);
            return null;
        }
        this.debug("    Vanilla Base: " + clean);
        File obf2Srg = null;
        try (ZipFile tmp = new ZipFile(clean);){
            if (notch) {
                obf2Srg = this.findObfToSrg(MappingFile.Format.TSRG);
                if (obf2Srg == null) {
                    this.debug("  Failed to find obf to mcp mapping file. " + this.mcp.getVersion());
                    this.project.getLogger().error("MinecraftUserRepo: Failed to find obf to mcp mapping file. Should not be possible. " + this.mcp.getVersion());
                    File file = null;
                    return file;
                }
                Set vanillaClasses = tmp.stream().map(ZipEntry::getName).filter(e -> e.endsWith(".class")).map(e -> e.substring(0, e.length() - 6)).collect(Collectors.toSet());
                MappingFile o2s = MappingFile.load(obf2Srg);
                o2s.getClasses().stream().filter(e -> vanillaClasses.contains(e.getOriginal())).map(MappingFile.Node::getMapped).map(e -> e.indexOf(47) == -1 ? "" : e.substring(0, e.lastIndexOf(47))).forEach(packages::add);
            } else {
                tmp.stream().map(ZipEntry::getName).filter(e -> e.endsWith(".class")).map(e -> e.indexOf(47) == -1 ? "" : e.substring(0, e.lastIndexOf(47))).forEach(packages::add);
            }
        }
        if (this.parent == null) {
            return clean;
        }
        File binpatched = this.cacheRaw("binpatched", "jar");
        this.debug("    Creating Binpatches");
        ApplyBinPatches apply = this.createTask("applyBinpatches", ApplyBinPatches.class);
        apply.setHasLog(true);
        apply.setTool(this.parent.getConfig().binpatcher.getVersion());
        apply.setArgs(this.parent.getConfig().binpatcher.getArgs());
        apply.setClean(clean);
        apply.setPatch(this.findBinPatches());
        apply.setOutput(binpatched);
        apply.apply();
        this.debug("    Injecting binpatch extras");
        File merged = this.cacheRaw(notch ? "obf" : "srg", "jar");
        HashSet<String> added = new HashSet<String>();
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(merged));){
            for (File file : new File[]{binpatched, clean}) {
                try (ZipInputStream zin = new ZipInputStream(new FileInputStream(file));){
                    ZipEntry entry;
                    while ((entry = zin.getNextEntry()) != null) {
                        String name = entry.getName();
                        if (added.contains(name)) continue;
                        ZipEntry _new = new ZipEntry(name);
                        _new.setTime(entry.getTime());
                        zip.putNextEntry(_new);
                        IOUtils.copy((InputStream)zin, (OutputStream)zip);
                        added.add(name);
                    }
                }
            }
            this.copyResources(zip, added, true);
        }
        if (notch) {
            File srged = this.cacheRaw("srg", "jar");
            this.debug("    Renaming injected jar");
            RenameJar rename = this.createTask("renameJar", RenameJar.class);
            rename.setHasLog(false);
            rename.setInput(merged);
            rename.setOutput(srged);
            rename.setMappings(obf2Srg);
            rename.apply();
            return srged;
        }
        return merged;
    }

    private void copyResources(ZipOutputStream zip, Set<String> added, boolean includeClasses) throws IOException {
        HashMap<String, List> servicesLists = new HashMap<String, List>();
        Predicate<String> filter = name -> added.contains(name) || !includeClasses && name.endsWith(".class") || name.startsWith("META-INF") && (name.endsWith(".DSA") || name.endsWith(".SF"));
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            ZipEntry _new;
            List existing;
            String name2;
            ZipEntry entry2;
            Throwable throwable;
            ZipInputStream zin;
            if (patcher.getUniversal() != null) {
                zin = new ZipInputStream(new FileInputStream(patcher.getUniversal()));
                throwable = null;
                try {
                    while ((entry2 = zin.getNextEntry()) != null) {
                        name2 = entry2.getName();
                        if (filter.test(name2) || this.parent.getUniversalFilters().stream().anyMatch(f -> !f.matcher(name2).matches())) continue;
                        if (name2.startsWith("META-INF/services/") && !entry2.isDirectory()) {
                            existing = servicesLists.computeIfAbsent(name2, k -> new ArrayList());
                            if (existing.size() > 0) {
                                existing.add("");
                            }
                            existing.add(String.format("# %s - %s", patcher.artifact, patcher.getUniversal().getCanonicalFile().getName()));
                            existing.addAll(IOUtils.readLines((InputStream)zin));
                            continue;
                        }
                        _new = new ZipEntry(name2);
                        _new.setTime(0L);
                        zip.putNextEntry(_new);
                        IOUtils.copy((InputStream)zin, (OutputStream)zip);
                        added.add(name2);
                    }
                }
                catch (Throwable entry2) {
                    throwable = entry2;
                    throw entry2;
                }
                finally {
                    if (zin != null) {
                        if (throwable != null) {
                            try {
                                zin.close();
                            }
                            catch (Throwable entry2) {
                                throwable.addSuppressed(entry2);
                            }
                        } else {
                            zin.close();
                        }
                    }
                }
            }
            if (patcher.getInject() == null) continue;
            zin = new ZipInputStream(new FileInputStream(patcher.getZip()));
            throwable = null;
            try {
                while ((entry2 = zin.getNextEntry()) != null) {
                    if (!entry2.getName().startsWith(patcher.getInject()) || entry2.getName().length() <= patcher.getInject().length() || filter.test(name2 = entry2.getName().substring(patcher.getInject().length()))) continue;
                    if (name2.startsWith("META-INF/services/") && !entry2.isDirectory()) {
                        existing = servicesLists.computeIfAbsent(name2, k -> new ArrayList());
                        if (existing.size() > 0) {
                            existing.add("");
                        }
                        existing.add(String.format("# %s - %s", patcher.artifact, patcher.getZip().getCanonicalFile().getName()));
                        existing.addAll(IOUtils.readLines((InputStream)zin));
                        continue;
                    }
                    _new = new ZipEntry(name2);
                    _new.setTime(0L);
                    zip.putNextEntry(_new);
                    IOUtils.copy((InputStream)zin, (OutputStream)zip);
                    added.add(name2);
                }
                continue;
            }
            catch (Throwable entry3) {
                throwable = entry3;
                throw entry3;
            }
            finally {
                if (zin != null) {
                    if (throwable != null) {
                        try {
                            zin.close();
                        }
                        catch (Throwable entry3) {
                            throwable.addSuppressed(entry3);
                        }
                    } else {
                        zin.close();
                    }
                }
            }
        }
        for (Map.Entry kv : servicesLists.entrySet()) {
            String name3 = (String)kv.getKey();
            ZipEntry _new = new ZipEntry(name3);
            _new.setTime(0L);
            zip.putNextEntry(_new);
            IOUtils.writeLines((Collection)((Collection)kv.getValue()), (String)"\n", (OutputStream)zip);
            added.add(name3);
        }
    }

    private McpNames loadMCPNames(String name, File data) throws IOException {
        McpNames map = this.mapCache.get(name);
        String hash = HashFunction.SHA1.hash(data);
        if (map == null || !hash.equals(map.hash)) {
            map = McpNames.load(data);
            this.mapCache.put(name, map);
        }
        return map;
    }

    private File findObfToSrg(MappingFile.Format format) throws IOException {
        String ext = format.name().toLowerCase();
        File root = this.cache(this.mcp.getArtifact().getGroup().replace('.', '/'), this.mcp.getArtifact().getName(), this.mcp.getArtifact().getVersion());
        File file = new File(root, "obf_to_srg." + ext);
        HashStore cache = new HashStore().add("mcp", this.mcp.getZip()).load(new File(root, "obf_to_srg." + ext + ".input"));
        if (!cache.isSame() || !file.exists()) {
            byte[] data = this.mcp.getData("mappings");
            MappingFile obf_to_srg = MappingFile.load(new ByteArrayInputStream(data));
            obf_to_srg.write(format, file, false);
            cache.save();
        }
        return file;
    }

    private File findSrgToMcp(String mapping, File names) throws IOException {
        if (names == null) {
            this.debug("Attempted to create SRG to MCP with null MCP mappings: " + mapping);
            throw new IllegalArgumentException("Attempted to create SRG to MCP with null MCP mappings: " + mapping);
        }
        File root = this.cache(this.mcp.getArtifact().getGroup().replace('.', '/'), this.mcp.getArtifact().getName(), this.mcp.getArtifact().getVersion());
        String srg_name = "srg_to_" + mapping + ".tsrg";
        File srg = new File(root, srg_name);
        HashStore cache = new HashStore().add("mcp", this.mcp.getZip()).add("mapping", names).load(new File(root, srg_name + ".input"));
        if (!cache.isSame() || !srg.exists()) {
            this.info("Creating SRG -> MCP TSRG");
            byte[] data = this.mcp.getData("mappings");
            McpNames mcp_names = this.loadMCPNames(mapping, names);
            MappingFile obf_to_srg = MappingFile.load(new ByteArrayInputStream(data));
            MappingFile srg_to_named = new MappingFile();
            obf_to_srg.getPackages().forEach(e -> srg_to_named.addPackage(e.getMapped(), e.getMapped()));
            obf_to_srg.getClasses().forEach(cls -> {
                srg_to_named.addClass(cls.getMapped(), cls.getMapped());
                MappingFile.Cls _cls = srg_to_named.getClass(cls.getMapped());
                cls.getFields().forEach(fld -> _cls.addField(fld.getMapped(), mcp_names.rename(fld.getMapped())));
                cls.getMethods().forEach(mtd -> _cls.addMethod(mtd.getMapped(), mtd.getMappedDescriptor(), mcp_names.rename(mtd.getMapped())));
            });
            srg_to_named.write(MappingFile.Format.TSRG, srg, false);
            cache.save();
        }
        return srg;
    }

    private File findDecomp(boolean generate) throws IOException {
        HashStore cache = this.commonHash(null);
        File decomp = this.cacheAT("decomp", "jar");
        this.debug("  Finding Decomp: " + decomp);
        cache.load(this.cacheAT("decomp", "jar.input"));
        if (cache.isSame() && decomp.exists()) {
            this.debug("  Cache Hit");
        } else if (decomp.exists() || generate) {
            this.debug("  Decompiling");
            File output = this.mcp.getStepOutput(this.isPatcher ? "joined" : this.NAME, null);
            if (this.parent != null && this.parent.getConfigV2() != null && this.parent.getConfigV2().processor != null) {
                UserdevConfigV2.DataFunction data = this.parent.getConfigV2().processor;
                DynamicJarExec proc = this.createTask("postProcess", DynamicJarExec.class);
                proc.setInput(output);
                proc.setOutput(decomp);
                proc.setTool(data.getVersion());
                proc.setArgs(data.getArgs());
                if (data.getData() != null) {
                    File root = this.project.file((Object)("build/" + proc.getName()));
                    if (!root.exists()) {
                        root.mkdirs();
                    }
                    try (ZipFile zip = new ZipFile(this.parent.getZip());){
                        for (Map.Entry<String, String> ent : data.getData().entrySet()) {
                            File target = new File(root, ent.getValue());
                            Utils.extractFile(zip, ent.getValue(), target);
                            proc.setData(ent.getKey(), target);
                        }
                    }
                }
                proc.apply();
            } else {
                FileUtils.copyFile((File)output, (File)decomp);
            }
            cache.save();
            Utils.updateHash(decomp, HashFunction.SHA1);
        }
        return decomp.exists() ? decomp : null;
    }

    private File findPatched(boolean generate) throws IOException {
        File decomp = this.findDecomp(generate);
        if (decomp == null || !decomp.exists()) {
            this.debug("  Finding Patched: Decomp not found");
            return null;
        }
        if (this.parent == null) {
            this.debug("  Finding Patched: No parent");
            return decomp;
        }
        HashStore cache = this.commonHash(null).add("decomp", decomp);
        File patched = this.cacheAT("patched", "jar");
        this.debug("  Finding patched: " + decomp);
        cache.load(this.cacheAT("patched", "jar.input"));
        if (cache.isSame() && patched.exists()) {
            this.debug("    Cache Hit");
        } else if (patched.exists() || generate) {
            Patcher patcher;
            this.debug("    Generating");
            LinkedList<Patcher> parents = new LinkedList<Patcher>();
            for (patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                parents.addFirst(patcher);
            }
            try (ZipFile zip = new ZipFile(decomp);){
                ZipContext context = new ZipContext(zip);
                boolean failed = false;
                for (Patcher p : parents) {
                    Map<String, PatchFile> patches = p.getPatches();
                    if (patches.isEmpty()) continue;
                    String prefixO = this.parent.getConfigV2() == null ? null : this.parent.getConfigV2().patchesOriginalPrefix;
                    String prefixM = this.parent.getConfigV2() == null ? null : this.parent.getConfigV2().patchesModifiedPrefix;
                    this.debug("      Apply Patches:   " + p.artifact);
                    this.debug("      Original Prefix: " + prefixO);
                    this.debug("      Modified Prefix: " + prefixM);
                    ArrayList<String> keys = new ArrayList<String>(patches.keySet());
                    Collections.sort(keys);
                    for (String key : keys) {
                        ContextualPatch patch = ContextualPatch.create(patches.get(key), context, prefixO, prefixM);
                        patch.setCanonialization(true, false);
                        patch.setMaxFuzz(0);
                        try {
                            this.debug("        Apply Patch: " + key);
                            List<ContextualPatch.PatchReport> result = patch.patch(false);
                            for (int x = 0; x < result.size(); ++x) {
                                ContextualPatch.PatchReport report = result.get(x);
                                if (report.getStatus().isSuccess()) continue;
                                this.log.error("  Failed to apply patch: " + p.artifact + ": " + key);
                                failed = true;
                                for (int y = 0; y < report.hunkReports().size(); ++y) {
                                    HunkReport hunk = report.hunkReports().get(y);
                                    if (!hunk.hasFailed()) continue;
                                    if (hunk.failure == null) {
                                        this.log.error("    Hunk #" + hunk.hunkID + " Failed @" + hunk.index + " Fuzz: " + hunk.fuzz);
                                        continue;
                                    }
                                    this.log.error("    Hunk #" + hunk.hunkID + " Failed: " + hunk.failure.getMessage());
                                }
                            }
                        }
                        catch (PatchException e) {
                            this.log.error("  Apply Patch: " + p.artifact + ": " + key);
                            this.log.error("    " + e.getMessage());
                        }
                    }
                }
                if (failed) {
                    throw new RuntimeException("Failed to apply patches to source file, see log for details: " + decomp);
                }
                this.debug("    Injecting patcher extras");
                HashSet<String> added = new HashSet<String>();
                try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(patched));){
                    added.addAll(context.save(zout));
                    for (patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                        if (patcher.getSources() == null) continue;
                        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(patcher.getSources()));){
                            ZipEntry entry;
                            while ((entry = zin.getNextEntry()) != null) {
                                if (added.contains(entry.getName()) || entry.getName().startsWith("patches/")) continue;
                                ZipEntry _new = new ZipEntry(entry.getName());
                                _new.setTime(0L);
                                zout.putNextEntry(_new);
                                IOUtils.copy((InputStream)zin, (OutputStream)zout);
                                added.add(entry.getName());
                            }
                            continue;
                        }
                    }
                }
                cache.save();
                Utils.updateHash(patched, HashFunction.SHA1);
            }
        }
        return patched.exists() ? patched : null;
    }

    private File findSource(String mapping, boolean generate) throws IOException {
        File patched = this.findPatched(generate);
        if (patched == null || !patched.exists()) {
            this.debug("  Finding Source: Patched not found");
            return null;
        }
        if (mapping == null) {
            this.debug("  Finding Source: No Renames");
            return patched;
        }
        File names = this.findMapping(mapping);
        if (mapping != null && names == null) {
            this.debug("  Finding Sources: Mapping not found");
            return null;
        }
        HashStore cache = this.commonHash(names);
        File sources = this.cacheMapped(mapping, "sources", "jar");
        this.debug("  Finding Source: " + sources);
        cache.load(this.cacheMapped(mapping, "sources", "jar.input"));
        if (cache.isSame() && sources.exists()) {
            this.debug("    Cache hit");
        } else if (sources.exists() || generate) {
            McpNames map = McpNames.load(names);
            if (!sources.getParentFile().exists()) {
                sources.getParentFile().mkdirs();
            }
            boolean addJavadocs = this.parent == null || this.parent.getConfigV2() == null || this.parent.getConfigV2().processor == null;
            this.debug("    Renaming Sources, Javadocs: " + addJavadocs);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(patched));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(sources));){
                ZipEntry _old;
                while ((_old = zin.getNextEntry()) != null) {
                    zout.putNextEntry(Utils.getStableEntry(_old.getName()));
                    if (_old.getName().endsWith(".java")) {
                        String mapped = map.rename(zin, addJavadocs);
                        IOUtils.write((String)mapped, (OutputStream)zout);
                        continue;
                    }
                    IOUtils.copy((InputStream)zin, (OutputStream)zout);
                }
            }
            Utils.updateHash(sources, HashFunction.SHA1);
            cache.save();
        }
        return sources.exists() ? sources : null;
    }

    private File findRecomp(String mapping, boolean generate) throws IOException {
        File source = this.findSource(mapping, generate);
        if (source == null || !source.exists()) {
            this.debug("  Finding Recomp: Sources not found");
            return null;
        }
        File names = this.findMapping(mapping);
        if (names == null && mapping != null) {
            this.debug("  Finding Recomp: Could not find names");
            return null;
        }
        HashStore cache = this.commonHash(names);
        cache.add("source", source);
        cache.load(this.cacheMapped(mapping, "recomp", "jar.input"));
        File recomp = this.cacheMapped(mapping, "recomp", "jar");
        if (cache.isSame() && recomp.exists()) {
            this.debug("  Finding Recomp: Cache Hit");
        } else {
            this.debug("  Finding recomp: " + cache.isSame() + " " + recomp);
            this.debug("    Compiling");
            final File compiled = this.compileJava(source, new File[0]);
            if (compiled == null) {
                this.debug("    Compiling failed");
                throw new IllegalStateException("Compile failed in findRecomp. See log for more details");
            }
            this.debug("    Injecting resources");
            final HashSet<String> added = new HashSet<String>();
            try (final ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(recomp));){
                Files.walkFileTree(compiled.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try (InputStream fin = Files.newInputStream(file, new OpenOption[0]);){
                            String name = compiled.toPath().relativize(file).toString().replace('\\', '/');
                            zout.putNextEntry(Utils.getStableEntry(name));
                            IOUtils.copy((InputStream)fin, (OutputStream)zout);
                            zout.closeEntry();
                            added.add(name);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                this.copyResources(zout, added, false);
            }
            Utils.updateHash(recomp, HashFunction.SHA1);
            cache.save();
        }
        return recomp;
    }

    private File findExtraClassifier(String mapping, String classifier, String extension) throws IOException {
        File target = this.cacheMapped(mapping, classifier, extension);
        this.debug("  Finding Classified: " + target);
        File original = MavenArtifactDownloader.manual(this.project, Artifact.from(this.GROUP, this.NAME, this.VERSION, classifier, extension).getDescriptor(), false);
        HashStore cache = this.commonHash(null);
        if (original != null) {
            cache.add("original", original);
        }
        cache.load(this.cacheMapped(mapping, classifier, extension + ".input"));
        if (cache.isSame() && target.exists()) {
            this.debug("    Cache hit");
        } else {
            block6: {
                if (original == null) {
                    this.debug("    Failed to download original artifact.");
                    return null;
                }
                this.debug("    Copying file");
                try {
                    FileUtils.copyFile((File)original, (File)target);
                }
                catch (IOException e) {
                    if (!target.exists()) break block6;
                    target.delete();
                }
            }
            cache.save();
            Utils.updateHash(target, HashFunction.SHA1);
        }
        return target;
    }

    private String getNextTaskName(String prefix) {
        return '_' + prefix + "_" + this.compileTaskCount++;
    }

    private <T extends Task> T createTask(String prefix, Class<T> cls) {
        return (T)this.project.getTasks().create(this.getNextTaskName(prefix), cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File compileJava(File source, File ... extraDeps) {
        HackyJavaCompile compile = this.createTask("compileJava", HackyJavaCompile.class);
        try {
            File output = this.project.file((Object)("build/" + compile.getName() + "/"));
            if (output.exists()) {
                FileUtils.cleanDirectory((File)output);
            } else {
                output.mkdirs();
            }
            HashSet files = Sets.newHashSet(this.extraDataFiles);
            for (File ext : extraDeps) {
                files.add(ext);
            }
            compile.setClasspath((FileCollection)this.project.files(new Object[]{files}));
            if (this.parent != null) {
                compile.setSourceCompatibility(this.parent.getConfig().getSourceCompatibility());
                compile.setTargetCompatibility(this.parent.getConfig().getTargetCompatibility());
            } else {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().findPlugin(JavaPluginConvention.class);
                if (javaPluginConvention != null) {
                    compile.setSourceCompatibility(javaPluginConvention.getSourceCompatibility().toString());
                    compile.setTargetCompatibility(javaPluginConvention.getTargetCompatibility().toString());
                }
            }
            compile.setDestinationDir(output);
            compile.setSource((FileTree)(source.isDirectory() ? this.project.fileTree((Object)source) : this.project.zipTree((Object)source)));
            compile.doHackyCompile();
            File file = output;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            this.project.getTasks().remove((Object)compile);
        }
    }

    private class MCP {
        private final MCPWrapper wrapper;
        private final Artifact artifact;

        private MCP(final File data, String artifact) {
            this.artifact = Artifact.from(artifact);
            try {
                File mcp_dir = MinecraftUserRepo.this.cache(new String[]{"mcp", this.artifact.getVersion()});
                this.wrapper = new MCPWrapper(data, mcp_dir){

                    @Override
                    public MCPRuntime getRuntime(Project project, String side) {
                        MCPRuntime ret = (MCPRuntime)this.runtimes.get(side);
                        if (ret == null) {
                            File dir = new File(MCP.this.wrapper.getRoot(), side);
                            String AT_HASH = MinecraftUserRepo.this.AT_HASH;
                            List ATS = MinecraftUserRepo.this.ATS;
                            AccessTransformerFunction function = new AccessTransformerFunction(project, ATS);
                            boolean emptyAT = true;
                            if (AT_HASH != null) {
                                dir = new File(dir, AT_HASH);
                                emptyAT = false;
                            }
                            SideAnnotationStripperFunction stripper = new SideAnnotationStripperFunction(project, Collections.emptyList());
                            boolean emptyStripper = true;
                            for (Patcher patcher = MinecraftUserRepo.this.parent; patcher != null; patcher = patcher.getParent()) {
                                String sas;
                                String at = patcher.getATData();
                                if (at != null && !at.isEmpty()) {
                                    function.addTransformer(at);
                                    emptyAT = false;
                                }
                                if ((sas = patcher.getSASData()) == null) continue;
                                stripper.addData(sas);
                                emptyStripper = false;
                            }
                            LinkedHashMap preDecomps = Maps.newLinkedHashMap();
                            if (!emptyAT) {
                                preDecomps.put("AccessTransformer", function);
                            }
                            if (!emptyStripper) {
                                preDecomps.put("SideStripper", stripper);
                            }
                            ret = new MCPRuntime(project, data, this.getConfig(), side, dir, preDecomps);
                            this.runtimes.put(side, ret);
                        }
                        return ret;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid patcher dependency: " + artifact, e);
            }
        }

        public byte[] getData(String ... path) throws IOException {
            return this.wrapper.getData(path);
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public File getZip() {
            return this.wrapper.getZip();
        }

        public String getVersion() {
            return this.artifact.getVersion();
        }

        public String getMCVersion() {
            return this.wrapper.getConfig().getVersion();
        }

        public List<String> getLibraries() {
            return this.wrapper.getConfig().getLibraries("joined");
        }

        public File getStepOutput(String side, String step) throws IOException {
            MCPRuntime runtime = this.wrapper.getRuntime(MinecraftUserRepo.this.project, side);
            try {
                return runtime.execute(MinecraftUserRepo.this.log, step);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                MinecraftUserRepo.this.log.lifecycle(e.getMessage());
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static class Patcher {
        private final File data;
        private final File universal;
        private final File sources;
        private final Artifact artifact;
        private final UserdevConfigV1 config;
        private final UserdevConfigV2 configv2;
        private Patcher parent;
        private String ATs = null;
        private String SASs = null;
        private Map<String, PatchFile> patches;
        private List<Pattern> universalFilters;

        private Patcher(Project project, File data, String artifact) {
            this.data = data;
            this.artifact = Artifact.from(artifact);
            try {
                byte[] cfg_data = Utils.getZipData(data, "config.json");
                int spec = Config.getSpec(cfg_data);
                if (spec == 1) {
                    this.config = UserdevConfigV1.get(cfg_data);
                    this.configv2 = null;
                } else if (spec == 2) {
                    this.configv2 = UserdevConfigV2.get(cfg_data);
                    this.config = this.configv2;
                } else {
                    throw new IllegalStateException("Could not load Patcher config, Unknown Spec: " + spec + " Dep: " + artifact);
                }
                if (this.getParentDesc() == null) {
                    throw new IllegalStateException("Invalid patcher dependency, missing MCP or parent: " + artifact);
                }
                if (this.config.universal != null) {
                    this.universal = MavenArtifactDownloader.manual(project, this.config.universal, false);
                    if (this.universal == null) {
                        throw new IllegalStateException("Invalid patcher dependency, could not resolve universal: " + this.universal);
                    }
                } else {
                    this.universal = null;
                }
                if (this.config.sources != null) {
                    this.sources = MavenArtifactDownloader.manual(project, this.config.sources, false);
                    if (this.sources == null) {
                        throw new IllegalStateException("Invalid patcher dependency, could not resolve sources: " + this.sources);
                    }
                } else {
                    this.sources = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid patcher dependency: " + artifact, e);
            }
        }

        public UserdevConfigV1 getConfig() {
            return this.config;
        }

        public UserdevConfigV2 getConfigV2() {
            return this.configv2;
        }

        public boolean parentIsMcp() {
            return this.config.mcp != null;
        }

        public void setParent(Patcher value) {
            this.parent = value;
        }

        public Patcher getParent() {
            return this.parent;
        }

        public String getParentDesc() {
            return this.config.mcp != null ? this.config.mcp : this.config.parent;
        }

        public List<String> getLibraries() {
            return this.config.libraries == null ? Collections.emptyList() : this.config.libraries;
        }

        public String getATData() {
            if (this.config.getATs().isEmpty()) {
                return null;
            }
            if (this.ATs == null) {
                StringBuilder buf = new StringBuilder();
                try (ZipFile zip = new ZipFile(this.data);){
                    for (String at : this.config.getATs()) {
                        ZipEntry entry = zip.getEntry(at);
                        if (entry == null) {
                            throw new IllegalStateException("Invalid Patcher config, Missing Access Transformer: " + at + " Zip: " + this.data);
                        }
                        buf.append("# ").append(this.artifact).append(" - ").append(at).append('\n');
                        buf.append(IOUtils.toString((InputStream)zip.getInputStream(entry), (Charset)Charsets.UTF_8));
                        buf.append('\n');
                    }
                    this.ATs = buf.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid patcher config: " + this.artifact, e);
                }
            }
            return this.ATs;
        }

        public String getSASData() {
            if (this.config.getSASs().isEmpty()) {
                return null;
            }
            if (this.SASs == null) {
                StringBuilder buf = new StringBuilder();
                try (ZipFile zip = new ZipFile(this.data);){
                    for (String sas : this.config.getSASs()) {
                        ZipEntry entry = zip.getEntry(sas);
                        if (entry == null) {
                            throw new IllegalStateException("Invalid Patcher config, Missing Side Annotation Stripper: " + sas + " Zip: " + this.data);
                        }
                        buf.append("# ").append(this.artifact).append(" - ").append(sas).append('\n');
                        buf.append(IOUtils.toString((InputStream)zip.getInputStream(entry), (Charset)Charsets.UTF_8));
                        buf.append('\n');
                    }
                    this.SASs = buf.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid patcher config: " + this.artifact, e);
                }
            }
            return this.SASs;
        }

        public File getZip() {
            return this.data;
        }

        public File getUniversal() {
            return this.universal;
        }

        public File getSources() {
            return this.sources;
        }

        public String getInject() {
            return this.config.inject;
        }

        public Map<String, PatchFile> getPatches() throws IOException {
            if (this.config.patches == null) {
                return Collections.emptyMap();
            }
            if (this.patches == null) {
                this.patches = new HashMap<String, PatchFile>();
                try (ZipInputStream zin = new ZipInputStream(new FileInputStream(this.getZip()));){
                    ZipEntry entry;
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().startsWith(this.config.patches) || !entry.getName().endsWith(".patch")) continue;
                        byte[] data = IOUtils.toByteArray((InputStream)zin);
                        this.patches.put(entry.getName().substring(0, entry.getName().length() - 6), PatchFile.from(data));
                    }
                }
            }
            return this.patches;
        }

        public List<Pattern> getUniversalFilters() {
            if (this.universalFilters == null) {
                this.universalFilters = new ArrayList<Pattern>();
                if (this.getConfigV2() != null) {
                    for (String filter : this.getConfigV2().getUniversalFilters()) {
                        this.universalFilters.add(Pattern.compile(filter));
                    }
                }
            }
            return this.universalFilters;
        }
    }
}

