/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.util.HashFunction;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.internal.hash.HashUtil;

public class HashStore {
    private final boolean INVALIDATE_CACHE = System.getProperty("FG_INVALIDATE_CACHE", "false").equals("true");
    private final int RAND_CACHE = new Random().nextInt();
    private final String root;
    private final Map<String, String> oldHashes = new HashMap<String, String>();
    private final Map<String, String> newHashes = new HashMap<String, String>();
    private File target;

    public HashStore() {
        this.root = "";
    }

    public HashStore(Project project) {
        this.root = project.getRootDir().getAbsolutePath();
    }

    public HashStore(File root) {
        this.root = root.getAbsolutePath();
    }

    public boolean areSame(File ... files) {
        for (File file : files) {
            if (this.isSame(file)) continue;
            return false;
        }
        return true;
    }

    public boolean areSame(Iterable<File> files) {
        for (File file : files) {
            if (this.isSame(file)) continue;
            return false;
        }
        return true;
    }

    public boolean isSame(File file) {
        try {
            String path = this.getPath(file);
            String hash = this.oldHashes.get(path);
            if (hash == null) {
                if (file.exists()) {
                    this.newHashes.put(path, HashFunction.SHA1.hash(file));
                    return false;
                }
                return true;
            }
            HashUtil.sha1((File)file);
            String fileHash = HashFunction.SHA1.hash(file);
            this.newHashes.put(path, fileHash);
            return fileHash.equals(hash);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public HashStore load(File file) throws IOException {
        this.target = file;
        this.oldHashes.clear();
        if (!file.exists()) {
            return this;
        }
        for (String line : FileUtils.readLines((File)file)) {
            String[] split = line.split("=");
            this.oldHashes.put(split[0], split[1]);
        }
        return this;
    }

    public boolean exists() {
        return this.target != null && this.target.exists();
    }

    public HashStore bust(int version) {
        this.newHashes.put("CACHE_BUSTER", Integer.toString(version));
        return this;
    }

    public HashStore add(String key, String data) {
        this.newHashes.put(key, HashFunction.SHA1.hash(data));
        return this;
    }

    public HashStore add(String key, byte[] data) {
        this.newHashes.put(key, HashFunction.SHA1.hash(data));
        return this;
    }

    public HashStore add(String key, File file) {
        try {
            this.newHashes.put(key == null ? this.getPath(file) : key, HashFunction.SHA1.hash(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HashStore add(File ... files) {
        for (File file : files) {
            this.add((String)null, file);
        }
        return this;
    }

    public HashStore add(Iterable<File> files) {
        for (File file : files) {
            this.add((String)null, file);
        }
        return this;
    }

    public HashStore add(File file) {
        this.add((String)null, file);
        return this;
    }

    public boolean isSame() {
        if (this.INVALIDATE_CACHE) {
            this.add("invalidate", "" + this.RAND_CACHE);
        }
        return this.oldHashes.equals(this.newHashes);
    }

    public void save() throws IOException {
        if (this.target == null) {
            throw new RuntimeException("HashStore.save() called without load(File) so we dont know where to save it! Use load(File) or save(File)");
        }
        this.save(this.target);
    }

    public void save(File file) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.newHashes.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("\n")).getBytes());
    }

    private String getPath(File file) {
        String path = file.getAbsolutePath();
        if (path.startsWith(this.root)) {
            return path.substring(this.root.length()).replace('\\', '/');
        }
        return path.replace('\\', '/');
    }
}

