/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskApplyMappings
extends DefaultTask {
    private static final Pattern SRG = Pattern.compile("func_[0-9]+_[a-zA-Z_]+|field_[0-9]+_[a-zA-Z_]+|p_[\\w]+_\\d+_\\b");
    private File mappings;
    private File input;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.zip"));

    @TaskAction
    public void apply() throws IOException {
        HashMap names = new HashMap();
        try (ZipFile zip = new ZipFile(this.getMappings());){
            zip.stream().filter(e -> e.getName().endsWith(".csv")).forEach(e -> {
                CsvReader reader = new CsvReader();
                reader.setContainsHeader(true);
                try {
                    CsvContainer csv = reader.read((Reader)new InputStreamReader(zip.getInputStream((ZipEntry)e)));
                    for (CsvRow row : csv.getRows()) {
                        if (row.getField("searge") != null) {
                            names.put(row.getField("searge"), row.getField("name"));
                            continue;
                        }
                        names.put(row.getField("param"), row.getField("name"));
                    }
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            });
        }
        var3_3 = null;
        try (ZipFile zin = new ZipFile(this.getInput());
             FileOutputStream fos = new FileOutputStream(this.getOutput());
             ZipOutputStream out = new ZipOutputStream(fos);){
            zin.stream().forEach(e -> {
                try {
                    out.putNextEntry(Utils.getStableEntry(e.getName()));
                    if (!e.getName().endsWith(".java")) {
                        IOUtils.copy((InputStream)zin.getInputStream((ZipEntry)e), (OutputStream)out);
                    } else {
                        out.write(this.replace(zin.getInputStream((ZipEntry)e), names).getBytes(StandardCharsets.UTF_8));
                    }
                    out.closeEntry();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            });
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private String replace(InputStream stream, Map<String, String> names) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        StringBuffer buf = new StringBuffer();
        Matcher matcher = SRG.matcher(writer.toString());
        while (matcher.find()) {
            String name = names.get(matcher.group());
            matcher.appendReplacement(buf, name == null ? matcher.group() : name);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    @InputFile
    public File getMappings() {
        return this.mappings;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setInput(File clean) {
        this.input = clean;
    }

    public void setMappings(File value) {
        this.mappings = value;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

