/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.DownloadMCMeta;
import net.minecraftforge.gradle.common.task.ExtractMCPData;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.task.ExtractZip;
import net.minecraftforge.gradle.common.task.TaskApplyMappings;
import net.minecraftforge.gradle.common.task.TaskApplyRangeMap;
import net.minecraftforge.gradle.common.task.TaskExtractExistingFiles;
import net.minecraftforge.gradle.common.task.TaskExtractRangeMap;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.mcp.MCPExtension;
import net.minecraftforge.gradle.mcp.MCPPlugin;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.mcp.function.AccessTransformerFunction;
import net.minecraftforge.gradle.mcp.function.SideAnnotationStripperFunction;
import net.minecraftforge.gradle.mcp.task.DownloadMCPConfigTask;
import net.minecraftforge.gradle.mcp.task.DownloadMCPMappingsTask;
import net.minecraftforge.gradle.mcp.task.SetupMCPTask;
import net.minecraftforge.gradle.patcher.PatcherExtension;
import net.minecraftforge.gradle.patcher.task.CreateFakeSASPatches;
import net.minecraftforge.gradle.patcher.task.GenerateBinPatches;
import net.minecraftforge.gradle.patcher.task.TaskApplyPatches;
import net.minecraftforge.gradle.patcher.task.TaskCreateExc;
import net.minecraftforge.gradle.patcher.task.TaskCreateSrg;
import net.minecraftforge.gradle.patcher.task.TaskFilterNewJar;
import net.minecraftforge.gradle.patcher.task.TaskGeneratePatches;
import net.minecraftforge.gradle.patcher.task.TaskGenerateUserdevConfig;
import net.minecraftforge.gradle.patcher.task.TaskReobfuscateJar;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public class PatcherPlugin
implements Plugin<Project> {
    private static final String MC_DEP_CONFIG = "compile";

    public void apply(@Nonnull Project project) {
        Utils.checkJavaVersion();
        PatcherExtension extension = (PatcherExtension)((Object)project.getExtensions().create(PatcherExtension.class, "patcher", PatcherExtension.class, new Object[]{project}));
        if (project.getPluginManager().findPlugin("java") == null) {
            project.getPluginManager().apply("java");
        }
        JavaPluginConvention javaConv = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
        File natives_folder = project.file((Object)"build/natives/");
        Jar jarConfig = (Jar)project.getTasks().getByName("jar");
        JavaCompile javaCompile = (JavaCompile)project.getTasks().getByName("compileJava");
        TaskProvider dlMappingsConfig = project.getTasks().register("downloadMappings", DownloadMCPMappingsTask.class);
        TaskProvider dlMCMetaConfig = project.getTasks().register("downloadMCMeta", DownloadMCMeta.class);
        TaskProvider extractNatives = project.getTasks().register("extractNatives", ExtractNatives.class);
        TaskProvider applyConfig = project.getTasks().register("applyPatches", TaskApplyPatches.class);
        TaskProvider toMCPConfig = project.getTasks().register("srg2mcp", TaskApplyMappings.class);
        TaskProvider extractMapped = project.getTasks().register("extractMapped", ExtractZip.class);
        TaskProvider createMcp2Srg = project.getTasks().register("createMcp2Srg", TaskCreateSrg.class);
        TaskProvider createMcp2Obf = project.getTasks().register("createMcp2Obf", TaskCreateSrg.class);
        TaskProvider createExc = project.getTasks().register("createExc", TaskCreateExc.class);
        TaskProvider extractRangeConfig = project.getTasks().register("extractRangeMap", TaskExtractRangeMap.class);
        TaskProvider applyRangeConfig = project.getTasks().register("applyRangeMap", TaskApplyRangeMap.class);
        TaskProvider applyRangeBaseConfig = project.getTasks().register("applyRangeMapBase", TaskApplyRangeMap.class);
        TaskProvider genConfig = project.getTasks().register("genPatches", TaskGeneratePatches.class);
        TaskProvider downloadAssets = project.getTasks().register("downloadAssets", DownloadAssets.class);
        TaskProvider reobfJar = project.getTasks().register("reobfJar", TaskReobfuscateJar.class);
        TaskProvider genJoinedBinPatches = project.getTasks().register("genJoinedBinPatches", GenerateBinPatches.class);
        TaskProvider genClientBinPatches = project.getTasks().register("genClientBinPatches", GenerateBinPatches.class);
        TaskProvider genServerBinPatches = project.getTasks().register("genServerBinPatches", GenerateBinPatches.class);
        TaskProvider genBinPatches = project.getTasks().register("genBinPatches", DefaultTask.class);
        TaskProvider filterNew = project.getTasks().register("filterJarNew", TaskFilterNewJar.class);
        TaskProvider sourcesJar = project.getTasks().register("sourcesJar", Jar.class);
        TaskProvider universalJar = project.getTasks().register("universalJar", Jar.class);
        TaskProvider userdevJar = project.getTasks().register("userdevJar", Jar.class);
        TaskProvider userdevConfig = project.getTasks().register("userdevConfig", TaskGenerateUserdevConfig.class, new Object[]{project});
        TaskProvider release = project.getTasks().register("release", DefaultTask.class);
        project.getRepositories().maven(e -> e.setUrl((Object)"https://files.minecraftforge.net/maven/"));
        new BaseRepo.Builder().add(MCPRepo.create(project)).add(MinecraftRepo.create(project)).attach(project);
        project.getRepositories().maven(e -> {
            e.setUrl((Object)"https://libraries.minecraft.net/");
            e.metadataSources(src -> src.artifact());
        });
        release.configure(task -> task.dependsOn(new Object[]{sourcesJar, universalJar, userdevJar}));
        dlMappingsConfig.configure(task -> task.setMappings(extension.getMappings()));
        extractNatives.configure(task -> {
            task.dependsOn(new Object[]{dlMCMetaConfig.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()))).getOutput());
            task.setOutput(natives_folder);
        });
        downloadAssets.configure(task -> {
            task.dependsOn(new Object[]{dlMCMetaConfig.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()))).getOutput());
        });
        applyConfig.configure(task -> {
            task.setPatches(extension.patches);
            task.setFailOnErrors(!project.hasProperty("UPDATING"));
        });
        toMCPConfig.configure(task -> {
            task.dependsOn(new Object[]{dlMappingsConfig, applyConfig});
            task.setInput(((TaskApplyPatches)((Object)((Object)applyConfig.get()))).getOutput());
            task.setMappings(((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).getOutput());
        });
        extractMapped.configure(task -> {
            task.dependsOn(new Object[]{toMCPConfig});
            task.setZip(((TaskApplyMappings)((Object)((Object)toMCPConfig.get()))).getOutput());
            task.setOutput(extension.patchedSrc);
        });
        extractRangeConfig.configure(task -> {
            task.dependsOn(new Object[]{jarConfig});
            task.setOnlyIf(t -> extension.patches != null);
            task.addDependencies(jarConfig.getArchivePath());
        });
        createMcp2Srg.configure(task -> {
            task.dependsOn(new Object[]{dlMappingsConfig});
            task.setMappings(((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).getOutput());
            task.toSrg();
        });
        createMcp2Obf.configure(task -> {
            task.dependsOn(new Object[]{dlMappingsConfig});
            task.setMappings(((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).getOutput());
            task.toNotch();
        });
        createExc.configure(task -> {
            task.dependsOn(new Object[]{dlMappingsConfig});
            task.setMappings(((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).getOutput());
        });
        applyRangeConfig.configure(task -> {
            task.dependsOn(new Object[]{extractRangeConfig, createMcp2Srg, createExc});
            task.setRangeMap(((TaskExtractRangeMap)((Object)((Object)extractRangeConfig.get()))).getOutput());
            task.setSrgFiles(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getOutput());
            task.setExcFiles(((TaskCreateExc)((Object)((Object)createExc.get()))).getOutput());
        });
        applyRangeBaseConfig.configure(task -> {
            task.setOnlyIf(t -> extension.patches != null);
            task.dependsOn(new Object[]{extractRangeConfig, createMcp2Srg, createExc});
            task.setRangeMap(((TaskExtractRangeMap)((Object)((Object)extractRangeConfig.get()))).getOutput());
            task.setSrgFiles(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getOutput());
            task.setExcFiles(((TaskCreateExc)((Object)((Object)createExc.get()))).getOutput());
        });
        genConfig.configure(task -> {
            task.setOnlyIf(t -> extension.patches != null);
            task.setPatches(extension.patches);
        });
        reobfJar.configure(task -> {
            task.dependsOn(new Object[]{jarConfig, dlMappingsConfig});
            task.setInput(jarConfig.getArchivePath());
            task.setClasspath((FileCollection)project.getConfigurations().getByName(MC_DEP_CONFIG));
        });
        genJoinedBinPatches.configure(task -> {
            task.dependsOn(new Object[]{reobfJar});
            task.setDirtyJar(((TaskReobfuscateJar)((Object)((Object)reobfJar.get()))).getOutput());
            task.addPatchSet(extension.patches);
            task.setSide("joined");
        });
        genClientBinPatches.configure(task -> {
            task.dependsOn(new Object[]{reobfJar});
            task.setDirtyJar(((TaskReobfuscateJar)((Object)((Object)reobfJar.get()))).getOutput());
            task.addPatchSet(extension.patches);
            task.setSide("client");
        });
        genServerBinPatches.configure(task -> {
            task.dependsOn(new Object[]{reobfJar});
            task.setDirtyJar(((TaskReobfuscateJar)((Object)((Object)reobfJar.get()))).getOutput());
            task.addPatchSet(extension.patches);
            task.setSide("server");
        });
        genBinPatches.configure(task -> task.dependsOn(new Object[]{genJoinedBinPatches.get(), genClientBinPatches.get(), genServerBinPatches.get()}));
        filterNew.configure(task -> {
            task.dependsOn(new Object[]{reobfJar});
            task.setInput(((TaskReobfuscateJar)((Object)((Object)reobfJar.get()))).getOutput());
        });
        sourcesJar.configure(task -> {
            task.dependsOn(new Object[]{applyRangeConfig});
            task.from(new Object[]{project.zipTree((Object)((TaskApplyRangeMap)((Object)((Object)applyRangeConfig.get()))).getOutput())});
            task.setClassifier("sources");
        });
        universalJar.configure(task -> {
            task.dependsOn(new Object[]{filterNew});
            task.from(new Object[]{project.zipTree((Object)((TaskFilterNewJar)((Object)((Object)filterNew.get()))).getOutput())});
            task.from(new Object[]{((SourceSet)javaConv.getSourceSets().getByName("main")).getResources()});
            task.setClassifier("universal");
        });
        userdevJar.configure(task -> {
            task.dependsOn(new Object[]{userdevConfig, genJoinedBinPatches, sourcesJar, genConfig});
            task.setOnlyIf(t -> extension.srgPatches);
            task.from((Object)((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).getOutput(), e -> e.rename(f -> "config.json"));
            task.from((Object)((GenerateBinPatches)((Object)((Object)genJoinedBinPatches.get()))).getOutput(), e -> e.rename(f -> "joined.lzma"));
            task.from((Object)((TaskGeneratePatches)((Object)((Object)genConfig.get()))).getPatches(), e -> e.into((Object)"patches/"));
            task.setClassifier("userdev");
        });
        boolean doingUpdate = project.hasProperty("UPDATE_MAPPINGS");
        if (doingUpdate) {
            String version = (String)project.property("UPDATE_MAPPINGS");
            String channel = project.hasProperty("UPDATE_MAPPINGS_CHANNEL") ? (String)project.property("UPDATE_MAPPINGS_CHANNEL") : "snapshot";
            TaskProvider dlMappingsNew = project.getTasks().register("downloadMappingsNew", DownloadMCPMappingsTask.class);
            ((DownloadMCPMappingsTask)((Object)dlMappingsNew.get())).setMappings(channel + '_' + version);
            TaskProvider toMCPNew = project.getTasks().register("srg2mcpNew", TaskApplyMappings.class);
            toMCPNew.configure(task -> {
                task.dependsOn(new Object[]{dlMappingsNew.get(), applyRangeConfig.get()});
                task.setInput(((TaskApplyRangeMap)((Object)((Object)applyRangeConfig.get()))).getOutput());
                task.setMappings(((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).getOutput());
            });
            TaskProvider extractMappedNew = project.getTasks().register("extractMappedNew", TaskExtractExistingFiles.class);
            extractMappedNew.configure(task -> {
                task.dependsOn(new Object[]{toMCPNew.get()});
                task.setArchive(((TaskApplyMappings)((Object)((Object)toMCPNew.get()))).getOutput());
            });
            TaskProvider updateMappings = project.getTasks().register("updateMappings", DefaultTask.class);
            ((DefaultTask)updateMappings.get()).dependsOn(new Object[]{extractMappedNew.get()});
        }
        project.afterEvaluate(p -> {
            SetupMCPTask setupMCP;
            Project mcp;
            SourceSet mainSource = (SourceSet)javaConv.getSourceSets().getByName("main");
            ((TaskApplyRangeMap)((Object)((Object)applyRangeConfig.get()))).setSources(mainSource.getJava().getSrcDirs().stream().filter(f -> !f.equals(extension.patchedSrc)).collect(Collectors.toList()));
            ((TaskApplyRangeMap)((Object)((Object)applyRangeBaseConfig.get()))).setSources(extension.patchedSrc);
            mainSource.java(v -> v.srcDir((Object)extension.patchedSrc));
            if (doingUpdate) {
                TaskExtractExistingFiles extract = (TaskExtractExistingFiles)p.getTasks().getByName("extractMappedNew");
                for (File dir : mainSource.getJava().getSrcDirs()) {
                    if (dir.equals(extension.patchedSrc)) continue;
                    extract.addTarget(dir);
                }
            }
            ((TaskExtractRangeMap)((Object)((Object)extractRangeConfig.get()))).addSources(mainSource.getJava().getSrcDirs());
            ((TaskExtractRangeMap)((Object)((Object)extractRangeConfig.get()))).addDependencies(javaCompile.getClasspath());
            if (extension.patches != null && !extension.patches.exists()) {
                extension.patches.mkdirs();
            }
            if (extension.patches != null) {
                ((Jar)sourcesJar.get()).dependsOn(new Object[]{genConfig});
                ((Jar)sourcesJar.get()).from((Object)((TaskGeneratePatches)((Object)((Object)genConfig.get()))).getPatches(), e -> e.into((Object)"patches/"));
            }
            if (extension.parent != null) {
                TaskContainer tasks = extension.parent.getTasks();
                MCPPlugin mcp2 = (MCPPlugin)extension.parent.getPlugins().findPlugin(MCPPlugin.class);
                PatcherPlugin patcher = (PatcherPlugin)extension.parent.getPlugins().findPlugin(PatcherPlugin.class);
                if (mcp2 != null) {
                    TaskProvider ext;
                    SetupMCPTask setupMCP2 = (SetupMCPTask)tasks.getByName("setupMCP");
                    if (extension.cleanSrc == null) {
                        extension.cleanSrc = setupMCP2.getOutput();
                        ((TaskApplyPatches)((Object)((Object)applyConfig.get()))).dependsOn(new Object[]{setupMCP2});
                        ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).dependsOn(new Object[]{setupMCP2});
                    }
                    if (((TaskApplyPatches)((Object)((Object)applyConfig.get()))).getClean() == null) {
                        ((TaskApplyPatches)((Object)((Object)applyConfig.get()))).setClean(extension.cleanSrc);
                    }
                    if (((TaskGeneratePatches)((Object)((Object)genConfig.get()))).getClean() == null) {
                        ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).setClean(extension.cleanSrc);
                    }
                    File mcpConfig = ((DownloadMCPConfigTask)tasks.getByName("downloadConfig")).getOutput();
                    if (((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getSrg() == null) {
                        ext = project.getTasks().register("extractSrg", ExtractMCPData.class);
                        ((ExtractMCPData)((Object)((Object)ext.get()))).setConfig(mcpConfig);
                        ((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).setSrg(((ExtractMCPData)((Object)((Object)ext.get()))).getOutput());
                        ((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).dependsOn(new Object[]{ext});
                    }
                    if (((TaskCreateSrg)((Object)((Object)createMcp2Obf.get()))).getSrg() == null) {
                        ((TaskCreateSrg)((Object)((Object)createMcp2Obf.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getSrg());
                    }
                    if (((TaskCreateExc)((Object)((Object)createExc.get()))).getSrg() == null) {
                        ((TaskCreateExc)((Object)((Object)createExc.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getSrg());
                        ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{createMcp2Srg});
                    }
                    if (((TaskCreateExc)((Object)((Object)createExc.get()))).getStatics() == null) {
                        ext = project.getTasks().register("extractStatic", ExtractMCPData.class);
                        ((ExtractMCPData)((Object)((Object)ext.get()))).setConfig(mcpConfig);
                        ((ExtractMCPData)((Object)((Object)ext.get()))).setKey("statics");
                        ((ExtractMCPData)((Object)((Object)ext.get()))).setOutput(project.file((Object)("build/" + ((ExtractMCPData)((Object)((Object)ext.get()))).getName() + "/output.txt")));
                        ((TaskCreateExc)((Object)((Object)createExc.get()))).setStatics(((ExtractMCPData)((Object)((Object)ext.get()))).getOutput());
                        ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{ext});
                    }
                    if (((TaskCreateExc)((Object)((Object)createExc.get()))).getConstructors() == null) {
                        ext = project.getTasks().register("extractConstructors", ExtractMCPData.class);
                        ((ExtractMCPData)((Object)((Object)ext.get()))).setConfig(mcpConfig);
                        ((ExtractMCPData)((Object)((Object)ext.get()))).setKey("constructors");
                        ((ExtractMCPData)((Object)((Object)ext.get()))).setOutput(project.file((Object)("build/" + ((ExtractMCPData)((Object)((Object)ext.get()))).getName() + "/output.txt")));
                        ((TaskCreateExc)((Object)((Object)createExc.get()))).setConstructors(((ExtractMCPData)((Object)((Object)ext.get()))).getOutput());
                        ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{ext});
                    }
                } else if (patcher != null) {
                    DefaultTask task3;
                    Object extract;
                    PatcherExtension pExt = (PatcherExtension)((Object)((Object)extension.parent.getExtensions().getByType(PatcherExtension.class)));
                    extension.copyFrom(pExt);
                    if (((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).getMappings() == null) {
                        ((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).setMappings(extension.getMappings());
                    }
                    if (extension.cleanSrc == null) {
                        TaskApplyPatches task2 = (TaskApplyPatches)tasks.getByName(((TaskApplyPatches)((Object)((Object)applyConfig.get()))).getName());
                        extension.cleanSrc = task2.getOutput();
                        ((TaskApplyPatches)((Object)((Object)applyConfig.get()))).dependsOn(new Object[]{task2});
                        ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).dependsOn(new Object[]{task2});
                    }
                    if (((TaskApplyPatches)((Object)((Object)applyConfig.get()))).getClean() == null) {
                        ((TaskApplyPatches)((Object)((Object)applyConfig.get()))).setClean(extension.cleanSrc);
                    }
                    if (((TaskGeneratePatches)((Object)((Object)genConfig.get()))).getClean() == null) {
                        ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).setClean(extension.cleanSrc);
                    }
                    if (((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getSrg() == null) {
                        extract = (ExtractMCPData)tasks.getByName("extractSrg");
                        if (extract != null) {
                            ((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).setSrg(extract.getOutput());
                            ((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).dependsOn(new Object[]{extract});
                        } else {
                            task3 = (TaskCreateSrg)tasks.getByName(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getName());
                            ((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).setSrg(task3.getSrg());
                            ((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).dependsOn(new Object[]{task3});
                        }
                    }
                    if (((TaskCreateSrg)((Object)((Object)createMcp2Obf.get()))).getSrg() == null) {
                        ((TaskCreateSrg)((Object)((Object)createMcp2Obf.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getSrg());
                        ((TaskCreateSrg)((Object)((Object)createMcp2Obf.get()))).dependsOn(new Object[]{createMcp2Srg.get()});
                    }
                    if (((TaskCreateExc)((Object)((Object)createExc.get()))).getSrg() == null) {
                        extract = (ExtractMCPData)tasks.getByName("extractSrg");
                        if (extract != null) {
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).setSrg(extract.getOutput());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{extract});
                        } else {
                            task3 = (TaskCreateSrg)tasks.getByName(((TaskCreateExc)((Object)((Object)createExc.get()))).getName());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).setSrg(task3.getSrg());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{task3});
                        }
                    }
                    if (((TaskCreateExc)((Object)((Object)createExc.get()))).getStatics() == null) {
                        extract = (ExtractMCPData)tasks.getByName("extractStatic");
                        if (extract != null) {
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).setStatics(extract.getOutput());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{extract});
                        } else {
                            task3 = (TaskCreateExc)tasks.getByName(((TaskCreateExc)((Object)((Object)createExc.get()))).getName());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).setStatics(task3.getStatics());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{task3});
                        }
                    }
                    if (((TaskCreateExc)((Object)((Object)createExc.get()))).getConstructors() == null) {
                        extract = (ExtractMCPData)tasks.getByName("extractConstructors");
                        if (extract != null) {
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).setConstructors(extract.getOutput());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{extract});
                        } else {
                            task3 = (TaskCreateExc)tasks.getByName(((TaskCreateExc)((Object)((Object)createExc.get()))).getName());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).setConstructors(task3.getConstructors());
                            ((TaskCreateExc)((Object)((Object)createExc.get()))).dependsOn(new Object[]{task3});
                        }
                    }
                    for (DefaultTask task3 : Lists.newArrayList((Object[])new TaskProvider[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches})) {
                        GenerateBinPatches pgen = (GenerateBinPatches)tasks.getByName(((GenerateBinPatches)((Object)((Object)task3.get()))).getName());
                        for (File patches : pgen.getPatchSets()) {
                            ((GenerateBinPatches)((Object)((Object)task3.get()))).addPatchSet(patches);
                        }
                    }
                    ((TaskFilterNewJar)((Object)((Object)filterNew.get()))).dependsOn(new Object[]{tasks.getByName("jar")});
                    ((TaskFilterNewJar)((Object)((Object)filterNew.get()))).addBlacklist(((Jar)tasks.getByName("jar")).getArchivePath());
                } else {
                    throw new IllegalStateException("Parent must either be a Patcher or MCP project");
                }
            }
            project.getDependencies().add(MC_DEP_CONFIG, (Object)("net.minecraft:client:" + extension.mcVersion + ":extra"));
            project.getDependencies().add(MC_DEP_CONFIG, (Object)MCPRepo.getMappingDep(extension.getMappingChannel(), extension.getMappingVersion()));
            if (((DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()))).getMCVersion() == null) {
                ((DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()))).setMCVersion(extension.mcVersion);
            }
            if (!extension.getAccessTransformers().isEmpty()) {
                mcp = this.getMcpParent(project);
                if (mcp == null) {
                    throw new IllegalStateException("AccessTransformers specified, with no MCP Parent");
                }
                setupMCP = (SetupMCPTask)mcp.getTasks().getByName("setupMCP");
                setupMCP.addPreDecompile(project.getName() + "AccessTransformer", new AccessTransformerFunction(mcp, extension.getAccessTransformers()));
                extension.getAccessTransformers().forEach(f -> {
                    ((Jar)userdevJar.get()).from(f, e -> e.into((Object)"ats/"));
                    ((TaskGenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).addAT((File)f);
                });
            }
            if (!extension.getSideAnnotationStrippers().isEmpty()) {
                mcp = this.getMcpParent(project);
                if (mcp == null) {
                    throw new IllegalStateException("SideAnnotationStrippers specified, with no MCP Parent");
                }
                setupMCP = (SetupMCPTask)mcp.getTasks().getByName("setupMCP");
                setupMCP.addPreDecompile(project.getName() + "SideStripper", new SideAnnotationStripperFunction(mcp, extension.getSideAnnotationStrippers()));
                extension.getSideAnnotationStrippers().forEach(f -> {
                    ((Jar)userdevJar.get()).from(f, e -> e.into((Object)"sas/"));
                    ((TaskGenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).addSAS((File)f);
                });
            }
            CreateFakeSASPatches fakePatches = null;
            PatcherExtension ext = extension;
            while (ext != null) {
                if (!ext.getSideAnnotationStrippers().isEmpty()) {
                    if (fakePatches == null) {
                        fakePatches = (CreateFakeSASPatches)((Object)((Object)project.getTasks().register("createFakeSASPatches", CreateFakeSASPatches.class).get()));
                    }
                    ext.getSideAnnotationStrippers().forEach(fakePatches::addFile);
                }
                if (ext.parent == null) continue;
                ext = (PatcherExtension)((Object)((Object)ext.parent.getExtensions().findByType(PatcherExtension.class)));
            }
            if (fakePatches != null) {
                for (TaskProvider task : Lists.newArrayList((Object[])new TaskProvider[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches})) {
                    ((GenerateBinPatches)((Object)((Object)task.get()))).dependsOn(new Object[]{fakePatches});
                    ((GenerateBinPatches)((Object)((Object)task.get()))).addPatchSet(fakePatches.getOutput());
                }
            }
            ((TaskApplyRangeMap)((Object)((Object)applyRangeConfig.get()))).setExcFiles(extension.getExcs());
            ((TaskApplyRangeMap)((Object)((Object)applyRangeBaseConfig.get()))).setExcFiles(extension.getExcs());
            if (!extension.getExtraMappings().isEmpty()) {
                extension.getExtraMappings().stream().filter(e -> e instanceof File).map(e -> (File)e).forEach(e -> {
                    ((Jar)userdevJar.get()).from(e, c -> c.into((Object)"srgs/"));
                    ((TaskGenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).addSRG((File)e);
                });
                extension.getExtraMappings().stream().filter(e -> e instanceof String).map(e -> (String)e).forEach(e -> ((TaskGenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).addSRGLine((String)e));
            }
            if (((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).getTool() == null) {
                ((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).setTool("net.minecraftforge:binarypatcher:" + ((GenerateBinPatches)((Object)((Object)genJoinedBinPatches.get()))).getResolvedVersion() + ":fatjar");
                ((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).setArguments("--clean", "{clean}", "--output", "{output}", "--apply", "{patch}");
            }
            if (((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).getUniversal() == null) {
                ((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).setUniversal(project.getGroup().toString() + ':' + ((Jar)universalJar.get()).getBaseName() + ':' + project.getVersion() + ':' + ((Jar)universalJar.get()).getClassifier() + '@' + ((Jar)universalJar.get()).getExtension());
            }
            if (((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).getSource() == null) {
                ((TaskGenerateUserdevConfig)((Object)((Object)userdevConfig.get()))).setSource(project.getGroup().toString() + ':' + ((Jar)sourcesJar.get()).getBaseName() + ':' + project.getVersion() + ':' + ((Jar)sourcesJar.get()).getClassifier() + '@' + ((Jar)sourcesJar.get()).getExtension());
            }
            if (extension.srgPatches) {
                ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).dependsOn(new Object[]{applyRangeBaseConfig});
                ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).setModified(((TaskApplyRangeMap)((Object)((Object)applyRangeBaseConfig.get()))).getOutput());
            } else {
                TaskApplyMappings toMCPClean = (TaskApplyMappings)((Object)((Object)project.getTasks().register("srg2mcpClean", TaskApplyMappings.class).get()));
                toMCPClean.dependsOn(new Object[]{dlMappingsConfig, Lists.newArrayList((Iterable)((TaskApplyPatches)((Object)((Object)applyConfig.get()))).getDependsOn())});
                toMCPClean.setInput(((TaskApplyPatches)((Object)((Object)applyConfig.get()))).getClean());
                toMCPClean.setMappings(((DownloadMCPMappingsTask)((Object)((Object)dlMappingsConfig.get()))).getOutput());
                Zip dirtyZip = (Zip)project.getTasks().register("patchedZip", Zip.class).get();
                dirtyZip.from(new Object[]{extension.patchedSrc});
                dirtyZip.setArchiveName("output.zip");
                dirtyZip.setDestinationDir(project.file((Object)("build/" + dirtyZip.getName() + "/")));
                ((TaskApplyPatches)((Object)((Object)applyConfig.get()))).setDependsOn(Lists.newArrayList((Object[])new TaskApplyMappings[]{toMCPClean}));
                ((TaskApplyPatches)((Object)((Object)applyConfig.get()))).setClean(toMCPClean.getOutput());
                ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).setDependsOn(Lists.newArrayList((Object[])new DefaultTask[]{toMCPClean, dirtyZip}));
                ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).setClean(toMCPClean.getOutput());
                ((TaskGeneratePatches)((Object)((Object)genConfig.get()))).setModified(dirtyZip.getArchivePath());
            }
            Project mcp3 = this.getMcpParent(project);
            if (mcp3 == null) {
                throw new IllegalStateException("Could not find MCP parent project, you must specify a parent chain to MCP.");
            }
            String mcp_version = ((MCPExtension)mcp3.getExtensions().findByType(MCPExtension.class)).getConfig().getVersion();
            File client = MavenArtifactDownloader.generate(project, "net.minecraft:client:" + mcp_version + ":srg", true);
            File server = MavenArtifactDownloader.generate(project, "net.minecraft:server:" + mcp_version + ":srg", true);
            File joined = MavenArtifactDownloader.generate(project, "net.minecraft:joined:" + mcp_version + ":srg", true);
            if (client == null || !client.exists()) {
                throw new RuntimeException("Something horrible happenend, client SRG jar nor found");
            }
            if (server == null || !server.exists()) {
                throw new RuntimeException("Something horrible happenend, server SRG jar nor found");
            }
            if (joined == null || !joined.exists()) {
                throw new RuntimeException("Something horrible happenend, joined SRG jar nor found");
            }
            ((TaskReobfuscateJar)((Object)((Object)reobfJar.get()))).dependsOn(new Object[]{createMcp2Srg});
            ((TaskReobfuscateJar)((Object)((Object)reobfJar.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getOutput());
            ((GenerateBinPatches)((Object)((Object)genJoinedBinPatches.get()))).dependsOn(new Object[]{createMcp2Srg});
            ((GenerateBinPatches)((Object)((Object)genJoinedBinPatches.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getOutput());
            ((GenerateBinPatches)((Object)((Object)genJoinedBinPatches.get()))).setCleanJar(joined);
            ((GenerateBinPatches)((Object)((Object)genClientBinPatches.get()))).dependsOn(new Object[]{createMcp2Srg});
            ((GenerateBinPatches)((Object)((Object)genClientBinPatches.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getOutput());
            ((GenerateBinPatches)((Object)((Object)genClientBinPatches.get()))).setCleanJar(client);
            ((GenerateBinPatches)((Object)((Object)genServerBinPatches.get()))).dependsOn(new Object[]{createMcp2Srg});
            ((GenerateBinPatches)((Object)((Object)genServerBinPatches.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getOutput());
            ((GenerateBinPatches)((Object)((Object)genServerBinPatches.get()))).setCleanJar(server);
            ((TaskFilterNewJar)((Object)((Object)filterNew.get()))).dependsOn(new Object[]{createMcp2Srg});
            ((TaskFilterNewJar)((Object)((Object)filterNew.get()))).setSrg(((TaskCreateSrg)((Object)((Object)createMcp2Srg.get()))).getOutput());
            ((TaskFilterNewJar)((Object)((Object)filterNew.get()))).addBlacklist(joined);
            HashMap<String, String> tokens = new HashMap<String, String>();
            try {
                if (!((DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()))).getOutput().exists()) {
                    ((DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()))).downloadMCMeta();
                }
                VersionJson json = Utils.loadJson(((DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()))).getOutput(), VersionJson.class);
                tokens.put("asset_index", json.assetIndex.id);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                tokens.put("asset_index", extension.getMcVersion());
            }
            extension.getRuns().forEach(runConfig -> runConfig.tokens(tokens));
            extension.createRunConfigTasks((TaskProvider<ExtractNatives>)extractNatives, (TaskProvider<DownloadAssets>)downloadAssets);
        });
    }

    private Project getMcpParent(Project project) {
        PatcherExtension extension = (PatcherExtension)((Object)project.getExtensions().findByType(PatcherExtension.class));
        if (extension == null || extension.parent == null) {
            return null;
        }
        MCPPlugin mcp = (MCPPlugin)extension.parent.getPlugins().findPlugin(MCPPlugin.class);
        PatcherPlugin patcher = (PatcherPlugin)extension.parent.getPlugins().findPlugin(PatcherPlugin.class);
        if (mcp != null) {
            return extension.parent;
        }
        if (patcher != null) {
            return this.getMcpParent(extension.parent);
        }
        return null;
    }
}

