/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import com.cloudbees.diff.PatchException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.diff.ContextualPatch;
import net.minecraftforge.gradle.common.diff.HunkReport;
import net.minecraftforge.gradle.common.diff.PatchFile;
import net.minecraftforge.gradle.common.diff.ZipContext;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.apache.commons.io.IOUtils;

public class PatchFunction
implements MCPFunction {
    private String path;
    private Map<String, String> patches;

    @Override
    public void loadData(Map<String, String> data) {
        this.path = data.get("patches");
    }

    @Override
    public void initialize(MCPEnvironment environment, ZipFile zip) throws IOException {
        this.patches = zip.stream().filter(e -> !e.isDirectory() && e.getName().startsWith(this.path) && e.getName().endsWith(".patch")).collect(Collectors.toMap(e -> e.getName().substring(this.path.length()), e -> {
            try {
                return IOUtils.toString((InputStream)zip.getInputStream((ZipEntry)e));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }));
    }

    @Override
    public File execute(MCPEnvironment environment) throws Exception {
        File input = (File)environment.getArguments().get("input");
        File output = environment.getFile("output.jar");
        File hashFile = environment.getFile("lastinput.sha1");
        HashStore hashStore = new HashStore(environment.project).load(hashFile);
        if (hashStore.isSame(input) && output.exists()) {
            return output;
        }
        try (ZipFile zip = new ZipFile(input);){
            ZipContext context = new ZipContext(zip);
            boolean success = true;
            for (Map.Entry<String, String> entry : this.patches.entrySet()) {
                ContextualPatch patch = ContextualPatch.create(PatchFile.from(entry.getValue()), context);
                patch.setCanonialization(true, false);
                patch.setMaxFuzz(0);
                try {
                    environment.logger.info("Apply Patch: " + entry.getKey());
                    List<ContextualPatch.PatchReport> result = patch.patch(false);
                    for (int x = 0; x < result.size(); ++x) {
                        ContextualPatch.PatchReport report = result.get(x);
                        if (report.getStatus().isSuccess()) continue;
                        success = false;
                        for (int y = 0; y < report.hunkReports().size(); ++y) {
                            HunkReport hunk = report.hunkReports().get(y);
                            if (!hunk.hasFailed()) continue;
                            if (hunk.failure == null) {
                                environment.logger.error("  Hunk #" + hunk.hunkID + " Failed @" + hunk.index + " Fuzz: " + hunk.fuzz);
                                continue;
                            }
                            environment.logger.error("  Hunk #" + hunk.hunkID + " Failed: " + hunk.failure.getMessage());
                        }
                    }
                }
                catch (PatchException | IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (success) {
                context.save(output);
                hashStore.save(hashFile);
            }
        }
        return output;
    }

    @Override
    public void cleanup(MCPEnvironment environment) {
        this.patches.clear();
    }
}

