/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class MappingFile {
    private static final Joiner SPACE = Joiner.on((String)" ");
    private static final Pattern DESC = Pattern.compile("L(?<cls>[^;]+);");
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Map<String, Cls> classes = new HashMap<String, Cls>();
    private Map<String, String> cache = new HashMap<String, String>();

    public static MappingFile load(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            MappingFile mappingFile = MappingFile.load(input);
            return mappingFile;
        }
    }

    public static MappingFile load(InputStream input) throws IOException {
        MappingFile ret = new MappingFile();
        List lines = IOUtils.readLines((InputStream)input).stream().map(line -> (line + '#').split("#")[0].replaceFirst("\\s++$", "")).filter(l -> !l.isEmpty()).collect(Collectors.toList());
        String firstLine = (String)lines.get(0);
        String test = firstLine.split(" ")[0];
        if ("PK:".equals(test) || "CL:".equals(test) || "FD:".equals(test) || "MD:".equals(test)) {
            block12: for (String line2 : lines) {
                Object[] pts2 = line2.split(" ");
                switch (pts2[0]) {
                    case "PK:": {
                        ret.addPackage(pts2[1], pts2[2]);
                        continue block12;
                    }
                    case "CL:": {
                        ret.addClass(pts2[1], pts2[2]);
                        continue block12;
                    }
                    case "FD:": {
                        ret.getClass(MappingFile.rsplit(pts2[1], '/', 1)[0]).addField(MappingFile.rsplit((String)pts2[1], '/', 1)[1], MappingFile.rsplit((String)pts2[2], '/', 1)[1]);
                        continue block12;
                    }
                    case "MD:": {
                        ret.getClass(MappingFile.rsplit(pts2[1], '/', 1)[0]).addMethod(MappingFile.rsplit((String)pts2[1], '/', 1)[1], (String)pts2[2], MappingFile.rsplit((String)pts2[3], '/', 1)[1]);
                        continue block12;
                    }
                }
                throw new IOException("Invalid SRG file, Unknown type: " + SPACE.join(pts2));
            }
        } else if (firstLine.contains(" -> ")) {
            for (Object line3 : lines) {
                if (((String)line3).startsWith("    ") || !((String)line3).endsWith(":")) continue;
                String[] pts3 = ((String)line3).replace('.', '/').split(" -> ");
                ret.addClass(pts3[0], pts3[1].substring(0, pts3[1].length() - 1));
            }
            String cls = null;
            for (String line4 : lines) {
                if (!(line4 = line4.replace('.', '/')).startsWith("    ") && line4.endsWith(":")) {
                    cls = line4.split(" -> ")[0];
                    continue;
                }
                if (line4.contains("(") && line4.contains(")")) {
                    if (cls == null) {
                        throw new IOException("Invalid PG line, missing class: " + line4);
                    }
                    line4 = line4.trim();
                    int start = -1;
                    int end = -1;
                    if (line4.indexOf(58) != -1) {
                        int i = line4.indexOf(58);
                        int j = line4.indexOf(58, i + 1);
                        start = Integer.parseInt(line4.substring(0, i));
                        end = Integer.parseInt(line4.substring(i + 1, j));
                        line4 = line4.substring(j + 1);
                    }
                    String obf = line4.split(" -> ")[1];
                    String _ret = MappingFile.toDesc(line4.split(" ")[0]);
                    String name = line4.substring(line4.indexOf(32) + 1, line4.indexOf(40));
                    String[] args = line4.substring(line4.indexOf(40) + 1, line4.indexOf(41)).split(",");
                    StringBuffer desc = new StringBuffer();
                    desc.append('(');
                    for (String arg : args) {
                        if (arg.isEmpty()) break;
                        desc.append(MappingFile.toDesc(arg));
                    }
                    desc.append(')').append(_ret);
                    if (("<init>".equals(name) || "<clinit>".equals(name)) && name.equals(obf)) continue;
                    ret.getClass(cls).addMethod(name, desc.toString(), obf, start, end);
                    continue;
                }
                String[] pts4 = line4.trim().split(" ");
                ret.getClass(cls).addField(pts4[1], pts4[3], MappingFile.toDesc(pts4[0]));
            }
        } else {
            List split = lines.stream().map(l -> l.split(" ")).collect(Collectors.toList());
            split.stream().filter(p -> ((String[])p).length == 2 && p[0].charAt(0) != '\t').forEach(pts -> {
                if (pts[0].endsWith("/")) {
                    ret.addPackage(pts[0].substring(0, pts[0].length() - 1), pts[1].substring(0, pts[1].length() - 1));
                } else {
                    ret.addClass(pts[0], pts[1]);
                }
            });
            Object cls = null;
            for (Object[] pts5 : split) {
                if (pts5[0].charAt(0) == '\t') {
                    if (cls == null) {
                        throw new IOException("Invalid TSRG line, missing class: " + SPACE.join(pts5));
                    }
                    pts5[0] = pts5[0].substring(1);
                    if (pts5.length == 2) {
                        ret.getClass((String)cls).addField((String)pts5[0], (String)pts5[1]);
                        continue;
                    }
                    if (pts5.length == 3) {
                        ret.getClass((String)cls).addMethod((String)pts5[0], (String)pts5[1], (String)pts5[2]);
                        continue;
                    }
                    throw new IOException("Invalid TSRG line, to many parts: " + SPACE.join(pts5));
                }
                if (pts5.length == 2) {
                    if (pts5[0].endsWith("/")) continue;
                    cls = pts5[0];
                    continue;
                }
                if (pts5.length == 3) {
                    ret.getClass((String)pts5[0]).addField((String)pts5[1], (String)pts5[2]);
                    continue;
                }
                if (pts5.length == 4) {
                    ret.getClass((String)pts5[0]).addMethod((String)pts5[1], (String)pts5[2], (String)pts5[3]);
                    continue;
                }
                throw new IOException("Invalid CSRG line, to many parts: " + SPACE.join(pts5));
            }
        }
        return ret;
    }

    private static String[] rsplit(String str, char chr, int count) {
        int idx;
        ArrayList<String> pts = new ArrayList<String>();
        while ((idx = str.lastIndexOf(chr)) != -1 && count > 0) {
            pts.add(str.substring(idx + 1));
            str = str.substring(0, idx);
            --count;
        }
        pts.add(str);
        Collections.reverse(pts);
        return pts.toArray(new String[pts.size()]);
    }

    public void addPackage(String original, String mapped) {
        if (original.equals(".")) {
            original = "";
        }
        if (mapped.equals(".")) {
            mapped = "";
        }
        Package old = this.packages.put(original, new Package(original, mapped));
    }

    public void addClass(String original, String mapped) {
        Cls old = this.classes.put(original, new Cls(original, mapped));
    }

    public Cls getClass(String original) {
        return this.classes.computeIfAbsent(original, k -> new Cls(original, original));
    }

    public Collection<Package> getPackages() {
        return this.packages.values();
    }

    public Collection<Cls> getClasses() {
        return this.classes.values();
    }

    public void write(Format format, File file) throws IOException {
        this.write(format, file, false);
    }

    public void write(Format format, File file, boolean reversed) throws IOException {
        List<String> lines = this.write(format, reversed);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            for (String line : lines) {
                out.write(line.getBytes());
                out.write(10);
            }
        }
    }

    public List<String> write(Format format) {
        return this.write(format, false);
    }

    public List<String> write(Format format, boolean reversed) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String name : MappingFile.sort(this.packages, reversed)) {
            ret.add(this.packages.get(name).write(format, reversed));
        }
        for (String name : MappingFile.sort(this.classes, reversed)) {
            Cls cls = this.classes.get(name);
            ret.add(cls.write(format, reversed));
            for (String fld : MappingFile.sort(cls.fields, reversed)) {
                ret.add(((Cls.Field)cls.fields.get(fld)).write(format, reversed));
            }
            for (String mtd : MappingFile.sortMethods(cls.methods, reversed)) {
                ret.add(((Cls.Method)cls.methods.get(mtd)).write(format, reversed));
            }
        }
        return ret;
    }

    public String remapClass(String cls) {
        String ret = this.cache.get(cls);
        if (ret == null) {
            int idx;
            Cls _cls = this.classes.get(cls);
            ret = _cls == null ? ((idx = cls.lastIndexOf(36)) != -1 ? this.remapClass(cls.substring(0, idx)) + '$' + cls.substring(idx + 1) : cls) : _cls.getMapped();
            this.cache.put(cls, ret);
        }
        return ret;
    }

    public String remapDesc(String desc) {
        Matcher matcher = DESC.matcher(desc);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + this.remapClass(matcher.group("cls")) + ";"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    private static List<String> sort(Map<String, ? extends Node> map, boolean reversed) {
        if (!reversed) {
            return map.keySet().stream().sorted().collect(Collectors.toList());
        }
        return map.values().stream().sorted((n1, n2) -> n1.getMapped().compareTo(n2.getMapped())).map(Node::getOriginal).collect(Collectors.toList());
    }

    private static List<String> sortMethods(Map<String, Cls.Method> map, boolean reversed) {
        if (!reversed) {
            return map.keySet().stream().sorted().collect(Collectors.toList());
        }
        return map.values().stream().sorted((n1, n2) -> (n1.getMapped() + n1.getMappedDescriptor()).compareTo(n2.getMapped() + n2.getMappedDescriptor())).map(m -> m.getOriginal() + m.getDescriptor()).collect(Collectors.toList());
    }

    private static String toDesc(String type) {
        if (type.endsWith("[]")) {
            return "[" + MappingFile.toDesc(type.substring(0, type.length() - 2));
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("void")) {
            return "V";
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.contains("/")) {
            return "L" + type + ";";
        }
        throw new RuntimeException("Invalid toDesc input: " + type);
    }

    public class Cls
    extends Node {
        private Map<String, Field> fields;
        private Map<String, Method> methods;

        private Cls(String original, String mapped) {
            super(original, mapped);
            this.fields = new HashMap<String, Field>();
            this.methods = new HashMap<String, Method>();
        }

        public void addField(String original, String mapped) {
            Field old = this.fields.put(original, new Field(original, mapped));
        }

        public void addField(String original, String mapped, String desc) {
            Field old = this.fields.put(original, new Field(original, mapped, desc));
        }

        public void addMethod(String original, String desc, String mapped) {
            Method old = this.methods.put(original + desc, new Method(original, desc, mapped));
        }

        public void addMethod(String original, String desc, String mapped, int start, int end) {
            Method old = this.methods.put(original + desc, new Method(original, desc, mapped, start, end));
        }

        public Collection<Field> getFields() {
            return this.fields.values();
        }

        public Collection<Method> getMethods() {
            return this.methods.values();
        }

        public String remap(String field) {
            Field fld = this.fields.get(field);
            return fld == null ? field : fld.getMapped();
        }

        public String remap(String method, String desc) {
            Method mtd = this.methods.get(method + desc);
            return mtd == null ? method : mtd.getMapped();
        }

        @Override
        public String write(Format format, boolean reversed) {
            if (reversed) {
                switch (format) {
                    case SRG: {
                        return "CL: " + this.getMapped() + ' ' + this.getOriginal();
                    }
                    case CSRG: 
                    case TSRG: {
                        return this.getMapped() + ' ' + this.getOriginal();
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }
            switch (format) {
                case SRG: {
                    return "CL: " + this.getOriginal() + ' ' + this.getMapped();
                }
                case CSRG: 
                case TSRG: {
                    return this.getOriginal() + ' ' + this.getMapped();
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        public class Method
        extends Node {
            private String desc;
            private int start;
            private int end;

            private Method(String original, String desc, String mapped) {
                super(original, mapped);
                this.desc = desc;
            }

            private Method(String original, String desc, String mapped, int start, int end) {
                super(original, mapped);
                this.desc = desc;
                this.start = start;
                this.end = end;
            }

            public String getDescriptor() {
                return this.desc;
            }

            public String getMappedDescriptor() {
                return MappingFile.this.remapDesc(this.desc);
            }

            @Override
            public String write(Format format, boolean reversed) {
                if (reversed) {
                    String mapedDesc = this.getMappedDescriptor();
                    switch (format) {
                        case SRG: {
                            return "MD: " + Cls.this.getMapped() + '/' + this.getMapped() + ' ' + mapedDesc + ' ' + Cls.this.getOriginal() + '/' + this.getOriginal() + ' ' + this.desc;
                        }
                        case CSRG: {
                            return Cls.this.getMapped() + ' ' + this.getMapped() + ' ' + mapedDesc + ' ' + this.getOriginal();
                        }
                        case TSRG: {
                            return '\t' + this.getMapped() + ' ' + mapedDesc + ' ' + this.getOriginal();
                        }
                    }
                    throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
                }
                switch (format) {
                    case SRG: {
                        return "MD: " + Cls.this.getOriginal() + '/' + this.getOriginal() + ' ' + this.desc + ' ' + Cls.this.getMapped() + '/' + this.getMapped() + ' ' + MappingFile.this.remapDesc(this.desc);
                    }
                    case CSRG: {
                        return Cls.this.getOriginal() + ' ' + this.getOriginal() + ' ' + this.desc + ' ' + this.getMapped();
                    }
                    case TSRG: {
                        return '\t' + this.getOriginal() + ' ' + this.desc + ' ' + this.getMapped();
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }
        }

        public class Field
        extends Node {
            private String desc;

            private Field(String original, String mapped) {
                this(original, mapped, (String)null);
            }

            private Field(String original, String mapped, String desc) {
                super(original, mapped);
                this.desc = desc;
            }

            @Override
            public String write(Format format, boolean reversed) {
                if (reversed) {
                    switch (format) {
                        case SRG: {
                            return "FD: " + Cls.this.getMapped() + '/' + this.getMapped() + ' ' + Cls.this.getOriginal() + '/' + this.getOriginal();
                        }
                        case CSRG: {
                            return Cls.this.getMapped() + ' ' + this.getMapped() + ' ' + this.getOriginal();
                        }
                        case TSRG: {
                            return '\t' + this.getMapped() + ' ' + this.getOriginal();
                        }
                    }
                    throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
                }
                switch (format) {
                    case SRG: {
                        return "FD: " + Cls.this.getOriginal() + '/' + this.getOriginal() + ' ' + Cls.this.getMapped() + '/' + this.getMapped();
                    }
                    case CSRG: {
                        return Cls.this.getOriginal() + ' ' + this.getOriginal() + ' ' + this.getMapped();
                    }
                    case TSRG: {
                        return '\t' + this.getOriginal() + ' ' + this.getMapped();
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }
        }
    }

    public class Package
    extends Node {
        private Package(String original, String mapped) {
            super(original, mapped);
        }

        @Override
        public String write(Format format, boolean reversed) {
            String smap;
            String sorig = this.getOriginal().isEmpty() ? "." : this.getOriginal();
            String string = smap = this.getMapped().isEmpty() ? "." : this.getMapped();
            if (reversed) {
                switch (format) {
                    case SRG: {
                        return "PK: " + smap + ' ' + sorig;
                    }
                    case CSRG: 
                    case TSRG: {
                        return this.getMapped() + ' ' + this.getOriginal();
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }
            switch (format) {
                case SRG: {
                    return "PK: " + sorig + ' ' + smap;
                }
                case CSRG: 
                case TSRG: {
                    return this.getOriginal() + "/ " + this.getMapped() + '/';
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }
    }

    public abstract class Node {
        protected String original;
        protected String mapped;

        protected Node(String original, String mapped) {
            this.original = original;
            this.mapped = mapped;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getMapped() {
            return this.mapped;
        }

        public abstract String write(Format var1, boolean var2);
    }

    public static enum Format {
        SRG,
        CSRG,
        TSRG,
        PG;


        public static Format get(String value) {
            try {
                return Format.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

