/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.DownloadMCMeta;
import net.minecraftforge.gradle.common.task.DownloadMavenArtifact;
import net.minecraftforge.gradle.common.task.ExtractMCPData;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.userdev.DependencyManagementExtension;
import net.minecraftforge.gradle.userdev.MinecraftUserRepo;
import net.minecraftforge.gradle.userdev.UserDevExtension;
import net.minecraftforge.gradle.userdev.tasks.GenerateSRG;
import net.minecraftforge.gradle.userdev.tasks.RenameJarInPlace;
import net.minecraftforge.gradle.userdev.util.DeobfuscatingRepo;
import net.minecraftforge.gradle.userdev.util.Deobfuscator;
import net.minecraftforge.gradle.userdev.util.DependencyRemapper;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public class UserDevPlugin
implements Plugin<Project> {
    private static String MINECRAFT = "minecraft";
    private static String DEOBF = "deobf";
    public static String OBF = "__obfuscated";

    public void apply(final @Nonnull Project project) {
        Utils.checkJavaVersion();
        Logger logger = project.getLogger();
        UserDevExtension extension = (UserDevExtension)((Object)project.getExtensions().create("minecraft", UserDevExtension.class, new Object[]{project}));
        if (project.getPluginManager().findPlugin("java") == null) {
            project.getPluginManager().apply("java");
        }
        File nativesFolder = project.file((Object)"build/natives/");
        NamedDomainObjectContainer reobf = project.container(RenameJarInPlace.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<RenameJarInPlace>(){

            public RenameJarInPlace create(String jarName) {
                String name = Character.toUpperCase(jarName.charAt(0)) + jarName.substring(1);
                JavaPluginConvention java = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
                RenameJarInPlace task = (RenameJarInPlace)((Object)project.getTasks().maybeCreate("reobf" + name, RenameJarInPlace.class));
                task.setClasspath(((SourceSet)java.getSourceSets().getByName("main")).getCompileClasspath());
                project.getTasks().getByName("assemble").dependsOn(new Object[]{task});
                project.afterEvaluate(p -> {
                    Task jar = project.getTasks().getByName(jarName);
                    if (!(jar instanceof Jar)) {
                        throw new IllegalStateException(jarName + "  is not a jar task. Can only reobf jars!");
                    }
                    task.setInput(((Jar)jar).getArchivePath());
                    task.dependsOn(new Object[]{jar});
                });
                return task;
            }
        });
        project.getExtensions().add("reobf", (Object)reobf);
        Configuration minecraft = (Configuration)project.getConfigurations().maybeCreate(MINECRAFT);
        Configuration compile = (Configuration)project.getConfigurations().maybeCreate("compile");
        compile.extendsFrom(new Configuration[]{minecraft});
        Configuration internalObfConfiguration = (Configuration)project.getConfigurations().maybeCreate(OBF);
        internalObfConfiguration.setDescription("Generated scope for obfuscated dependencies");
        Deobfuscator deobfuscator = new Deobfuscator(project, Utils.getCache(project, "deobf_dependencies"));
        DependencyRemapper remapper = new DependencyRemapper(project, deobfuscator);
        project.getExtensions().create("fg", DependencyManagementExtension.class, new Object[]{project, remapper});
        Configuration deobfConfiguration = (Configuration)project.getConfigurations().maybeCreate(DEOBF);
        project.afterEvaluate(p -> {
            DependencySet legacyDeps = deobfConfiguration.getDependencies();
            if (!legacyDeps.isEmpty()) {
                logger.warn("deobf dependency configuration is deprecated. Please use deobfuscated dependencies in standard configurations");
                logger.warn("For example, `api fg.deobf(\"your:dependency\")`. More about available configurations: https://docs.gradle.org/current/userguide/java_library_plugin.html#sec:java_library_configurations_graph");
            }
            legacyDeps.forEach(d -> p.getDependencies().add("compile", (Object)remapper.remap((Dependency)d)));
        });
        TaskProvider downloadMcpConfig = project.getTasks().register("downloadMcpConfig", DownloadMavenArtifact.class);
        TaskProvider extractSrg = project.getTasks().register("extractSrg", ExtractMCPData.class);
        TaskProvider createMcpToSrg = project.getTasks().register("createMcpToSrg", GenerateSRG.class);
        TaskProvider downloadMCMeta = project.getTasks().register("downloadMCMeta", DownloadMCMeta.class);
        TaskProvider extractNatives = project.getTasks().register("extractNatives", ExtractNatives.class);
        TaskProvider downloadAssets = project.getTasks().register("downloadAssets", DownloadAssets.class);
        extractSrg.configure(task -> {
            task.dependsOn(new Object[]{downloadMcpConfig});
            task.setConfig(() -> ((DownloadMavenArtifact)((Object)((Object)((Object)downloadMcpConfig.get())))).getOutput());
        });
        createMcpToSrg.configure(task -> {
            task.setReverse(true);
            task.dependsOn(new Object[]{extractSrg});
            task.setSrg(((ExtractMCPData)((Object)((Object)extractSrg.get()))).getOutput());
            task.setMappings(extension.getMappings());
        });
        extractNatives.configure(task -> {
            task.dependsOn(new Object[]{downloadMCMeta.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput());
            task.setOutput(nativesFolder);
        });
        downloadAssets.configure(task -> {
            task.dependsOn(new Object[]{downloadMCMeta.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput());
        });
        project.afterEvaluate(p -> {
            MinecraftUserRepo mcrepo = null;
            DeobfuscatingRepo deobfrepo = null;
            DependencySet deps = minecraft.getDependencies();
            for (Dependency dep : new ArrayList(deps)) {
                if (!(dep instanceof ExternalModuleDependency)) {
                    throw new IllegalArgumentException("minecraft dependency must be a maven dependency.");
                }
                if (mcrepo != null) {
                    throw new IllegalArgumentException("Only allows one minecraft dependency.");
                }
                deps.remove((Object)dep);
                mcrepo = new MinecraftUserRepo((Project)p, dep.getGroup(), dep.getName(), dep.getVersion(), extension.getAccessTransformers(), extension.getMappings());
                String newDep = mcrepo.getDependencyString();
                p.getLogger().lifecycle("New Dep: " + newDep);
                ExternalModuleDependency ext = (ExternalModuleDependency)p.getDependencies().create((Object)newDep);
                minecraft.resolutionStrategy(strat -> strat.cacheChangingModulesFor(10, TimeUnit.SECONDS));
                minecraft.getDependencies().add((Object)ext);
            }
            if (!internalObfConfiguration.getDependencies().isEmpty() && (deobfrepo = new DeobfuscatingRepo(project, internalObfConfiguration, deobfuscator)).getResolvedOrigin() == null) {
                project.getLogger().error("DeobfRepo attempted to resolve an origin repo early but failed, this may cause issues with some IDEs");
            }
            remapper.attachMappings(extension.getMappings());
            new BaseRepo.Builder().add(mcrepo).add(deobfrepo).add(MCPRepo.create(project)).add(MinecraftRepo.create(project)).attach(project);
            project.getRepositories().maven(e -> e.setUrl((Object)"https://files.minecraftforge.net/maven/"));
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://libraries.minecraft.net/");
                e.metadataSources(src -> src.artifact());
            });
            project.getRepositories().mavenCentral();
            if (mcrepo == null) {
                throw new IllegalStateException("Missing 'minecraft' dependency entry.");
            }
            mcrepo.validate(minecraft, extension.getRuns().getAsMap(), (ExtractNatives)((Object)((Object)extractNatives.get())), (DownloadAssets)((Object)((Object)downloadAssets.get())));
            String mcVer = (String)project.getExtensions().getExtraProperties().get("MC_VERSION");
            String mcpVer = (String)project.getExtensions().getExtraProperties().get("MCP_VERSION");
            ((DownloadMavenArtifact)((Object)((Object)downloadMcpConfig.get()))).setArtifact("de.oceanlabs.mcp:mcp_config:" + mcpVer + "@zip");
            ((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).setMCVersion(mcVer);
            RenameJarInPlace reobfJar = (RenameJarInPlace)((Object)((Object)reobf.create("jar")));
            reobfJar.dependsOn(new Object[]{createMcpToSrg});
            reobfJar.setMappings(((GenerateSRG)((Object)((Object)createMcpToSrg.get()))).getOutput());
            String assetIndex = mcVer;
            try {
                if (!((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput().exists()) {
                    ((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).downloadMCMeta();
                }
                VersionJson json = Utils.loadJson(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput(), VersionJson.class);
                assetIndex = json.assetIndex.id;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            String finalAssetIndex = assetIndex;
            extension.getRuns().forEach(runConfig -> runConfig.token("asset_index", finalAssetIndex));
            extension.createRunConfigTasks((TaskProvider<ExtractNatives>)extractNatives, (TaskProvider<DownloadAssets>)downloadAssets);
        });
    }
}

