/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;

public class TaskExtractRangeMap
extends JarExec {
    private Set<File> sources;
    private Set<FileCollection> dependencies = new HashSet<FileCollection>();
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.txt"));
    private String source_compatibility = "1.8";
    private boolean batch = true;

    public TaskExtractRangeMap() {
        this.tool = "net.minecraftforge:Srg2Source:5.+:fatjar";
        this.args = new String[]{"--extract", "--source-compatibility", "{compat}", "--output", "{output}", "--lib", "{library}", "--input", "{input}", "--batch", "{batched}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{compat}", this.getSourceCompatibility());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        replace.put("{batched}", this.getBatch() ? "true" : "false");
        ArrayList<String> _args = new ArrayList<String>();
        for (String arg : this.getArgs()) {
            String prefix;
            if ("{library}".equals(arg)) {
                prefix = (String)_args.get(_args.size() - 1);
                _args.remove(_args.size() - 1);
                this.getDependencies().forEach(fc -> fc.getFiles().forEach(f -> {
                    _args.add(prefix);
                    _args.add(f.getAbsolutePath());
                }));
                continue;
            }
            if ("{input}".equals(arg)) {
                prefix = (String)_args.get(_args.size() - 1);
                _args.remove(_args.size() - 1);
                this.getSources().forEach(f -> {
                    _args.add(prefix);
                    _args.add(f.getAbsolutePath());
                });
                continue;
            }
            _args.add(replace.getOrDefault(arg, arg));
        }
        return _args;
    }

    @InputFiles
    public Set<File> getSources() {
        return this.sources;
    }

    public void setSources(Set<File> value) {
        this.sources = value;
    }

    public void addSources(Set<File> values) {
        if (this.sources == null) {
            this.sources = new HashSet<File>();
        }
        this.sources.addAll(values);
    }

    public void sources(Collection<File> values) {
        if (this.sources == null) {
            this.sources = new HashSet<File>();
        }
        this.sources.addAll(values);
    }

    public void sources(File ... values) {
        if (this.sources == null) {
            this.sources = new HashSet<File>();
        }
        for (File value : values) {
            this.sources.add(value);
        }
    }

    @InputFiles
    public Set<FileCollection> getDependencies() {
        return this.dependencies;
    }

    public void addDependencies(FileCollection values) {
        this.dependencies.add(values);
    }

    public void addDependencies(File ... values) {
        for (File dep : values) {
            this.dependencies.add((FileCollection)this.getProject().files(new Object[]{dep}));
        }
    }

    @Input
    public String getSourceCompatibility() {
        return this.source_compatibility;
    }

    public void setSourceCompatibility(String value) {
        this.source_compatibility = value;
    }

    @Input
    public boolean getBatch() {
        return this.batch;
    }

    public void setBatch(boolean value) {
        this.batch = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

