/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.apache.commons.io.IOUtils;

public class StripJarFunction
implements MCPFunction {
    private String mappings;
    private Set<String> filter;

    @Override
    public void loadData(Map<String, String> data) {
        this.mappings = data.get("mappings");
    }

    @Override
    public void initialize(MCPEnvironment environment, ZipFile zip) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(zip.getInputStream(zip.getEntry(this.mappings))));
        this.filter = br.lines().filter(l -> !l.startsWith("\t")).map(s -> s.split(" ")[0] + ".class").collect(Collectors.toSet());
        br.close();
    }

    @Override
    public File execute(MCPEnvironment environment) throws Exception {
        File input = (File)environment.getArguments().get("input");
        File output = environment.getFile("output.jar");
        boolean whitelist = ((String)environment.getArguments().getOrDefault("mode", "whitelist")).equalsIgnoreCase("whitelist");
        File hashFile = environment.getFile("lastinput.sha1");
        HashStore hashStore = new HashStore(environment.project).load(hashFile);
        if (hashStore.isSame(input) && output.exists()) {
            return output;
        }
        Utils.createEmpty(output);
        this.strip(input, output, whitelist);
        hashStore.save(hashFile);
        return output;
    }

    private void strip(File input, File output, boolean whitelist) throws IOException {
        JarEntry entry;
        JarInputStream is = new JarInputStream(new FileInputStream(input));
        JarOutputStream os = new JarOutputStream(new FileOutputStream(output));
        while ((entry = is.getNextJarEntry()) != null) {
            if (!this.isEntryValid(entry, whitelist)) continue;
            os.putNextEntry(entry);
            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
            os.closeEntry();
        }
        os.close();
        is.close();
    }

    private boolean isEntryValid(JarEntry entry, boolean whitelist) {
        return !entry.isDirectory() && this.filter.contains(entry.getName()) == whitelist;
    }
}

