/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.apache.commons.io.IOUtils;

public class InjectFunction
implements MCPFunction {
    private String inject;
    private String template;
    private Map<String, byte[]> added;

    @Override
    public void loadData(Map<String, String> data) {
        this.inject = data.get("inject");
    }

    @Override
    public void initialize(MCPEnvironment environment, ZipFile zip) throws IOException {
        this.added = zip.stream().filter(e -> !e.isDirectory() && e.getName().startsWith(this.inject)).collect(Collectors.toMap(e -> e.getName().substring(this.inject.length()), e -> {
            try {
                return IOUtils.toByteArray((InputStream)zip.getInputStream((ZipEntry)e));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }));
        if (this.added.containsKey("package-info-template.java")) {
            this.template = new String(this.added.get("package-info-template.java"), StandardCharsets.UTF_8);
            this.added.remove("package-info-template.java");
        }
    }

    @Override
    public File execute(MCPEnvironment environment) throws Exception {
        File input = (File)environment.getArguments().get("input");
        File output = environment.getFile("output.jar");
        File hashFile = environment.getFile("lastinput.sha1");
        HashStore hashStore = new HashStore(environment.project).load(hashFile);
        if (hashStore.isSame(input) && output.exists()) {
            return output;
        }
        if (output.exists()) {
            output.delete();
        }
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        output.createNewFile();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(input));
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(output));){
            ZipEntry entry;
            HashSet<String> visited = new HashSet<String>();
            while ((entry = zis.getNextEntry()) != null) {
                String pkg;
                zos.putNextEntry(entry);
                IOUtils.copyLarge((InputStream)zis, (OutputStream)zos);
                zos.closeEntry();
                if (this.template == null || !visited.add(pkg = entry.isDirectory() && !entry.getName().endsWith("/") ? entry.getName() : (entry.getName().indexOf(47) == -1 ? "" : entry.getName().substring(0, entry.getName().lastIndexOf(47)))) || !pkg.startsWith("net/minecraft/")) continue;
                zos.putNextEntry(Utils.getStableEntry(pkg + "/package-info.java"));
                zos.write(this.template.replace("{PACKAGE}", pkg.replaceAll("/", ".")).getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
            }
            for (Map.Entry<String, byte[]> add : this.added.entrySet()) {
                boolean filter;
                boolean bl = filter = "server".equals(environment.side) ? add.getKey().contains("/client/") : add.getKey().contains("/server/");
                if (filter) continue;
                ZipEntry info = new ZipEntry(add.getKey());
                info.setTime(0L);
                zos.putNextEntry(info);
                zos.write(add.getValue());
                zos.closeEntry();
            }
        }
        hashStore.save(hashFile);
        return output;
    }

    @Override
    public void cleanup(MCPEnvironment environment) {
        if (this.added != null) {
            this.added.clear();
        }
    }
}

