/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.Utils;

public class VersionJson {
    public Arguments arguments;
    public AssetIndex assetIndex;
    public String assets;
    public Map<String, Download> downloads;
    public Library[] libraries;
    private List<LibraryDownload> _natives = null;

    public List<LibraryDownload> getNatives() {
        if (this._natives == null) {
            this._natives = new ArrayList<LibraryDownload>();
            OS os = OS.getCurrent();
            for (Library lib : this.libraries) {
                LibraryDownload l;
                if (lib.natives == null || lib.downloads.classifiers == null || !lib.natives.containsKey(os.getName()) || (l = lib.downloads.classifiers.get(lib.natives.get(os.getName()))) == null) continue;
                this._natives.add(l);
            }
        }
        return this._natives;
    }

    public List<String> getPlatformJvmArgs() {
        return Stream.of(this.arguments.jvm).filter(arg -> arg.rules != null && arg.isAllowed()).flatMap(arg -> arg.value.stream()).map(s -> {
            if (s.indexOf(32) != -1) {
                return "\"" + s + "\"";
            }
            return s;
        }).collect(Collectors.toList());
    }

    public static enum OS {
        WINDOWS("windows", "win"),
        LINUX("linux", "linux", "unix"),
        OSX("osx", "mac"),
        UNKNOWN("unknown", new String[0]);

        private final String name;
        private final String[] keys;

        private OS(String name, String ... keys) {
            this.name = name;
            this.keys = keys;
        }

        public String getName() {
            return this.name;
        }

        public static OS getCurrent() {
            String prop = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            for (OS os : OS.values()) {
                for (String key : os.keys) {
                    if (!prop.contains(key)) continue;
                    return os;
                }
            }
            return UNKNOWN;
        }
    }

    public static class Library
    extends RuledObject {
        public String name;
        public Map<String, String> natives;
        public Downloads downloads;
        private Artifact _artifact;

        public Artifact getArtifact() {
            if (this._artifact == null) {
                this._artifact = Artifact.from(this.name);
            }
            return this._artifact;
        }
    }

    public static class Downloads {
        public Map<String, LibraryDownload> classifiers;
        public LibraryDownload artifact;
    }

    public static class LibraryDownload
    extends Download {
        public String path;
    }

    public static class Download {
        public String sha1;
        public int size;
        public URL url;
    }

    public static class AssetIndex
    extends Download {
        public String id;
        public int totalSize;
    }

    public static class OsCondition {
        public String name;
        public String version;
        public String arch;

        public boolean nameMatches() {
            return this.name == null || OS.getCurrent().getName().equals(this.name);
        }

        public boolean versionMatches() {
            return this.version == null || Pattern.compile(this.version).matcher(System.getProperty("os.version")).find();
        }

        public boolean archMatches() {
            return this.arch == null || Pattern.compile(this.arch).matcher(System.getProperty("os.arch")).find();
        }

        public boolean platformMatches() {
            return this.nameMatches() && this.versionMatches() && this.archMatches();
        }
    }

    public static class Rule {
        public String action;
        public OsCondition os;

        public boolean allowsAction() {
            return (this.os == null || this.os.platformMatches()) == this.action.equals("allow");
        }
    }

    public static class RuledObject {
        public Rule[] rules;

        public boolean isAllowed() {
            if (this.rules != null) {
                for (Rule rule : this.rules) {
                    if (rule.allowsAction()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class Argument
    extends RuledObject {
        public List<String> value;

        public Argument(Rule[] rules, List<String> value) {
            this.rules = rules;
            this.value = value;
        }

        public static class Deserializer
        implements JsonDeserializer<Argument> {
            public Argument deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive()) {
                    return new Argument(null, Collections.singletonList(json.getAsString()));
                }
                JsonObject obj = json.getAsJsonObject();
                if (!obj.has("rules") || !obj.has("value")) {
                    throw new JsonParseException("Error parsing arguments in version json. File is corrupt or its format has changed.");
                }
                JsonElement val = obj.get("value");
                Rule[] rules = (Rule[])Utils.GSON.fromJson(obj.get("rules"), Rule[].class);
                List value = val.isJsonPrimitive() ? Collections.singletonList(val.getAsString()) : (List)Utils.GSON.fromJson(val, List.class);
                return new Argument(rules, value);
            }
        }
    }

    public static class Arguments {
        public Argument[] game;
        public Argument[] jvm;
    }
}

