/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.util.MapEntry;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.ModConfig;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public class RunConfig
extends GroovyObjectSupport
implements Serializable {
    public static final String RUNS_GROUP = "fg_runs";
    private static final String MCP_CLIENT_MAIN = "mcp.client.Start";
    private static final String MC_CLIENT_MAIN = "net.minecraft.client.main.Main";
    private static final long serialVersionUID = 1L;
    private final transient Project project;
    private transient NamedDomainObjectContainer<ModConfig> mods;
    private final String name;
    private boolean singleInstance = false;
    private String taskName;
    private String main;
    private String ideaModule;
    private String workDir;
    private List<SourceSet> sources;
    private List<RunConfig> parents;
    private List<RunConfig> children;
    private List<String> args;
    private List<String> jvmArgs;
    private Map<String, String> env;
    private Map<String, String> props;
    private Map<String, String> tokens;

    public RunConfig(Project project, String name) {
        this.project = project;
        this.name = name;
        this.mods = project.container(ModConfig.class, modName -> new ModConfig(project, modName));
    }

    public final String getName() {
        return this.name;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void taskName(String taskName) {
        this.setTaskName(taskName);
    }

    public final String getTaskName() {
        if (this.taskName == null) {
            this.taskName = this.getName().replaceAll("[^a-zA-Z0-9\\-_]", "");
            if (!this.taskName.startsWith("run")) {
                this.taskName = "run" + Utils.capitalize(this.taskName);
            }
        }
        return this.taskName;
    }

    public final String getUniqueFileName() {
        return this.project.getPath().length() > 1 ? String.join((CharSequence)"_", String.join((CharSequence)"_", this.project.getPath().substring(1).split(":")), this.getTaskName()) : this.getTaskName();
    }

    public final String getUniqueName() {
        return this.getUniqueFileName().replaceAll("_", " ");
    }

    public void environment(Map<String, Object> map) {
        this.setEnvironment(map);
    }

    public void setEnvironment(Map<String, Object> map) {
        map.forEach((k, v) -> this.getEnvironment().put((String)k, v instanceof File ? ((File)v).getAbsolutePath() : (String)v));
    }

    public void environment(String key, String value) {
        this.getEnvironment().put(key, value);
    }

    public void environment(String key, File value) {
        this.getEnvironment().put(key, value.getAbsolutePath());
    }

    public Map<String, String> getEnvironment() {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        return this.env;
    }

    public void main(String value) {
        this.setMain(value);
    }

    public void setMain(String value) {
        this.main = value;
    }

    public String getMain() {
        return this.main;
    }

    public void args(List<Object> values) {
        this.setArgs(values);
    }

    public void args(Object ... values) {
        this.args(Arrays.asList(values));
    }

    public void arg(Object value) {
        this.args(value);
    }

    public void setArgs(List<Object> values) {
        values.forEach(value -> this.getArgs().add(value instanceof File ? ((File)value).getAbsolutePath() : (String)value));
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        return this.args;
    }

    public void jvmArgs(List<String> values) {
        this.setJvmArgs(values);
    }

    public void jvmArgs(String ... values) {
        this.jvmArgs(Arrays.asList(values));
    }

    public void jvmArg(String value) {
        this.jvmArgs(value);
    }

    public void setJvmArgs(List<String> values) {
        this.getJvmArgs().addAll(values);
    }

    public List<String> getJvmArgs() {
        if (this.jvmArgs == null) {
            this.jvmArgs = new ArrayList<String>();
        }
        return this.jvmArgs;
    }

    public void singleInstance(boolean value) {
        this.setSingleInstance(value);
    }

    public void setSingleInstance(boolean singleInstance) {
        this.singleInstance = singleInstance;
    }

    public boolean isSingleInstance() {
        return this.singleInstance;
    }

    public void properties(Map<String, Object> map) {
        this.setProperties(map);
    }

    public void setProperties(Map<String, Object> map) {
        map.forEach((k, v) -> this.getProperties().put((String)k, v instanceof File ? ((File)v).getAbsolutePath() : (String)v));
    }

    public void property(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void property(String key, File value) {
        this.getProperties().put(key, value.getAbsolutePath());
    }

    public Map<String, String> getProperties() {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return this.props;
    }

    public void ideaModule(String value) {
        this.setIdeaModule(value);
    }

    public void setIdeaModule(String value) {
        this.ideaModule = value;
    }

    public final String getIdeaModule() {
        if (this.ideaModule == null) {
            this.ideaModule = this.project.getName() + "_main";
        }
        return this.ideaModule;
    }

    public void workingDirectory(String value) {
        this.setWorkingDirectory(value);
    }

    public void workingDirectory(File value) {
        this.setWorkingDirectory(value.getAbsolutePath());
    }

    public void setWorkingDirectory(String value) {
        this.workDir = value;
    }

    public String getWorkingDirectory() {
        if (this.workDir == null) {
            this.workDir = this.project.file((Object)"run").getAbsolutePath();
        }
        return this.workDir;
    }

    public NamedDomainObjectContainer<ModConfig> mods(Closure closure) {
        return this.mods.configure(closure);
    }

    public NamedDomainObjectContainer<ModConfig> getMods() {
        return this.mods;
    }

    public void setSources(List<SourceSet> sources) {
        this.sources = sources;
    }

    public void sources(List<SourceSet> sources) {
        this.getSources().addAll(sources);
    }

    public void sources(SourceSet ... sources) {
        this.sources(Arrays.asList(sources));
    }

    public void source(SourceSet source) {
        this.sources(source);
    }

    public List<SourceSet> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceSet>();
        }
        return this.sources;
    }

    private Stream<RunConfig> entriesToRuns(MapEntry ... entries) {
        return Stream.of(entries).map(entry -> {
            Project project = entry.getKey() == null ? this.project : this.project.project(entry.getKey().toString());
            MinecraftExtension minecraft = (MinecraftExtension)((Object)((Object)project.getExtensions().findByType(MinecraftExtension.class)));
            return minecraft == null ? null : (RunConfig)minecraft.getRuns().maybeCreate(entry.getValue().toString());
        }).filter(Objects::nonNull);
    }

    public void setParents(List<RunConfig> parents) {
        this.parents = parents;
    }

    public void setParents(MapEntry ... parents) {
        this.setParents(this.entriesToRuns(parents).collect(Collectors.toList()));
    }

    public void setParents(Map<String, String> parents) {
        this.setParents((MapEntry[])parents.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).toArray(MapEntry[]::new));
    }

    public void parents(MapEntry ... parents) {
        this.getParents().addAll(this.entriesToRuns(parents).collect(Collectors.toList()));
    }

    public void parents(Map<String, String> parents) {
        this.parents((MapEntry[])parents.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).toArray(MapEntry[]::new));
    }

    public void parent(@Nullable String project, @Nullable String parent) {
        this.parents(new MapEntry((Object)project, (Object)parent));
    }

    public void parents(int index, MapEntry ... parents) {
        this.getParents().addAll(index, this.entriesToRuns(parents).collect(Collectors.toList()));
    }

    public void parents(int index, Map<String, String> parents) {
        this.parents(index, (MapEntry[])parents.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).toArray(MapEntry[]::new));
    }

    public void parent(int index, @Nullable String project, @Nullable String parent) {
        this.parents(index, new MapEntry((Object)project, (Object)parent));
    }

    public void parents(RunConfig ... parents) {
        this.getParents().addAll(Arrays.asList(parents));
    }

    public void parent(RunConfig parent) {
        this.parents(parent);
    }

    public void parents(int index, RunConfig ... parents) {
        this.getParents().addAll(Math.min(index, this.getParents().size()), Arrays.asList(parents));
    }

    public void parent(int index, RunConfig parent) {
        this.parents(index, parent);
    }

    public final List<RunConfig> getParents() {
        if (this.parents == null) {
            this.parents = new ArrayList<RunConfig>();
        }
        return this.parents;
    }

    public void setChildren(List<RunConfig> children) {
        this.children = children;
    }

    public void setChildren(MapEntry ... children) {
        this.setChildren(this.entriesToRuns(children).collect(Collectors.toList()));
    }

    public void setChildren(Map<String, String> children) {
        this.setChildren((MapEntry[])children.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).toArray(MapEntry[]::new));
    }

    public void children(MapEntry ... children) {
        this.getChildren().addAll(this.entriesToRuns(children).collect(Collectors.toList()));
    }

    public void children(Map<String, String> children) {
        this.children((MapEntry[])children.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).toArray(MapEntry[]::new));
    }

    public void child(@Nullable String project, @Nullable String child) {
        this.children(new MapEntry((Object)project, (Object)child));
    }

    public void children(int index, MapEntry ... children) {
        this.getChildren().addAll(index, this.entriesToRuns(children).collect(Collectors.toList()));
    }

    public void children(int index, Map<String, String> children) {
        this.children(index, (MapEntry[])children.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).toArray(MapEntry[]::new));
    }

    public void child(int index, @Nullable String project, @Nullable String child) {
        this.children(index, new MapEntry((Object)project, (Object)child));
    }

    public void children(RunConfig ... children) {
        this.getChildren().addAll(Arrays.asList(children));
    }

    public void child(RunConfig child) {
        this.children(child);
    }

    public void children(int index, RunConfig ... children) {
        this.getChildren().addAll(Math.min(index, this.getParents().size()), Arrays.asList(children));
    }

    public void child(int index, RunConfig child) {
        this.children(index, child);
    }

    public final List<RunConfig> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<RunConfig>();
        }
        return this.children;
    }

    public void merge(RunConfig other, boolean overwrite) {
        this.singleInstance = other.singleInstance;
        RunConfig first = overwrite ? other : this;
        RunConfig second = overwrite ? this : other;
        this.args = first.args == null ? second.args : first.args;
        this.main = first.main == null ? second.main : first.main;
        this.mods = first.mods == null ? second.mods : first.mods;
        this.sources = first.sources == null ? second.sources : first.sources;
        this.workDir = first.workDir == null ? second.workDir : first.workDir;
        String string = this.ideaModule = first.ideaModule == null ? second.ideaModule : first.ideaModule;
        if (other.env != null) {
            other.env.forEach(overwrite ? (key, value) -> this.getEnvironment().put((String)key, (String)value) : (key, value) -> this.getEnvironment().putIfAbsent((String)key, (String)value));
        }
        if (other.props != null) {
            other.props.forEach(overwrite ? (key, value) -> this.getProperties().put((String)key, (String)value) : (key, value) -> this.getProperties().putIfAbsent((String)key, (String)value));
        }
        if (other.mods != null) {
            other.mods.forEach(otherMod -> {
                ModConfig thisMod = (ModConfig)((Object)((Object)this.getMods().findByName(otherMod.getName())));
                if (thisMod == null) {
                    this.getMods().add((Object)otherMod);
                } else {
                    thisMod.merge((ModConfig)((Object)otherMod), false);
                }
            });
        }
    }

    public void merge(List<RunConfig> runs) {
        runs.stream().distinct().filter(run -> run != this).forEach(run -> this.merge((RunConfig)run, false));
    }

    public void mergeParents() {
        this.merge(this.getParents());
    }

    public void mergeChildren() {
        this.merge(this.getChildren());
    }

    public void setTokens(Map<String, String> tokens) {
        this.tokens = new HashMap<String, String>(tokens);
    }

    public void token(String key, String value) {
        this.getTokens().put(key, value);
    }

    public Map<String, String> getTokens() {
        if (this.tokens == null) {
            this.tokens = new HashMap<String, String>();
        }
        return this.tokens;
    }

    private void replaceTokens() {
        this.getArgs().replaceAll(value -> this.replace(this.getTokens(), (String)value));
        this.getProperties().replaceAll((key, value) -> this.replace(this.getTokens(), (String)value));
        this.getEnvironment().replaceAll((key, value) -> this.replace(this.getTokens(), (String)value));
    }

    private String replace(Map<String, String> vars, String value) {
        if (value.length() <= 2 || value.charAt(0) != '{' || value.charAt(value.length() - 1) != '}') {
            return value;
        }
        String key = value.substring(1, value.length() - 1);
        String resolved = vars.get(key);
        return resolved == null ? value : resolved;
    }

    public boolean isClient() {
        boolean isTargetClient = this.getEnvironment().getOrDefault("target", "").contains("client");
        return isTargetClient || MCP_CLIENT_MAIN.equals(this.getMain()) || MC_CLIENT_MAIN.equals(this.getMain());
    }

    public List<SourceSet> getAllSources() {
        List<Object> sources = this.getSources();
        this.getMods().stream().map(ModConfig::getSources).flatMap(Collection::stream).forEach(sources::add);
        sources = sources.stream().distinct().collect(Collectors.toList());
        if (sources.isEmpty()) {
            JavaPluginConvention main = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
            sources.add(main.getSourceSets().getByName("main"));
        }
        return sources;
    }

    public final TaskProvider<JavaExec> createRunTask(TaskProvider<Task> prepareRuns, List<String> additionalClientArgs) {
        return this.createRunTask((Task)prepareRuns.get(), additionalClientArgs);
    }

    public final TaskProvider<JavaExec> createRunTask(Task prepareRuns, List<String> additionalClientArgs) {
        if (this.getMods().isEmpty()) {
            List<SourceSet> sources = this.getAllSources();
            this.getTokens().put("source_roots", Stream.concat(sources.stream().map(source -> source.getOutput().getResourcesDir()), sources.stream().map(source -> source.getOutput().getClassesDirs().getFiles()).flatMap(Collection::stream)).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        } else {
            this.getMods().forEach(mod -> mod.configureTokens(this.getTokens()));
        }
        this.replaceTokens();
        this.getEnvironment().putIfAbsent("MOD_CLASSES", "");
        if (this.isClient()) {
            this.jvmArgs(additionalClientArgs);
        }
        TaskProvider prepareRun = this.project.getTasks().register("prepare" + Utils.capitalize(this.getTaskName()), Task.class, task -> {
            task.setGroup(RUNS_GROUP);
            task.dependsOn(new Object[]{prepareRuns, this.getAllSources().stream().map(SourceSet::getClassesTaskName).toArray()});
            File workDir = new File(this.getWorkingDirectory());
            if (!workDir.exists()) {
                workDir.mkdirs();
            }
        });
        return this.project.getTasks().register(this.getTaskName(), JavaExec.class, task -> {
            task.setGroup(RUNS_GROUP);
            task.dependsOn(new Object[]{prepareRun.get()});
            File workDir = new File(this.getWorkingDirectory());
            if (!workDir.exists()) {
                workDir.mkdirs();
            }
            task.setWorkingDir(workDir);
            task.setMain(this.getMain());
            task.args(this.getArgs());
            task.jvmArgs(this.getJvmArgs());
            task.environment(this.getEnvironment());
            task.systemProperties(this.getProperties());
            this.getAllSources().stream().map(SourceSet::getRuntimeClasspath).forEach(xva$0 -> task.classpath(new Object[]{xva$0}));
            task.doLast(t -> System.exit(0));
        });
    }

    public String toString() {
        return "RunConfig[project='" + this.project.getPath() + "', name='" + this.getName() + "']";
    }
}

