/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class IDEUtils {
    public static void createIDEGenRunsTasks(@Nonnull MinecraftExtension minecraft, @Nonnull TaskProvider<Task> prepareRuns, @Nonnull TaskProvider<Task> makeSourceDirs) {
        Project project = minecraft.getProject();
        ImmutableMap ideConfigurationGenerators = ImmutableMap.builder().put((Object)"genIntellijRuns", (Object)ImmutableTriple.of(Collections.singletonList(prepareRuns.get()), (Object)new File(project.getRootProject().getRootDir(), ".idea/runConfigurations"), IDEUtils::createIntellijRunConfigurationXML)).put((Object)"genEclipseRuns", (Object)ImmutableTriple.of((Object)ImmutableList.of((Object)prepareRuns.get(), (Object)makeSourceDirs.get()), (Object)project.getProjectDir(), IDEUtils::createEclipseRunConfigurationXML)).build();
        ideConfigurationGenerators.forEach((taskName, configurationGenerator) -> project.getTasks().register(taskName, Task.class, task -> {
            task.setGroup("fg_runs");
            task.dependsOn(new Object[]{configurationGenerator.getLeft()});
            task.doLast(t -> {
                try {
                    File runConfigurationsDir = (File)configurationGenerator.getMiddle();
                    if (!runConfigurationsDir.exists()) {
                        runConfigurationsDir.mkdirs();
                    }
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    minecraft.getRuns().forEach(runConfig -> {
                        Stream<String> propStream = runConfig.getProperties().entrySet().stream().map(kv -> String.format("-D%s=%s", kv.getKey(), kv.getValue()));
                        String props = Stream.concat(propStream, runConfig.getJvmArgs().stream()).collect(Collectors.joining(" "));
                        Map<String, Document> documents = ((RunConfigurationGenerator)configurationGenerator.getRight()).createRunConfigurationXML(project, (RunConfig)runConfig, props, docBuilder);
                        documents.forEach((fileName, document) -> {
                            DOMSource source = new DOMSource((Node)document);
                            StreamResult result = new StreamResult(new File(runConfigurationsDir, (String)fileName));
                            try {
                                transformer.transform(source, result);
                            }
                            catch (TransformerException e) {
                                e.printStackTrace();
                            }
                        });
                    });
                }
                catch (ParserConfigurationException | TransformerConfigurationException e) {
                    e.printStackTrace();
                }
            });
        }));
    }

    private static void elementOption(@Nonnull Document document, @Nonnull Element parent, @Nonnull String name, @Nonnull String value) {
        Element option = document.createElement("option");
        option.setAttribute("name", name);
        option.setAttribute("value", value);
        parent.appendChild(option);
    }

    @Nonnull
    private static Map<String, Document> createIntellijRunConfigurationXML(@Nonnull Project project, @Nonnull RunConfig runConfig, @Nonnull String props, @Nonnull DocumentBuilder documentBuilder) {
        LinkedHashMap<String, Document> documents = new LinkedHashMap<String, Document>();
        Document javaDocument = documentBuilder.newDocument();
        Element rootElement = javaDocument.createElement("component");
        Element configuration = javaDocument.createElement("configuration");
        configuration.setAttribute("default", "false");
        configuration.setAttribute("name", runConfig.getUniqueName());
        configuration.setAttribute("type", "Application");
        configuration.setAttribute("factoryName", "Application");
        configuration.setAttribute("singleton", runConfig.isSingleInstance() ? "true" : "false");
        IDEUtils.elementOption(javaDocument, configuration, "MAIN_CLASS_NAME", runConfig.getMain());
        IDEUtils.elementOption(javaDocument, configuration, "VM_PARAMETERS", props);
        IDEUtils.elementOption(javaDocument, configuration, "PROGRAM_PARAMETERS", String.join((CharSequence)" ", runConfig.getArgs()));
        IDEUtils.elementOption(javaDocument, configuration, "WORKING_DIRECTORY", runConfig.getWorkingDirectory());
        Element module = javaDocument.createElement("module");
        module.setAttribute("name", runConfig.getIdeaModule());
        configuration.appendChild(module);
        Element envs = javaDocument.createElement("envs");
        runConfig.getEnvironment().forEach((name, value) -> {
            Element envEntry = javaDocument.createElement("env");
            envEntry.setAttribute("name", (String)name);
            envEntry.setAttribute("value", (String)value);
            envs.appendChild(envEntry);
        });
        configuration.appendChild(envs);
        Element methods = javaDocument.createElement("method");
        methods.setAttribute("v", "2");
        Element makeTask = javaDocument.createElement("option");
        makeTask.setAttribute("name", "Make");
        makeTask.setAttribute("enabled", "true");
        methods.appendChild(makeTask);
        Element gradleTask = javaDocument.createElement("option");
        gradleTask.setAttribute("name", "Gradle.BeforeRunTask");
        gradleTask.setAttribute("enabled", "true");
        gradleTask.setAttribute("tasks", project.getTasks().getByName("prepare" + Utils.capitalize(runConfig.getTaskName())).getPath());
        gradleTask.setAttribute("externalProjectPath", "$PROJECT_DIR$");
        methods.appendChild(gradleTask);
        configuration.appendChild(methods);
        rootElement.appendChild(configuration);
        javaDocument.appendChild(rootElement);
        documents.put(runConfig.getUniqueFileName() + ".xml", javaDocument);
        return documents;
    }

    private static void elementAttribute(@Nonnull Document document, @Nonnull Element parent, @Nonnull String attributeType, @Nonnull String key, @Nonnull String value) {
        Element attribute = document.createElement(attributeType + "Attribute");
        attribute.setAttribute("key", key);
        attribute.setAttribute("value", value);
        parent.appendChild(attribute);
    }

    @Nonnull
    private static Map<String, Document> createEclipseRunConfigurationXML(@Nonnull Project project, @Nonnull RunConfig runConfig, @Nonnull String props, @Nonnull DocumentBuilder documentBuilder) {
        LinkedHashMap<String, Document> documents = new LinkedHashMap<String, Document>();
        Document javaDocument = documentBuilder.newDocument();
        Element rootElement = javaDocument.createElement("launchConfiguration");
        rootElement.setAttribute("type", "org.eclipse.jdt.launching.localJavaApplication");
        IDEUtils.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.PROJECT_ATTR", project.getName());
        IDEUtils.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.MAIN_TYPE", runConfig.getMain());
        IDEUtils.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.VM_ARGUMENTS", props);
        IDEUtils.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", String.join((CharSequence)" ", runConfig.getArgs()));
        File workingDirectory = new File(runConfig.getWorkingDirectory());
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
        IDEUtils.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.WORKING_DIRECTORY", runConfig.getWorkingDirectory());
        Element envs = javaDocument.createElement("mapAttribute");
        envs.setAttribute("key", "org.eclipse.debug.core.environmentVariables");
        runConfig.getEnvironment().compute("MOD_CLASSES", (key, value) -> {
            if (value == null || value.isEmpty()) {
                return value;
            }
            EclipseModel eclipse = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
            if (eclipse != null) {
                Map<String, String> outputs = eclipse.getClasspath().resolveDependencies().stream().filter(SourceFolder.class::isInstance).map(SourceFolder.class::cast).map(SourceFolder::getOutput).distinct().collect(Collectors.toMap(output -> output.split("/")[output.split("/").length - 1], output -> project.file(output).getAbsolutePath()));
                if (runConfig.getMods().isEmpty()) {
                    return runConfig.getAllSources().stream().map(SourceSet::getName).filter(outputs::containsKey).map(outputs::get).map(s -> String.join((CharSequence)File.pathSeparator, s, s)).collect(Collectors.joining(File.pathSeparator));
                }
                SourceSet main = (SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main");
                return runConfig.getMods().stream().map(modConfig -> (modConfig.getSources().isEmpty() ? Stream.of(main) : modConfig.getSources().stream()).map(SourceSet::getName).filter(outputs::containsKey).map(outputs::get).map(output -> modConfig.getName() + "%%" + output).map(s -> String.join((CharSequence)File.pathSeparator, s, s))).flatMap(Function.identity()).collect(Collectors.joining(File.pathSeparator));
            }
            return value;
        });
        runConfig.getEnvironment().forEach((name, value) -> {
            Element envEntry = javaDocument.createElement("mapEntry");
            envEntry.setAttribute("key", (String)name);
            envEntry.setAttribute("value", (String)value);
            envs.appendChild(envEntry);
        });
        rootElement.appendChild(envs);
        javaDocument.appendChild(rootElement);
        documents.put(runConfig.getTaskName() + ".launch", javaDocument);
        return documents;
    }

    @FunctionalInterface
    private static interface RunConfigurationGenerator {
        @Nonnull
        public Map<String, Document> createRunConfigurationXML(@Nonnull Project var1, @Nonnull RunConfig var2, @Nonnull String var3, @Nonnull DocumentBuilder var4);
    }
}

