/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.userdev.tasks.RenameJarSrg2Mcp;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Deobfuscator {
    private final Project project;
    private File cacheRoot;
    private DocumentBuilder xmlParser;
    private XPath xPath;
    private Transformer xmlTransformer;

    public Deobfuscator(Project project, File cacheRoot) {
        this.project = project;
        this.cacheRoot = cacheRoot;
        try {
            this.xPath = XPathFactory.newInstance().newXPath();
            this.xmlParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xmlTransformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (ParserConfigurationException | TransformerConfigurationException e) {
            throw new RuntimeException("Error configuring XML parsers", e);
        }
    }

    public File deobfPom(File original, String mappings, String ... cachePath) throws IOException {
        this.project.getLogger().debug("Updating POM file {} with mappings {}", (Object)original.getName(), (Object)mappings);
        File output = this.getCacheFile(cachePath);
        File input = new File(output.getParent(), output.getName() + ".input");
        HashStore cache = new HashStore().load(input).add("mappings", mappings).add("orig", original);
        if (!cache.isSame() || !output.exists()) {
            try {
                Document pom = this.xmlParser.parse(original);
                NodeList versionNodes = (NodeList)this.xPath.compile("/*[local-name()=\"project\"]/*[local-name()=\"version\"]").evaluate(pom, XPathConstants.NODESET);
                if (versionNodes.getLength() > 0) {
                    versionNodes.item(0).setTextContent(versionNodes.item(0).getTextContent() + "_mapped_" + mappings);
                }
                this.xmlTransformer.transform(new DOMSource(pom), new StreamResult(output));
            }
            catch (IOException | TransformerException | XPathExpressionException | SAXException e) {
                this.project.getLogger().error("Error attempting to modify pom file " + original.getName(), (Throwable)e);
                return original;
            }
            Utils.updateHash(output, HashFunction.SHA1);
            cache.save();
        }
        return output;
    }

    public File deobfBinary(File original, String mappings, String ... cachePath) throws IOException {
        this.project.getLogger().debug("Deobfuscating binary file {} with mappings {}", (Object)original.getName(), (Object)mappings);
        File names = this.findMapping(mappings);
        if (names == null || !names.exists()) {
            return null;
        }
        File output = this.getCacheFile(cachePath);
        File input = new File(output.getParent(), output.getName() + ".input");
        HashStore cache = new HashStore().load(input).add("names", names).add("orig", original);
        if (!cache.isSame() || !output.exists()) {
            RenameJarSrg2Mcp rename = (RenameJarSrg2Mcp)this.project.getTasks().create("_RenameSrg2Mcp_" + new Random().nextInt(), RenameJarSrg2Mcp.class);
            rename.setInput(original);
            rename.setOutput(output);
            rename.setMappings(names);
            rename.apply();
            this.project.getTasks().remove((Object)rename);
            Utils.updateHash(output, HashFunction.SHA1);
            cache.save();
        }
        return output;
    }

    public File deobfSources(File original, String mappings, String ... cachePath) throws IOException {
        this.project.getLogger().debug("Deobfuscating sources file {} with mappings {}", (Object)original.getName(), (Object)mappings);
        File names = this.findMapping(mappings);
        if (names == null || !names.exists()) {
            return null;
        }
        File output = this.getCacheFile(cachePath);
        File input = new File(output.getParent(), output.getName() + ".input");
        HashStore cache = new HashStore().load(input).add("names", names).add("orig", original);
        if (!cache.isSame() || !output.exists()) {
            McpNames map = McpNames.load(names);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(input));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(output));){
                ZipEntry _old;
                while ((_old = zin.getNextEntry()) != null) {
                    ZipEntry _new = new ZipEntry(_old.getName());
                    _new.setTime(0L);
                    zout.putNextEntry(_new);
                    if (_old.getName().endsWith(".java")) {
                        String mapped = map.rename(zin, true);
                        IOUtils.write((String)mapped, (OutputStream)zout);
                        continue;
                    }
                    IOUtils.copy((InputStream)zin, (OutputStream)zout);
                }
            }
            Utils.updateHash(output, HashFunction.SHA1);
            cache.save();
        }
        return output;
    }

    private File getCacheFile(String ... cachePath) {
        File cacheFile = new File(this.cacheRoot, String.join((CharSequence)File.separator, cachePath));
        cacheFile.getParentFile().mkdirs();
        return cacheFile;
    }

    private File findMapping(String mapping) {
        if (mapping == null) {
            return null;
        }
        int idx = mapping.lastIndexOf(95);
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = "de.oceanlabs.mcp:mcp_" + channel + ":" + version + "@zip";
        return MavenArtifactDownloader.manual(this.project, desc, false);
    }
}

