/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.MappingFile;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.mcp.MCPRepo;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenerateSRG
extends DefaultTask {
    private File srg;
    private String mapping;
    private MappingFile.Format format = MappingFile.Format.TSRG;
    private boolean reverse;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.tsrg"));

    @TaskAction
    public void apply() throws IOException {
        File names = this.findNames(this.getMappings());
        if (names == null) {
            throw new IllegalStateException("Invalid mappings: " + this.getMappings() + " Could not find archive");
        }
        MappingFile obf_to_srg = MappingFile.load(this.srg);
        MappingFile ret = new MappingFile();
        McpNames map = McpNames.load(names);
        obf_to_srg.getPackages().forEach(e -> ret.addPackage(e.getMapped(), e.getMapped()));
        obf_to_srg.getClasses().forEach(cls -> {
            ret.addClass(cls.getMapped(), cls.getMapped());
            MappingFile.Cls _cls = ret.getClass(cls.getMapped());
            cls.getFields().forEach(fld -> _cls.addField(fld.getMapped(), map.rename(fld.getMapped())));
            cls.getMethods().forEach(mtd -> _cls.addMethod(mtd.getMapped(), mtd.getMappedDescriptor(), map.rename(mtd.getMapped())));
        });
        ret.write(this.getFormat(), this.getOutput(), this.getReverse());
    }

    private File findNames(String mapping) {
        int idx = mapping.lastIndexOf(95);
        if (idx == -1) {
            return null;
        }
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = MCPRepo.getMappingDep(channel, version);
        return MavenArtifactDownloader.manual(this.getProject(), desc, false);
    }

    @InputFile
    public File getSrg() {
        return this.srg;
    }

    public void setSrg(File value) {
        this.srg = value;
    }

    @Input
    public String getMappings() {
        return this.mapping;
    }

    public void setMappings(String value) {
        this.mapping = value;
    }

    @Input
    public MappingFile.Format getFormat() {
        return this.format;
    }

    public void setFormat(MappingFile.Format value) {
        this.format = value;
    }

    @Input
    public boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(boolean value) {
        this.reverse = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

