/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskReobfuscateJar
extends DefaultTask {
    private String tool = "net.md-5:SpecialSource:1.8.3:shaded";
    private String[] args = new String[]{"--in-jar", "{input}", "--out-jar", "{output}", "--srg-in", "{srg}", "--live"};
    private FileCollection classpath = null;
    private File input;
    private File srg;
    private boolean keepPackages = false;
    private boolean keepData = false;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.jar"));
    private File output_temp = this.getProject().file((Object)("build/" + this.getName() + "/output_temp.jar"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void apply() throws IOException {
        File jar = MavenArtifactDownloader.gradle(this.getProject(), this.getTool(), false);
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.output_temp.getAbsolutePath());
        replace.put("{srg}", this.getSrg().getAbsolutePath());
        ArrayList<String> _args = new ArrayList<String>();
        for (String arg : this.args) {
            _args.add(replace.getOrDefault(arg, arg));
        }
        JarFile jarFile = new JarFile(jar);
        String mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        jarFile.close();
        File workDir = this.getProject().file((Object)("build/" + this.getName()));
        if (!workDir.exists()) {
            workDir.mkdirs();
        }
        JavaExec java = (JavaExec)this.getProject().getTasks().create("_", JavaExec.class);
        try (final BufferedOutputStream log = new BufferedOutputStream(new FileOutputStream(new File(workDir, "log.txt")));){
            java.setArgs(_args);
            if (this.getClasspath() == null) {
                java.setClasspath((FileCollection)this.getProject().files(new Object[]{jar}));
            } else {
                java.setClasspath((FileCollection)this.getProject().files(new Object[]{this.getClasspath(), jar}));
            }
            java.setWorkingDir(workDir);
            java.setMain(mainClass);
            java.setStandardOutput(new OutputStream(){

                @Override
                public void flush() throws IOException {
                    log.flush();
                }

                @Override
                public void close() {
                }

                @Override
                public void write(int b) throws IOException {
                    log.write(b);
                }
            });
            java.exec();
            List lines = Files.readLines((File)this.getSrg(), (Charset)StandardCharsets.UTF_8);
            lines = lines.stream().map(line -> line.split("#")[0]).filter(l -> l != null & !l.trim().isEmpty()).collect(Collectors.toList());
            HashSet packages = new HashSet();
            lines.stream().filter(line -> !line.startsWith("\t") || line.indexOf(58) != -1 && line.startsWith("CL:")).map(line -> line.indexOf(58) != -1 ? line.substring(4).split(" ") : line.split(" ")).filter(pts -> ((String[])pts).length == 2).forEach(pts -> {
                int idx = pts[0].lastIndexOf(47);
                if (idx != -1) {
                    packages.add(pts[0].substring(0, idx + 1) + "package-info.class");
                }
            });
            try (ZipFile zin = new ZipFile(this.output_temp);
                 ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.getOutput()));){
                Enumeration<? extends ZipEntry> enu = zin.entries();
                while (enu.hasMoreElements()) {
                    boolean filter;
                    ZipEntry entry = enu.nextElement();
                    boolean bl = filter = entry.isDirectory() || entry.getName().startsWith("mcp/");
                    if (!this.keepPackages) {
                        filter |= packages.contains(entry.getName());
                    }
                    if (!this.keepData) {
                        filter |= !entry.getName().endsWith(".class");
                    }
                    if (filter) {
                        ((OutputStream)log).write(("Filtered: " + entry.getName() + '\n').getBytes(StandardCharsets.UTF_8));
                        continue;
                    }
                    out.putNextEntry(entry);
                    IOUtils.copy((InputStream)zin.getInputStream(entry), (OutputStream)out);
                    out.closeEntry();
                }
            }
            this.output_temp.delete();
        }
        finally {
            this.getProject().getTasks().remove((Object)java);
        }
    }

    @Input
    public String getTool() {
        return this.tool;
    }

    public void setTool(String value) {
        this.tool = value;
    }

    @Input
    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] value) {
        this.args = value;
    }

    @Input
    public boolean getKeepPackages() {
        return this.keepPackages;
    }

    public void keepPackages() {
        this.keepPackages = true;
    }

    public void filterPackages() {
        this.keepPackages = false;
    }

    @Input
    public boolean getKeepData() {
        return this.keepData;
    }

    public void keepData() {
        this.keepData = true;
    }

    public void filterData() {
        this.keepData = false;
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    public void setInput(File value) {
        this.input = value;
    }

    @InputFile
    public File getSrg() {
        return this.srg;
    }

    public void setSrg(File value) {
        this.srg = value;
    }

    @Optional
    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection value) {
        this.classpath = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

