/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.google.common.io.Files;
import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskCreateSrg
extends DefaultTask {
    private static Pattern CLS_ENTRY = Pattern.compile("L([^;]+);");
    private File srg;
    private File mappings;
    private boolean notch = false;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.srg"));

    @TaskAction
    public void run() throws IOException {
        Map<String, String> names = this.loadMappings();
        ArrayList out = new ArrayList();
        List lines = Files.readLines((File)this.getSrg(), (Charset)StandardCharsets.UTF_8);
        lines = lines.stream().map(line -> line.split("#")[0]).filter(l -> l != null && !l.trim().isEmpty()).collect(Collectors.toList());
        HashMap classes = new HashMap();
        lines.stream().filter(line -> !line.startsWith("\t") || line.indexOf(58) != -1 && line.startsWith("CL:")).map(line -> line.indexOf(58) != -1 ? line.substring(4).split(" ") : line.split(" ")).filter(pts -> ((String[])pts).length == 2 && !pts[0].endsWith("/")).forEach(pts -> classes.put(pts[0], pts[1]));
        lines.stream().map(l -> l.split(" ")).forEach(pts -> {
            boolean tsrg = false;
            if (pts[0].startsWith("\t")) {
                tsrg = true;
                pts[0] = pts[0].substring(1);
            }
            if (pts[0].indexOf(58) != -1) {
                if (pts[0].equals("PK:") || pts[0].equals("CL:")) {
                    if (this.notch) {
                        this.swap((String[])pts, 1, 2);
                    } else {
                        pts[1] = pts[2];
                    }
                } else if (pts[0].equals("FD:")) {
                    if (this.notch) {
                        this.swap((String[])pts, 1, 2);
                        pts[1] = this.remapSrg(pts[1], names);
                    } else {
                        pts[1] = this.remapSrg(pts[2], names);
                    }
                } else if (pts[0].equals("MD:")) {
                    if (this.notch) {
                        this.swap((String[])pts, 1, 3);
                        this.swap((String[])pts, 2, 4);
                        pts[1] = this.remapSrg(pts[1], names);
                    } else {
                        pts[1] = this.remapSrg(pts[3], names);
                        pts[2] = pts[4];
                    }
                }
            } else if (tsrg) {
                if (((String[])pts).length == 2) {
                    if (this.notch) {
                        this.swap((String[])pts, 0, 1);
                        pts[0] = names.getOrDefault(pts[0], pts[0]);
                    } else {
                        pts[0] = names.getOrDefault(pts[1], pts[1]);
                    }
                } else if (((String[])pts).length == 3) {
                    if (this.notch) {
                        this.swap((String[])pts, 0, 2);
                        pts[0] = names.getOrDefault(pts[0], pts[0]);
                    } else {
                        pts[0] = names.getOrDefault(pts[2], pts[2]);
                    }
                    pts[1] = this.remapDesc(pts[1], classes);
                } else {
                    throw new IllegalStateException("Invalid TSRG line: " + String.join((CharSequence)" ", pts));
                }
                pts[0] = '\t' + pts[0];
            } else if (((String[])pts).length == 2) {
                if (this.notch) {
                    this.swap((String[])pts, 0, 1);
                } else {
                    pts[0] = pts[1];
                }
            } else if (((String[])pts).length == 3) {
                pts[0] = classes.getOrDefault(pts[0], pts[0]);
                if (this.notch) {
                    this.swap((String[])pts, 1, 2);
                    pts[1] = names.getOrDefault(pts[1], pts[1]);
                } else {
                    pts[1] = names.getOrDefault(pts[2], pts[2]);
                }
            } else if (((String[])pts).length == 4) {
                pts[0] = classes.getOrDefault(pts[0], pts[0]);
                if (this.notch) {
                    this.swap((String[])pts, 1, 3);
                    pts[1] = names.getOrDefault(pts[1], pts[1]);
                } else {
                    pts[1] = names.getOrDefault(pts[3], pts[3]);
                }
                pts[2] = this.remapDesc(pts[2], classes);
            } else {
                throw new IllegalStateException("Invalid CSRG line: " + String.join((CharSequence)" ", pts));
            }
            out.add(String.join((CharSequence)" ", pts));
        });
        try (FileOutputStream fos = new FileOutputStream(this.getOutput());){
            IOUtils.write((String)String.join((CharSequence)"\n", out), (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
        }
    }

    private String remapSrg(String entry, Map<String, String> names) {
        int idx = entry.lastIndexOf(47);
        String name = entry.substring(idx + 1);
        return entry.substring(0, idx + 1) + names.getOrDefault(name, name);
    }

    private String remapClass(String cls, Map<String, String> map) {
        String ret = map.get(cls);
        if (ret != null) {
            return ret;
        }
        int idx = cls.lastIndexOf(36);
        ret = idx != -1 ? this.remapClass(cls.substring(0, idx), map) + cls.substring(idx) : cls;
        map.put(cls, ret);
        return cls;
    }

    private String remapDesc(String desc, Map<String, String> map) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = CLS_ENTRY.matcher(desc);
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + this.remapClass(matcher.group(1), map) + ";"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    private Map<String, String> loadMappings() throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(this.getMappings());){
            zip.stream().filter(e -> e.getName().equals("fields.csv") || e.getName().equals("methods.csv")).forEach(e -> {
                CsvReader reader = new CsvReader();
                reader.setContainsHeader(true);
                try {
                    CsvContainer csv = reader.read((Reader)new InputStreamReader(zip.getInputStream((ZipEntry)e)));
                    for (CsvRow row : csv.getRows()) {
                        names.put(row.getField("searge"), row.getField("name"));
                    }
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            });
        }
        return names;
    }

    private void swap(String[] value, int i1, int i2) {
        String tmp = value[i1];
        value[i1] = value[i2];
        value[i2] = tmp;
    }

    @InputFile
    public File getSrg() {
        return this.srg;
    }

    public void setSrg(File value) {
        this.srg = value;
    }

    @InputFile
    public File getMappings() {
        return this.mappings;
    }

    public void setMappings(File value) {
        this.mappings = value;
    }

    @Input
    public boolean getNotch() {
        return this.notch;
    }

    public void toNotch() {
        this.notch = true;
    }

    public void toSrg() {
        this.notch = false;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

