/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.mcp.function.ExecuteFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.gradle.api.Project;

public class SideAnnotationStripperFunction
extends ExecuteFunction {
    private List<File> files;
    private String data;

    public SideAnnotationStripperFunction(Project mcp, List<File> files) {
        super(SideAnnotationStripperFunction.getJar(mcp), new String[0], SideAnnotationStripperFunction.getArguments(files), new HashMap<String, String>());
        this.files = files;
    }

    private static File getJar(Project mcp) {
        return MavenArtifactDownloader.gradle(mcp, "net.minecraftforge:mergetool:1.0.7:fatjar", false);
    }

    private static String[] getArguments(List<File> files) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--strip");
        args.add("--input");
        args.add("{input}");
        args.add("--output");
        args.add("{output}");
        files.forEach(f -> {
            args.add("--data");
            args.add(f.getAbsolutePath());
        });
        return args.toArray(new String[args.size()]);
    }

    @Override
    public File execute(MCPEnvironment env) throws IOException, InterruptedException, ExecutionException {
        if (this.data != null) {
            File tmp = env.getFile("string_data.sas").getAbsoluteFile();
            if (!tmp.getParentFile().exists()) {
                tmp.getParentFile().mkdirs();
            }
            Files.write(tmp.toPath(), this.data.getBytes(), new OpenOption[0]);
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.runArgs));
            args.add("--data");
            args.add(tmp.getAbsolutePath());
            this.runArgs = args.toArray(new String[args.size()]);
        }
        return super.execute(env);
    }

    public void addData(String data) {
        this.data = this.data == null ? data : this.data + "\n#============================================================\n" + data;
    }

    @Override
    protected void addInputs(HashStore cache) {
        cache.add(this.files);
        if (this.data != null) {
            cache.add("data", this.data);
        }
    }

    @Override
    public void addInputs(HashStore cache, String prefix) {
        cache.add(prefix + "args", String.join((CharSequence)" ", this.runArgs));
        cache.add(prefix + "jvmargs", String.join((CharSequence)" ", this.runArgs));
        if (this.data != null) {
            cache.add(prefix + "data", this.data);
        }
        try {
            cache.add(prefix + "jar", this.jar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

