/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class ModConfig
extends GroovyObjectSupport {
    private final transient Project project;
    private final String name;
    private FileCollection resources;
    private FileCollection classes;
    private List<SourceSet> sources;

    public ModConfig(@Nonnull Project project, @Nonnull String name) {
        this.project = project;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setClasses(FileCollection classes) {
        this.classes = classes;
    }

    public void classes(Object ... classes) {
        this.setClasses(this.getClasses().plus((FileCollection)this.project.files(classes)));
    }

    public FileCollection getClasses() {
        if (this.classes == null) {
            this.classes = this.project.files(new Object[0]);
        }
        return this.classes;
    }

    public void setResources(@Nonnull FileCollection resources) {
        this.resources = resources;
    }

    public void resources(Object ... resources) {
        this.setResources(this.getResources().plus((FileCollection)this.project.files(resources)));
    }

    public void resource(@Nonnull Object resource) {
        this.resources(resource);
    }

    public FileCollection getResources() {
        if (this.resources == null) {
            this.resources = this.project.files(new Object[0]);
        }
        return this.resources;
    }

    public void setSources(List<SourceSet> sources) {
        this.sources = sources;
    }

    public void sources(@Nonnull List<SourceSet> sources) {
        this.getSources().addAll(sources);
        sources.forEach(source -> {
            this.classes(source.getOutput().getClassesDirs());
            this.resource(source.getOutput().getResourcesDir());
        });
    }

    public void sources(SourceSet ... sources) {
        this.sources(Arrays.asList(sources));
    }

    public void source(@Nonnull SourceSet source) {
        this.sources(source);
    }

    public List<SourceSet> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceSet>();
        }
        return this.sources;
    }

    public void merge(@Nonnull ModConfig other, boolean overwrite) {
        if (overwrite) {
            this.sources = other.sources == null ? this.sources : other.sources;
            this.classes = other.classes == null ? this.classes : other.classes;
            this.resources = other.resources == null ? this.resources : other.resources;
        } else {
            if (other.resources != null) {
                this.resources(other.getResources());
            }
            if (other.classes != null) {
                this.classes(other.getClasses());
            }
            if (other.sources != null) {
                this.sources(other.getSources());
            }
        }
    }

    public void configureTokens(@Nonnull Map<String, String> tokens) {
        SourceSet main = (SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main");
        Stream<String> modClasses = Stream.concat(this.resources == null ? Stream.of(main.getOutput().getResourcesDir()) : this.resources.getFiles().stream(), (this.classes == null ? main.getOutput().getClassesDirs().getFiles() : this.classes.getFiles()).stream()).distinct().map(file -> this.getName() + "%%" + file.getAbsolutePath());
        if (tokens.containsKey("source_roots")) {
            modClasses = Stream.concat(Arrays.stream(tokens.get("source_roots").split(File.pathSeparator)), modClasses);
        }
        tokens.put("source_roots", modClasses.distinct().collect(Collectors.joining(File.pathSeparator)));
    }
}

