/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.util.EclipseHacks;
import net.minecraftforge.gradle.common.util.IDEUtils;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskProvider;

public abstract class MinecraftExtension
extends GroovyObjectSupport {
    protected final Project project;
    protected final NamedDomainObjectContainer<RunConfig> runs;
    protected String mapping_channel;
    protected String mapping_version;
    protected List<File> accessTransformers;
    protected List<File> sideAnnotationStrippers;

    @Inject
    public MinecraftExtension(Project project) {
        this.project = project;
        this.runs = project.container(RunConfig.class, name -> new RunConfig(project, name));
    }

    public Project getProject() {
        return this.project;
    }

    public NamedDomainObjectContainer<RunConfig> runs(Closure closure) {
        return this.runs.configure(closure);
    }

    public NamedDomainObjectContainer<RunConfig> getRuns() {
        return this.runs;
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name);
        }
        Closure closure = (Closure)value;
        RunConfig runConfig = (RunConfig)this.getRuns().maybeCreate(name);
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)runConfig);
        closure.call();
    }

    @Deprecated
    public void setMappings(String mappings) {
        int idx = mappings.lastIndexOf(95);
        if (idx == -1) {
            throw new RuntimeException("Invalid mapping string format, must be {channel}_{version}. Consider using mappings(channel, version) directly.");
        }
        String channel = mappings.substring(0, idx);
        String version = mappings.substring(idx + 1);
        this.mappings(channel, version);
    }

    public void mappings(String channel, String version) {
        this.mapping_channel = channel;
        this.mapping_version = version;
    }

    public void mappings(Map<String, CharSequence> mappings) {
        CharSequence channel = mappings.get("channel");
        CharSequence version = mappings.get("version");
        if (channel == null || version == null) {
            throw new IllegalArgumentException("Must specify both mappings channel and version");
        }
        this.mappings(channel.toString(), version.toString());
    }

    public String getMappings() {
        return this.mapping_channel == null || this.mapping_version == null ? null : this.mapping_channel + '_' + this.mapping_version;
    }

    public String getMappingChannel() {
        return this.mapping_channel;
    }

    public void setMappingChannel(String value) {
        this.mapping_channel = value;
    }

    public String getMappingVersion() {
        return this.mapping_version;
    }

    public void setMappingVersion(String value) {
        this.mapping_version = value;
    }

    public void setAccessTransformers(List<File> accessTransformers) {
        this.accessTransformers = new ArrayList<File>(accessTransformers);
    }

    public void setAccessTransformers(File ... accessTransformers) {
        this.setAccessTransformers(Arrays.asList(accessTransformers));
    }

    public void setAccessTransformer(File accessTransformers) {
        this.setAccessTransformers(accessTransformers);
    }

    public void accessTransformer(File ... accessTransformers) {
        this.getAccessTransformers().addAll(Arrays.asList(accessTransformers));
    }

    public void accessTransformers(File ... accessTransformers) {
        this.accessTransformer(accessTransformers);
    }

    public List<File> getAccessTransformers() {
        if (this.accessTransformers == null) {
            this.accessTransformers = new ArrayList<File>();
        }
        return this.accessTransformers;
    }

    public void setSideAnnotationStrippers(List<File> value) {
        this.sideAnnotationStrippers = new ArrayList<File>(value);
    }

    public void setSideAnnotationStrippers(File ... value) {
        this.setSideAnnotationStrippers(Arrays.asList(value));
    }

    public void setSideAnnotationStripper(File value) {
        this.getSideAnnotationStrippers().add(value);
    }

    public void setSideAnnotationStripper(File ... values) {
        for (File value : values) {
            this.setSideAnnotationStripper(value);
        }
    }

    public void sideAnnotationStripper(File ... values) {
        this.setSideAnnotationStripper(values);
    }

    public void sideAnnotationStrippers(File ... values) {
        this.sideAnnotationStripper(values);
    }

    public List<File> getSideAnnotationStrippers() {
        if (this.sideAnnotationStrippers == null) {
            this.sideAnnotationStrippers = new ArrayList<File>();
        }
        return this.sideAnnotationStrippers;
    }

    public void createRunConfigTasks(TaskProvider<ExtractNatives> extractNatives, TaskProvider<DownloadAssets> downloadAssets) {
        this.createRunConfigTasks((ExtractNatives)((Object)extractNatives.get()), (DownloadAssets)((Object)downloadAssets.get()));
    }

    public void createRunConfigTasks(ExtractNatives extractNatives, DownloadAssets downloadAssets) {
        TaskProvider prepareRuns = this.project.getTasks().register("prepareRuns", Task.class, task -> {
            task.setGroup("fg_runs");
            task.dependsOn(new Object[]{extractNatives, downloadAssets});
        });
        TaskProvider makeSrcDirs = this.project.getTasks().register("makeSrcDirs", Task.class, task -> task.doFirst(t -> {
            JavaPluginConvention java = (JavaPluginConvention)task.getProject().getConvention().getPlugin(JavaPluginConvention.class);
            java.getSourceSets().forEach(s -> s.getAllSource().getSrcDirs().stream().filter(f -> !f.exists()).forEach(File::mkdirs));
        }));
        this.getRuns().forEach(RunConfig::mergeParents);
        this.project.getGradle().projectsEvaluated(gradle -> {
            VersionJson json = null;
            try {
                json = Utils.loadJson(extractNatives.getMeta(), VersionJson.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            List<Object> additionalClientArgs = json != null ? json.getPlatformJvmArgs() : Collections.emptyList();
            this.getRuns().forEach(RunConfig::mergeChildren);
            this.getRuns().forEach(run -> run.createRunTask((TaskProvider<Task>)prepareRuns, (List<String>)additionalClientArgs));
            EclipseHacks.doEclipseFixes(this, extractNatives, downloadAssets, (TaskProvider<Task>)makeSrcDirs);
            IDEUtils.createIDEGenRunsTasks(this, (TaskProvider<Task>)prepareRuns, (TaskProvider<Task>)makeSrcDirs);
        });
    }
}

