/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;

public class ExtractInheritance
extends JarExec {
    private Supplier<File> input;
    private List<Supplier<File>> libraries = new ArrayList<Supplier<File>>();
    private Supplier<File> output = () -> this.getProject().file((Object)("build/" + this.getName() + "/output.json"));

    public ExtractInheritance() {
        this.tool = "net.minecraftforge:installertools:1.1.7:fatjar";
        this.args = new String[]{"--task", "extract_inheritance", "--input", "{input}", "--output", "{output}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        List<String> ret = Arrays.stream(this.getArgs()).map(arg -> replace.getOrDefault(arg, (String)arg)).collect(Collectors.toList());
        this.getLibraries().forEach(f -> {
            ret.add("--lib");
            ret.add(f.getAbsolutePath());
        });
        return ret;
    }

    @InputFile
    public File getInput() {
        return this.input == null ? null : this.input.get();
    }

    public void setInput(Supplier<File> v) {
        this.input = v;
    }

    public void input(Supplier<File> v) {
        this.setInput(v);
    }

    public void setInput(File v) {
        this.setInput(() -> v);
    }

    public void input(File v) {
        this.setInput(v);
    }

    @InputFiles
    public List<File> getLibraries() {
        return this.libraries.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public void addLibrary(Supplier<File> v) {
        this.libraries.add(v);
    }

    public void library(Supplier<File> v) {
        this.addLibrary(v);
    }

    public void addLibrary(File lib) {
        this.addLibrary(() -> lib);
    }

    public void library(File v) {
        this.addLibrary(v);
    }

    @OutputFile
    public File getOutput() {
        return this.output.get();
    }

    public void setOutput(Supplier<File> v) {
        this.output = v;
    }

    public void output(Supplier<File> v) {
        this.setOutput(v);
    }

    public void setOutput(File v) {
        this.setInput(() -> v);
    }

    public void output(File v) {
        this.setOutput(v);
    }
}

