/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.gradle.api.Project;

public class UserDevExtension {
    private String mappings;
    private List<File> accessTransformers = new ArrayList<File>();
    private RunConfig.Container runs = new RunConfig.Container();

    @Inject
    public UserDevExtension(Project project) {
    }

    public void mappings(Map<String, String> map) {
        String channel = map.get("channel");
        String version = map.get("version");
        if (channel == null || version == null) {
            throw new IllegalArgumentException("Must specify mappings channel and version");
        }
        this.setMappings(channel + '_' + version);
    }

    public void setMappings(String value) {
        this.mappings = value;
    }

    public String getMappings() {
        return this.mappings;
    }

    public void accessTransformer(File file) {
        this.setAccessTransformer(file);
    }

    public void setAccessTransformer(File file) {
        this.accessTransformers.add(file);
    }

    public void setAccessTransformers(List<File> files) {
        this.accessTransformers.clear();
        this.accessTransformers.addAll(files);
    }

    public List<File> getAccessTransformers() {
        return this.accessTransformers;
    }

    public void runs(Closure<? super RunConfig.Container> value) {
        value.setResolveStrategy(1);
        value.setDelegate((Object)this.runs);
        value.call();
    }

    public Map<String, RunConfig> getRuns() {
        return this.runs.getRuns();
    }
}

