/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import groovy.util.Node;
import groovy.util.XmlParser;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.xml.sax.SAXException;

public class EclipseHacks {
    public static void doEclipseFixes(Project project, ExtractNatives nativesTask, DownloadAssets assetsTask, Map<String, RunConfig> runs) {
        File natives = nativesTask.getOutput();
        File assets = assetsTask.getOutput();
        String LIB_ATTR = "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
        project.getTasks().withType(GenerateEclipseClasspath.class, task -> {
            task.dependsOn(new Object[]{nativesTask, assetsTask});
            task.doFirst(t -> task.getClasspath().getSourceSets().forEach(s -> {
                if (s.getName().equals("main")) {
                    s.getAllSource().getSrcDirs().stream().filter(f -> !f.exists()).forEach(File::mkdirs);
                }
            }));
            task.doLast(t -> {
                try {
                    Node xml = new XmlParser().parse(task.getOutputFile());
                    ArrayList entries = (ArrayList)xml.get("classpathentry");
                    HashSet paths = new HashSet();
                    ArrayList remove = new ArrayList();
                    entries.stream().filter(e -> "src".equals(e.get("@kind"))).forEach(e -> {
                        Node attr;
                        if (!paths.add((String)e.get("@path"))) {
                            remove.add(e);
                        }
                        if (((List)e.get("attributes")).isEmpty()) {
                            e.appendNode((Object)"attributes");
                        }
                        if (((List)(attr = (Node)((List)e.get("attributes")).get(0)).get("attribute")).stream().noneMatch(n -> "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY".equals(n.get("@name")))) {
                            attr.appendNode((Object)"attribute", EclipseHacks.props("name", "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", "value", natives.getAbsolutePath()));
                        }
                    });
                    remove.forEach(arg_0 -> ((Node)xml).remove(arg_0));
                    try (FileOutputStream fos = new FileOutputStream(task.getOutputFile());){
                        IOUtils.write((String)XmlUtil.serialize((Node)xml), (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
                    }
                    for (Map.Entry entry : runs.entrySet()) {
                        RunConfig runConfig = (RunConfig)entry.getValue();
                        xml = new Node(null, (Object)"launchConfiguration", EclipseHacks.props("type", "org.eclipse.jdt.launching.localJavaApplication"));
                        String workDir = runConfig.getWorkingDirectory();
                        if (workDir != null) {
                            File file = new File(workDir);
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                            xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.WORKING_DIRECTORY", "value", workDir));
                        }
                        xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.MAIN_TYPE", "value", runConfig.getMain()));
                        xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.PROJECT_ATTR", "value", project.getName()));
                        Node env = xml.appendNode((Object)"mapAttribute", EclipseHacks.props("key", "org.eclipse.debug.core.environmentVariables"));
                        env.appendNode((Object)"mapEntry", EclipseHacks.props("key", "assetDirectory", "value", assets.getAbsolutePath()));
                        runConfig.getEnvironment().forEach((k, v) -> env.appendNode((Object)"mapEntry", EclipseHacks.props("key", k, "value", v)));
                        Stream<String> propStream = runConfig.getProperties().entrySet().stream().map(e -> {
                            String val = (String)e.getValue();
                            if (val.indexOf(32) != -1) {
                                val = "\"" + ((String)e.getValue()).replaceAll("\"", "\\\"") + "\"";
                            }
                            return "-D" + (String)e.getKey() + "=" + val;
                        });
                        String props = Stream.concat(propStream, runConfig.getJvmArgs().stream()).collect(Collectors.joining("\n"));
                        if (!props.isEmpty()) {
                            xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.VM_ARGUMENTS", "value", props));
                        }
                        FileOutputStream fos = new FileOutputStream(project.file((Object)((String)entry.getKey() + ".launch")));
                        Throwable throwable = null;
                        try {
                            IOUtils.write((String)XmlUtil.serialize((Node)xml), (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fos == null) continue;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)fos).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((OutputStream)fos).close();
                        }
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException e2) {
                    throw new RuntimeException(e2);
                }
            });
        });
    }

    private static Map<String, String> props(String ... data) {
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("Properties must be key,value pairs");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int x = 0; x < data.length; x += 2) {
            ret.put(data[x], data[x + 1]);
        }
        return ret;
    }
}

