/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.util.Utils;

public class MCPConfigV1
extends Config {
    private String version;
    private Map<String, Object> data;
    private Map<String, List<Step>> steps;
    private Map<String, Function> functions;
    private Map<String, List<String>> libraries;

    public static MCPConfigV1 get(InputStream stream) {
        return Utils.fromJson(stream, MCPConfigV1.class);
    }

    public static MCPConfigV1 get(byte[] data) {
        return MCPConfigV1.get(new ByteArrayInputStream(data));
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getData() {
        return this.data == null ? Collections.emptyMap() : this.data;
    }

    public String getData(String ... path) {
        if (this.data == null) {
            return null;
        }
        Map level = this.data;
        for (String part : path) {
            if (!level.containsKey(part)) {
                return null;
            }
            Object val = level.get(part);
            if (val instanceof String) {
                return (String)val;
            }
            if (!(val instanceof Map)) continue;
            level = (Map)val;
        }
        return null;
    }

    public List<Step> getSteps(String side) {
        List<Step> ret = this.steps == null ? null : this.steps.get(side);
        return ret == null ? Collections.emptyList() : ret;
    }

    public Function getFunction(String name) {
        return this.functions == null ? null : this.functions.get(name);
    }

    public Map<String, Function> getFunctions() {
        return this.functions == null ? Collections.emptyMap() : this.functions;
    }

    public List<String> getLibraries(String side) {
        List<String> ret = this.libraries == null ? null : this.libraries.get(side);
        return ret == null ? Collections.emptyList() : ret;
    }

    public static class Function {
        private String version;
        private String repo;
        private List<String> args;
        private List<String> jvmargs;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String value) {
            this.version = value;
        }

        public String getRepo() {
            return this.repo == null ? "https://libraries.minecraft.net/" : this.repo;
        }

        public void setRepo(String value) {
            this.repo = value;
        }

        public List<String> getArgs() {
            return this.args == null ? Collections.emptyList() : this.args;
        }

        public void setArgs(List<String> value) {
            this.args = value;
        }

        public List<String> getJvmArgs() {
            return this.jvmargs == null ? Collections.emptyList() : this.jvmargs;
        }

        public void setJvmArgs(List<String> value) {
            this.jvmargs = value;
        }
    }

    public static class Step {
        private final String type;
        private final String name;
        private final Map<String, String> values;

        private Step(String type, String name, Map<String, String> values) {
            this.type = type;
            this.name = name;
            this.values = values;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getValues() {
            return this.values == null ? Collections.emptyMap() : this.values;
        }

        public String getValue(String key) {
            return this.values == null ? null : this.values.get(key);
        }

        public static class Deserializer
        implements JsonDeserializer<Step> {
            public Step deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject obj = json.getAsJsonObject();
                if (!obj.has("type")) {
                    throw new JsonParseException("Could not parse step: Missing 'type'");
                }
                String type = obj.get("type").getAsString();
                String name = obj.has("name") ? obj.get("name").getAsString() : type;
                Map<String, String> values = obj.entrySet().stream().filter(e -> !"type".equals(e.getKey()) && !"name".equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
                return new Step(type, name, values);
            }
        }
    }
}

