/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedString;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class ForgeVersionReplaceTask
extends DefaultTask {
    DelayedFile outputFile;
    DelayedString replacement;

    @TaskAction
    public void doTask() throws IOException {
        String data = (String)Files.readLines((File)this.getOutputFile(), (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<String>(){
            StringBuilder buf = new StringBuilder();

            public boolean processLine(String line) throws IOException {
                if (line.contains("public static final int") && line.contains("buildVersion")) {
                    this.buf.append(line.split("=")[0]).append("= ").append(ForgeVersionReplaceTask.this.getReplacement()).append(";\n");
                } else {
                    this.buf.append(line).append('\n');
                }
                return true;
            }

            public String getResult() {
                return this.buf.toString();
            }
        });
        Files.write((CharSequence)data, (File)this.getOutputFile(), (Charset)Charset.defaultCharset());
    }

    public void setOutputFile(DelayedFile output) {
        this.outputFile = output;
    }

    public File getOutputFile() {
        return this.outputFile.call();
    }

    public void setReplacement(DelayedString value) {
        this.replacement = value;
    }

    public String getReplacement() {
        return this.replacement.call();
    }
}

