/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.abstractutil;

import com.google.common.io.ByteStreams;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.apache.shiro.util.AntPathMatcher;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class ExtractTask
extends CachedTask {
    private final AntPathMatcher antMatcher = new AntPathMatcher();
    @InputFiles
    private LinkedHashSet<DelayedFile> sourcePaths = new LinkedHashSet();
    @Input
    private List<String> excludes = new LinkedList<String>();
    @Input
    private List<Closure<Boolean>> excludeCalls = new LinkedList<Closure<Boolean>>();
    @Input
    private List<String> includes = new LinkedList<String>();
    @Input
    private boolean includeEmptyDirs = true;
    @CachedTask.Cached
    @OutputDirectory
    private DelayedFile destinationDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void doTask() throws IOException {
        if (!this.destinationDir.call().exists()) {
            this.destinationDir.call().mkdirs();
        }
        for (DelayedFile source : this.sourcePaths) {
            this.getLogger().debug("Extracting: " + (Object)((Object)source));
            ZipFile input = new ZipFile(source.call());
            try {
                Enumeration<? extends ZipEntry> itr = input.entries();
                while (itr.hasMoreElements()) {
                    ZipEntry entry = itr.nextElement();
                    if (!this.shouldExtract(entry.getName())) continue;
                    File out = new File(this.destinationDir.call(), entry.getName());
                    this.getLogger().debug("  " + out);
                    if (entry.isDirectory()) {
                        if (!this.includeEmptyDirs || out.exists()) continue;
                        out.mkdirs();
                        continue;
                    }
                    File outParent = out.getParentFile();
                    if (!outParent.exists()) {
                        outParent.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(out);
                    InputStream ins = input.getInputStream(entry);
                    ByteStreams.copy((InputStream)ins, (OutputStream)fos);
                    fos.close();
                    ins.close();
                }
            }
            finally {
                input.close();
            }
        }
    }

    private boolean shouldExtract(String path) {
        for (String string : this.excludes) {
            if (!this.antMatcher.matches(string, path)) continue;
            return false;
        }
        for (Closure closure : this.excludeCalls) {
            if (!((Boolean)closure.call((Object)path)).booleanValue()) continue;
            return false;
        }
        for (String string : this.includes) {
            if (!this.antMatcher.matches(string, path)) continue;
            return true;
        }
        return this.includes.size() == 0;
    }

    public ExtractTask from(DelayedFile ... paths) {
        for (DelayedFile path : paths) {
            this.sourcePaths.add(path);
        }
        return this;
    }

    public ExtractTask into(DelayedFile target) {
        this.destinationDir = target;
        return this;
    }

    public ExtractTask setDestinationDir(DelayedFile target) {
        this.destinationDir = target;
        return this;
    }

    public File getDestinationDir() {
        return this.destinationDir.call();
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public ExtractTask include(String ... paterns) {
        for (String patern : paterns) {
            this.includes.add(patern);
        }
        return this;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public ExtractTask exclude(String ... paterns) {
        for (String patern : paterns) {
            this.excludes.add(patern);
        }
        return this;
    }

    public List<Closure<Boolean>> getExcludeCalls() {
        return this.excludeCalls;
    }

    public void exclude(Closure<Boolean> c) {
        this.excludeCalls.add(c);
    }

    public FileCollection getSourcePaths() {
        ConfigurableFileCollection collection = this.getProject().files(new Object[0]);
        for (DelayedFile file : this.sourcePaths) {
            collection = collection.plus((FileCollection)this.getProject().files(new Object[]{file}));
        }
        return collection;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    @Override
    protected boolean defaultCache() {
        return false;
    }
}

