/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.gradle.StringUtils;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedString;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ObtainFernFlowerTask
extends CachedTask {
    @Input
    private DelayedString mcpUrl;
    @OutputFile
    private DelayedFile ffJar;

    @TaskAction
    public void doTask() throws MalformedURLException, IOException {
        File ff = this.getFfJar();
        String url = this.getMcpUrl();
        this.getLogger().info("Downloading " + url);
        this.getLogger().info("Fernflower output location " + ff);
        HttpURLConnection connect = (HttpURLConnection)new URL(url).openConnection();
        connect.setInstanceFollowRedirects(true);
        ZipInputStream zin = new ZipInputStream(connect.getInputStream());
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            if (!StringUtils.lower(entry.getName()).endsWith("fernflower.jar")) continue;
            ff.getParentFile().mkdirs();
            Files.touch((File)ff);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zin), (File)ff);
        }
        zin.close();
        this.getLogger().info("Download and Extraction complete");
    }

    public String getMcpUrl() {
        return this.mcpUrl.call();
    }

    public void setMcpUrl(DelayedString mcpUrl) {
        this.mcpUrl = mcpUrl;
    }

    public File getFfJar() {
        return this.ffJar.call();
    }

    public void setFfJar(DelayedFile ffJar) {
        this.ffJar = ffJar;
    }
}

