/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.extrastuff;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.StringUtils;
import net.minecraftforge.gradle.common.Constants;

public class FmlCleanup {
    private static final Pattern METHOD_REG = Pattern.compile((String)"^(?<indent>\\s+)(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?:(?<return>[\\w\\[\\]\\.$]+) )?(?<name>[\\w$]+)\\((?<parameters>.*?)\\)(?<end>(?: throws (?<throws>[\\w$.]+(?:, [\\w$.]+)*))?)");
    private static final Pattern CATCH_REG = Pattern.compile((String)"catch \\((.*)\\)$");
    private static final Pattern METHOD_DEC_END = Pattern.compile((String)"(}|\\);|throws .+?;)$");
    private static final Pattern CAPS_START = Pattern.compile((String)"^[A-Z]");
    private static final Pattern ARRAY = Pattern.compile((String)"(\\[|\\.\\.\\.)");
    private static final Pattern VAR_CALL = Pattern.compile((String)"(?i)[a-z_$][a-z0-9_\\[\\]]+ var\\d+(?:x)*");
    private static final Pattern VAR = Pattern.compile((String)"var\\d+(?:x)*");
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            return str2.length() - str1.length();
        }
    };
    HashMap<String, Holder> last;
    HashMap<String, String> remap;

    public static String renameClass(String text) {
        String[] lines = text.split("(\r\n|\r|\n)");
        ArrayList<String> output = new ArrayList<String>(lines.length);
        MethodInfo method = null;
        for (String line : lines) {
            Matcher matcher = METHOD_REG.matcher((CharSequence)line);
            boolean found = matcher.find();
            if (!line.endsWith(";") && !line.endsWith(",") && found) {
                method = new MethodInfo(method, matcher.group("indent"));
                method.lines.add(line);
                boolean invalid = false;
                String args = matcher.group("parameters");
                if (args != null) {
                    for (String str : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)args)) {
                        if (str.indexOf(32) == -1) {
                            invalid = true;
                            break;
                        }
                        method.addVar(str);
                    }
                }
                if (!invalid && !METHOD_DEC_END.matcher((CharSequence)line).find()) continue;
                if (method.parent != null) {
                    method.parent.children.remove(method);
                }
                if ((method = method.parent) != null) continue;
                output.add(line);
                continue;
            }
            if (method != null && method.ENDING.equals(line)) {
                method.lines.add(line);
                if (method.parent == null) {
                    for (String l : Splitter.on((String)Constants.NEWLINE).split((CharSequence)method.rename(null))) {
                        output.add(l);
                    }
                }
                method = method.parent;
                continue;
            }
            if (method != null) {
                method.lines.add(line);
                matcher = CATCH_REG.matcher((CharSequence)line);
                if (matcher.find()) {
                    method.addVar(matcher.group(1));
                    continue;
                }
                matcher = VAR_CALL.matcher((CharSequence)line);
                while (matcher.find()) {
                    String match = matcher.group();
                    if (match.startsWith("return") || match.startsWith("throw")) continue;
                    method.addVar(match);
                }
                continue;
            }
            output.add(line);
        }
        return Joiner.on((String)Constants.NEWLINE).join(output);
    }

    private FmlCleanup() {
        this.last = new HashMap();
        this.last.put("byte", new Holder(0, false, "b"));
        this.last.put("char", new Holder(0, false, "c"));
        this.last.put("short", new Holder(1, false, "short"));
        this.last.put("int", new Holder(0, true, "i", "j", "k", "l"));
        this.last.put("boolean", new Holder(0, true, "flag"));
        this.last.put("double", new Holder(0, false, "d"));
        this.last.put("float", new Holder(0, true, "f"));
        this.last.put("File", new Holder(1, true, "file"));
        this.last.put("String", new Holder(0, true, "s"));
        this.last.put("Class", new Holder(0, true, "oclass"));
        this.last.put("Long", new Holder(0, true, "olong"));
        this.last.put("Byte", new Holder(0, true, "obyte"));
        this.last.put("Short", new Holder(0, true, "oshort"));
        this.last.put("Boolean", new Holder(0, true, "obool"));
        this.last.put("Package", new Holder(0, true, "opackage"));
        this.remap = new HashMap();
        this.remap.put("long", "int");
    }

    private FmlCleanup(FmlCleanup parent) {
        this.last = Maps.newHashMap();
        for (Map.Entry<String, Holder> entry : parent.last.entrySet()) {
            Holder v = entry.getValue();
            this.last.put(entry.getKey(), new Holder(v.id, v.skip_zero, v.names));
        }
        this.remap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : parent.remap.entrySet()) {
            this.remap.put(entry.getKey(), (String)entry.getValue());
        }
    }

    private String getName(String type, String var) {
        String name;
        String index = null;
        String findtype = type;
        while (findtype.contains("[][]")) {
            findtype = findtype.replaceAll("\\[\\]\\[\\]", "[]");
        }
        if (this.last.containsKey(findtype)) {
            index = findtype;
        } else if (this.remap.containsKey(type)) {
            index = this.remap.get(type);
        }
        if (Strings.isNullOrEmpty((String)index) && (CAPS_START.matcher((CharSequence)type).find() || ARRAY.matcher((CharSequence)type).find())) {
            type = type.replace("...", "[]");
            while (type.contains("[][]")) {
                type = type.replaceAll("\\[\\]\\[\\]", "[]");
            }
            String name2 = StringUtils.lower(type);
            name2 = name2.replace(".", "");
            boolean skip_zero = true;
            if (Pattern.compile((String)"\\[").matcher((CharSequence)type).find()) {
                skip_zero = true;
                name2 = "a" + name2;
                name2 = name2.replace("[]", "").replace("...", "");
            }
            this.last.put(type, new Holder(0, skip_zero, name2));
            index = type;
        }
        if (Strings.isNullOrEmpty((String)index)) {
            return StringUtils.lower(type);
        }
        Holder holder = this.last.get(index);
        int id = holder.id;
        List<String> names = holder.names;
        int ammount = names.size();
        if (ammount == 1) {
            name = names.get(0) + (id == 0 && holder.skip_zero ? "" : Integer.valueOf(id));
        } else {
            int num = id / ammount;
            name = names.get(id % ammount) + (id < ammount && holder.skip_zero ? "" : Integer.valueOf(num));
        }
        ++holder.id;
        return name;
    }

    private class Holder {
        public int id;
        public boolean skip_zero;
        public final List<String> names = Lists.newArrayList();

        public Holder(int t1, boolean skip_zero, String ... names) {
            this.id = t1;
            this.skip_zero = skip_zero;
            Collections.addAll(this.names, names);
        }

        public Holder(int t1, boolean skip_zero, List<String> names) {
            this.id = t1;
            this.skip_zero = skip_zero;
            this.names.addAll(names);
        }
    }

    private static class MethodInfo {
        private MethodInfo parent = null;
        private List<Object> lines = Lists.newArrayList();
        private List<String> vars = Lists.newArrayList();
        private List<MethodInfo> children = Lists.newArrayList();
        private final String ENDING;

        private MethodInfo(MethodInfo parent, String indent) {
            this.parent = parent;
            this.ENDING = indent + "}";
            if (parent != null) {
                parent.children.add(this);
                parent.lines.add(this);
            }
        }

        private void addVar(String info) {
            this.vars.add(info);
        }

        private String rename(FmlCleanup namer) {
            namer = namer == null ? new FmlCleanup() : new FmlCleanup(namer);
            HashMap renames = Maps.newHashMap();
            HashMap unnamed = Maps.newHashMap();
            for (String var : this.vars) {
                String[] split = var.split(" ");
                if (!split[1].startsWith("var")) {
                    renames.put(split[1], namer.getName(split[0], split[1]));
                    continue;
                }
                unnamed.put(split[1], split[0]);
            }
            if (unnamed.size() > 0) {
                ArrayList sorted = new ArrayList(unnamed.keySet());
                Collections.sort(sorted, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        if (o1.length() < o2.length()) {
                            return -1;
                        }
                        if (o1.length() > o2.length()) {
                            return 1;
                        }
                        return o1.compareTo(o2);
                    }
                });
                for (String s : sorted) {
                    renames.put(s, namer.getName((String)unnamed.get(s), s));
                }
            }
            StringBuilder buf = new StringBuilder();
            for (Object line : this.lines) {
                if (line instanceof MethodInfo) {
                    buf.append(((MethodInfo)line).rename(namer)).append(Constants.NEWLINE);
                    continue;
                }
                buf.append((String)line).append(Constants.NEWLINE);
            }
            String body = buf.toString();
            if (renames.size() > 0) {
                ArrayList sortedKeys = new ArrayList(renames.keySet());
                Collections.sort(sortedKeys, COMPARATOR);
                for (String key : sortedKeys) {
                    if (!VAR.matcher((CharSequence)key).matches()) continue;
                    body = body.replace(key, (CharSequence)renames.get(key));
                }
            }
            return body.substring(0, body.length() - Constants.NEWLINE.length());
        }
    }
}

