/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;

public final class StringUtils {
    private StringUtils() {
    }

    public static String lower(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String fromUTF8Stream(InputStream stream) throws IOException {
        return new String(ByteStreams.toByteArray((InputStream)stream), Charsets.UTF_8);
    }

    public static ImmutableList<String> lines(final String text) {
        try {
            return ImmutableList.copyOf((Collection)CharStreams.readLines((InputSupplier)new InputSupplier<StringReader>(){

                public StringReader getInput() throws IOException {
                    return new StringReader(text);
                }
            }));
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }
}

