/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user.lib;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.json.JsonFactory;
import net.minecraftforge.gradle.json.LiteLoaderJson;
import net.minecraftforge.gradle.tasks.user.EtagDownloadTask;
import net.minecraftforge.gradle.user.lib.UserLibBasePlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class LiteLoaderPlugin
extends UserLibBasePlugin {
    private LiteLoaderJson.Artifact llArtifact;

    @Override
    public void applyPlugin() {
        super.applyPlugin();
        this.commonApply();
    }

    @Override
    public void applyOverlayPlugin() {
        super.applyOverlayPlugin();
        this.commonApply();
    }

    private void commonApply() {
        this.project.allprojects((Action)new Action<Project>(){

            public void execute(Project proj) {
                LiteLoaderPlugin.this.addMavenRepo(proj, "liteloaderRepo", "http://dl.liteloader.com/versions/");
            }
        });
        final DelayedFile json = this.delayedFile("{CACHE_DIR}/minecraft/liteloader.json");
        EtagDownloadTask task = this.makeTask("getLiteLoaderJson", EtagDownloadTask.class);
        task.setUrl("http://dl.liteloader.com/versions/versions.json");
        task.setFile((Object)json);
        task.setDieWithError(false);
        this.project.getTasks().getByName("setupCIWorkspace").dependsOn(new Object[]{task});
        this.project.getTasks().getByName("setupDevWorkspace").dependsOn(new Object[]{task});
        this.project.getTasks().getByName("setupDecompWorkspace").dependsOn(new Object[]{task});
        task.doLast(new Action(){

            public void execute(Object arg0) {
                EtagDownloadTask task = (EtagDownloadTask)((Object)arg0);
                try {
                    LiteLoaderPlugin.this.readJsonDep(task.getFile());
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
        this.project.afterEvaluate(new Action(){

            public void execute(Object arg0) {
                if (json.call().exists()) {
                    try {
                        LiteLoaderPlugin.this.readJsonDep(json.call());
                    }
                    catch (IOException e) {
                        Throwables.propagate((Throwable)e);
                    }
                }
            }
        });
    }

    private final void readJsonDep(File json) throws IOException {
        if (this.llArtifact != null) {
            return;
        }
        String mcVersion = this.delayedString("{MC_VERSION}").call();
        LiteLoaderJson loaded = JsonFactory.loadLiteLoaderJson(json);
        LiteLoaderJson.VersionObject obj = loaded.versions.get(mcVersion);
        if (obj == null) {
            throw new RuntimeException("LiteLoader does not have an ForgeGradle compatible edition for Minecraft " + mcVersion);
        }
        this.llArtifact = obj.latest;
        this.project.getLogger().info("LiteLoader dep: " + this.llArtifact.getMcpDepString());
        this.project.getDependencies().add(this.actualApiName(), (Object)this.llArtifact.getMcpDepString());
    }

    @Override
    protected String getClientRunClass() {
        return "com.mumfrey.liteloader.debug.Start";
    }

    @Override
    protected Iterable<String> getClientRunArgs() {
        return new ArrayList<String>(0);
    }

    @Override
    protected String getServerRunClass() {
        return "net.minecraft.server.MinecraftServer";
    }

    @Override
    protected Iterable<String> getServerRunArgs() {
        return new ArrayList<String>(0);
    }

    @Override
    String actualApiName() {
        return "liteloader";
    }

    @Override
    protected String getJarExtension() {
        return "litemod";
    }

    @Override
    public boolean shouldOverrideRunConfigs() {
        return true;
    }
}

