/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user.reobf;

import COM.rl.NameProvider;
import COM.rl.obf.RetroGuardImpl;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedThingy;
import net.minecraftforge.gradle.extrastuff.ReobfExceptor;
import net.minecraftforge.gradle.tasks.dev.ObfuscateTask;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ObfArtifact
extends AbstractPublishArtifact {
    Object toObfArtifact;
    private String name;
    private String extension;
    private String classifier;
    private Date date;
    private File file;
    private FileCollection classpath;
    private String type;
    private final Closure<Object> toObfGenerator;
    private final ReobfTask caller;
    final ArtifactSpec spec;

    public ObfArtifact(AbstractArchiveTask toObf, ArtifactSpec artifactSpec, ReobfTask task) {
        this(new DelayedThingy(toObf), artifactSpec, task);
        this.toObfArtifact = (PublishArtifact)toObf;
    }

    public ObfArtifact(PublishArtifact toObf, ArtifactSpec artifactSpec, ReobfTask task) {
        this(new DelayedThingy(toObf), artifactSpec, task);
        this.toObfArtifact = toObf;
    }

    public ObfArtifact(File toObf, ArtifactSpec artifactSpec, ReobfTask task) {
        this(new DelayedThingy(toObf), artifactSpec, task);
        this.toObfArtifact = toObf;
    }

    public ObfArtifact(Closure<Object> toObf, ArtifactSpec outputSpec, ReobfTask task) {
        super(new Object[]{task});
        this.caller = task;
        this.toObfGenerator = toObf;
        this.spec = outputSpec;
    }

    public File getToObf() {
        Object toObf = null;
        if (this.toObfGenerator != null) {
            toObf = this.toObfGenerator.call();
        }
        if (toObf == null) {
            return null;
        }
        if (toObf instanceof File) {
            return (File)toObf;
        }
        return new File(toObf.toString());
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.toObfArtifact != null) {
            return ((File)this.toObfArtifact).getName();
        }
        if (this.spec.getBaseName() != null) {
            return this.spec.getBaseName().toString();
        }
        return this.getFile() == null ? null : this.getFile().getName();
    }

    public FileCollection getClasspath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        if (this.spec.getClasspath() != null) {
            return (FileCollection)this.spec.getClasspath();
        }
        return null;
    }

    public String getExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.toObfArtifact != null) {
            return ((PublishArtifact)this.toObfArtifact).getExtension();
        }
        if (this.spec.getExtension() != null) {
            return this.spec.getExtension().toString();
        }
        return Files.getFileExtension(this.getFile() == null ? null : this.getFile().getName());
    }

    public String getType() {
        return this.getExtension();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        if (this.classifier != null) {
            return this.classifier;
        }
        if (this.toObfArtifact != null) {
            return ((PublishArtifact)this.toObfArtifact).getClassifier();
        }
        if (this.spec.getClassifier() != null) {
            return this.spec.getClassifier().toString();
        }
        return null;
    }

    public Date getDate() {
        if (this.date == null) {
            File file = this.getFile();
            if (file == null) {
                return null;
            }
            long modified = file.lastModified();
            if (modified == 0L) {
                return null;
            }
            new Date(modified);
        }
        return this.date;
    }

    public File getFile() {
        if (this.file == null) {
            File input = this.getToObf();
            this.spec.resolve();
            this.name = this.spec.getArchiveName().toString();
            this.classifier = this.spec.getClassifier().toString();
            this.extension = this.spec.getExtension().toString();
            this.classpath = (FileCollection)this.spec.getClasspath();
            this.file = new File(input.getParentFile(), this.spec.getArchiveName().toString());
            return this.file;
        }
        return this.file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    void generate(ReobfExceptor exc, File defaultSrg, File extraSrg) throws Exception {
        File toObf = this.getToObf();
        if (toObf == null) {
            throw new InvalidUserDataException("Unable to obfuscate as the file to obfuscate has not been specified");
        }
        File output = this.getFile();
        File toObfTemp = File.createTempFile("reobfed", ".jar", this.caller.getTemporaryDir());
        Files.copy((File)toObf, (File)toObfTemp);
        File srg = this.spec.srg == null ? defaultSrg : this.spec.srg;
        boolean isTempSrg = false;
        if (exc != null && srg != defaultSrg) {
            File tempSrg = File.createTempFile("reobf", ".srg", this.caller.getTemporaryDir());
            isTempSrg = true;
            exc.buildSrg(srg, tempSrg);
            srg = tempSrg;
        }
        if (this.caller.getUseRetroGuard()) {
            this.applyRetroGuard(toObfTemp, output, srg, extraSrg);
        } else {
            this.applySpecialSource(toObfTemp, output, srg, extraSrg);
        }
        toObfTemp.delete();
        if (isTempSrg) {
            srg.delete();
        }
        System.gc();
    }

    private void applySpecialSource(File input, File output, File srg, File extraSrg) throws IOException {
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(srg);
        mapping.loadMappings(extraSrg);
        JarRemapper remapper = new JarRemapper(null, mapping);
        Jar inputJar = Jar.init((File)input);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(inputJar));
        if (this.classpath != null) {
            inheritanceProviders.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)new URLClassLoader(ObfuscateTask.toUrls(this.classpath))));
        }
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        remapper.remapJar(inputJar, output);
    }

    private void applyRetroGuard(File input, File output, File srg, File extraSrg) throws Exception {
        File cfg = new File(this.caller.getTemporaryDir(), "retroguard.cfg");
        File log = new File(this.caller.getTemporaryDir(), "retroguard.log");
        File script = new File(this.caller.getTemporaryDir(), "retroguard.script");
        File packedJar = new File(this.caller.getTemporaryDir(), "rgPackaged.jar");
        File outPackedJar = new File(this.caller.getTemporaryDir(), "rgOutPackaged.jar");
        HashSet modFiles = Sets.newHashSet();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(packedJar));
        ZipEntry entry = null;
        ZipInputStream in = new ZipInputStream(new FileInputStream(input));
        while ((entry = in.getNextEntry()) != null) {
            modFiles.add(entry.getName());
            out.putNextEntry(entry);
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            in.closeEntry();
            out.closeEntry();
        }
        in.close();
        HashSet antiDuplicate = Sets.newHashSet();
        for (File f : this.classpath) {
            if (f.isDirectory()) {
                LinkedList<File> dirStack = new LinkedList<File>();
                dirStack.push(f);
                String root = f.getCanonicalPath();
                while (!dirStack.isEmpty()) {
                    File dir = (File)dirStack.pop();
                    for (File file : dir.listFiles()) {
                        if (f.isDirectory()) {
                            dirStack.push(file);
                            continue;
                        }
                        String relPath = file.getCanonicalPath().replace(root, "");
                        if (antiDuplicate.contains(relPath) || modFiles.contains(relPath)) continue;
                        FileInputStream inStream = new FileInputStream(f);
                        antiDuplicate.add(relPath);
                        out.putNextEntry(new ZipEntry(relPath));
                        ByteStreams.copy((InputStream)inStream, (OutputStream)out);
                        out.closeEntry();
                        inStream.close();
                    }
                }
                continue;
            }
            if (!f.getName().endsWith("jar") && !f.getName().endsWith("zip")) continue;
            in = new ZipInputStream(new FileInputStream(f));
            while ((entry = in.getNextEntry()) != null) {
                if (antiDuplicate.contains(entry.getName()) || modFiles.contains(entry.getName())) continue;
                antiDuplicate.add(entry.getName());
                out.putNextEntry(new ZipEntry(entry.getName()));
                ByteStreams.copy((InputStream)in, (OutputStream)out);
                out.closeEntry();
            }
            in.close();
        }
        out.close();
        this.generateRgConfig(cfg, script, srg, extraSrg);
        String[] args = new String[]{"-notch", cfg.getCanonicalPath()};
        ClassLoader loader = BasePlugin.class.getClassLoader();
        if (this.classpath != null) {
            loader = new URLClassLoader(ObfuscateTask.toUrls(this.classpath), BasePlugin.class.getClassLoader());
        }
        NameProvider.parseCommandLine((String[])args);
        RetroGuardImpl.obfuscate((File)packedJar, (File)outPackedJar, (File)script, (File)log);
        loader = null;
        ZipOutputStream out2 = new ZipOutputStream(new FileOutputStream(output));
        ZipEntry entry2 = null;
        ZipInputStream in2 = new ZipInputStream(new FileInputStream(outPackedJar));
        while ((entry2 = in2.getNextEntry()) != null) {
            if (!modFiles.contains(entry2.getName())) continue;
            out2.putNextEntry(entry2);
            ByteStreams.copy((InputStream)in2, (OutputStream)out2);
            in2.closeEntry();
            out2.closeEntry();
        }
        in2.close();
        out2.close();
    }

    private void generateRgConfig(File config, File script, File srg, File extraSrg) throws IOException {
        Object[] lines = new String[]{"reob = " + srg.getCanonicalPath(), "reob = " + extraSrg.getCanonicalPath(), "script = " + script.getCanonicalPath(), "verbose = 0", "quiet = 1", "fullmap = 0", "startindex = 0"};
        Files.write((CharSequence)Joiner.on((String)Constants.NEWLINE).join(lines), (File)config, (Charset)Charset.defaultCharset());
        lines = new String[]{".option Application", ".option Applet", ".option Repackage", ".option Annotations", ".option MapClassString", ".attribute LineNumberTable", ".attribute EnclosingMethod", ".attribute Deprecated"};
        Files.write((CharSequence)Joiner.on((String)Constants.NEWLINE).join(lines), (File)script, (Charset)Charset.defaultCharset());
    }
}

