/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class EtagDownloadTask
extends DefaultTask {
    Object url;
    Object file;
    boolean dieWithError;

    @TaskAction
    public void doTask() throws IOException {
        URL url = this.getUrl();
        File outFile = this.getFile();
        File etagFile = this.getProject().file((Object)(this.getFile().getPath() + ".etag"));
        String etag = etagFile.exists() ? Files.toString((File)etagFile, (Charset)Charsets.UTF_8) : "";
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setInstanceFollowRedirects(true);
        con.setRequestProperty("If-None-Match", etag);
        try {
            con.connect();
        }
        catch (Throwable e) {
            this.error(e.getLocalizedMessage());
        }
        String error = null;
        switch (con.getResponseCode()) {
            case 404: {
                error = "" + url + "  404'ed!";
                break;
            }
            case 304: {
                this.setDidWork(false);
                break;
            }
            case 200: {
                InputStream stream = con.getInputStream();
                Files.write((byte[])ByteStreams.toByteArray((InputStream)stream), (File)outFile);
                stream.close();
                break;
            }
            default: {
                error = "Unexpected reponse " + con.getResponseCode() + " from " + url;
            }
        }
        con.disconnect();
        if (error != null) {
            this.error(error);
        }
    }

    private void error(String error) {
        if (this.dieWithError) {
            throw new RuntimeException(error);
        }
        this.getLogger().error(error);
    }

    public URL getUrl() throws MalformedURLException {
        while (this.url instanceof Closure) {
            this.url = ((Closure)this.url).call();
        }
        return new URL(this.url.toString());
    }

    public void setUrl(Object url) {
        this.url = url;
    }

    public File getFile() {
        return this.getProject().file(this.file);
    }

    public void setFile(Object file) {
        this.file = file;
    }

    public boolean isDieWithError() {
        return this.dieWithError;
    }

    public void setDieWithError(boolean dieWithError) {
        this.dieWithError = dieWithError;
    }
}

