/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.cloudbees.diff.Diff;
import com.cloudbees.diff.PatchException;
import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GeneratePatches
extends DefaultTask {
    @OutputDirectory
    DelayedFile patchDir;
    @InputFiles
    DelayedFile changed;
    @InputFiles
    DelayedFile original;
    @Input
    String originalPrefix = "";
    @Input
    String changedPrefix = "";
    private Set<File> created = new HashSet<File>();

    @TaskAction
    public void doTask() throws IOException, PatchException {
        this.created.clear();
        this.getPatchDir().mkdirs();
        this.processFiles(this.getSupplier(this.original.call()), this.getSupplier(this.changed.call()));
        this.removeOld(this.getPatchDir());
    }

    private InputSupplier getSupplier(File file) throws IOException {
        if (file.isDirectory()) {
            return new FolderSupplier(file);
        }
        ZipInputSupplier ret = new ZipInputSupplier();
        ret.readZip(file);
        return ret;
    }

    private void removeOld(File dir) throws IOException {
        final ArrayList directories = new ArrayList();
        ConfigurableFileTree tree = this.getProject().fileTree((Object)dir);
        tree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dir) {
                directories.add(dir.getFile());
            }

            public void visitFile(FileVisitDetails f) {
                File file = f.getFile();
                if (!GeneratePatches.this.created.contains(file)) {
                    GeneratePatches.this.getLogger().debug("Removed patch: " + f.getRelativePath());
                    file.delete();
                }
            }
        });
        Collections.sort(directories, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                int r = o1.compareTo(o2);
                if (r < 0) {
                    return 1;
                }
                if (r > 0) {
                    return -1;
                }
                return 0;
            }
        });
        for (File f : directories) {
            if (f.listFiles().length != 0) continue;
            this.getLogger().debug("Removing empty dir: " + f);
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFiles(InputSupplier original, InputSupplier changed) throws IOException {
        List paths = original.gatherAll("");
        for (String path : paths) {
            path = path.replace('\\', '/');
            InputStream o = original.getInput(path);
            InputStream c = changed.getInput(path);
            try {
                this.processFile(path, o, c);
            }
            finally {
                if (o != null) {
                    o.close();
                }
                if (c == null) continue;
                c.close();
            }
        }
    }

    public void processFile(String relative, InputStream original, InputStream changed) throws IOException {
        this.getLogger().debug("Diffing: " + relative);
        File patchFile = new File(this.getPatchDir(), relative + ".patch");
        if (changed == null) {
            this.getLogger().debug("    Changed File does not exist");
            return;
        }
        byte[] oData = ByteStreams.toByteArray((InputStream)original);
        byte[] cData = ByteStreams.toByteArray((InputStream)changed);
        Diff diff = Diff.diff((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(oData), Charsets.UTF_8), (Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(cData), Charsets.UTF_8), (boolean)false);
        if (!relative.startsWith("/")) {
            relative = "/" + relative;
        }
        if (!diff.isEmpty()) {
            String unidiff = diff.toUnifiedDiff(this.originalPrefix + relative, this.changedPrefix + relative, (Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(oData), Charsets.UTF_8), (Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(cData), Charsets.UTF_8), 3);
            unidiff = unidiff.replace("\r\n", "\n");
            unidiff = unidiff.replace("\n\\ No newline at end of file\n", "\n");
            String olddiff = "";
            if (patchFile.exists()) {
                olddiff = Files.toString((File)patchFile, (Charset)Charsets.UTF_8);
            }
            if (!olddiff.equals(unidiff)) {
                this.getLogger().debug("Writing patch: " + patchFile);
                patchFile.getParentFile().mkdirs();
                Files.touch((File)patchFile);
                Files.write((CharSequence)unidiff, (File)patchFile, (Charset)Charsets.UTF_8);
            } else {
                this.getLogger().debug("Patch did not change");
            }
            this.created.add(patchFile);
        }
    }

    public FileCollection getChanged() {
        File f = this.changed.call();
        if (f.isDirectory()) {
            return this.getProject().fileTree((Object)f);
        }
        return this.getProject().files(new Object[]{f});
    }

    public void setChanged(DelayedFile changed) {
        this.changed = changed;
    }

    public FileCollection getOriginal() {
        File f = this.original.call();
        if (f.isDirectory()) {
            return this.getProject().fileTree((Object)f);
        }
        return this.getProject().files(new Object[]{f});
    }

    public void setOriginal(DelayedFile original) {
        this.original = original;
    }

    public File getPatchDir() {
        return this.patchDir.call();
    }

    public void setPatchDir(DelayedFile patchDir) {
        this.patchDir = patchDir;
    }

    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    public void setOriginalPrefix(String originalPrefix) {
        this.originalPrefix = originalPrefix;
    }

    public String getChangedPrefix() {
        return this.changedPrefix;
    }

    public void setChangedPrefix(String changedPrefix) {
        this.changedPrefix = changedPrefix;
    }
}

